/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.userprofile.AttributeContext;
import org.keycloak.userprofile.AttributeMetadata;
import org.keycloak.userprofile.AttributeValidatorMetadata;
import org.keycloak.userprofile.Attributes;
import org.keycloak.userprofile.DefaultAttributes;
import org.keycloak.userprofile.DefaultUserProfile;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileMetadata;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.UserProfileProviderFactory;
import org.keycloak.userprofile.validator.BlankAttributeValidator;
import org.keycloak.validate.ValidatorConfig;

public abstract class AbstractUserProfileProvider<U extends UserProfileProvider>
implements UserProfileProvider,
UserProfileProviderFactory<U> {
    public static final String CONFIG_ADMIN_READ_ONLY_ATTRIBUTES = "admin-read-only-attributes";
    public static final String CONFIG_READ_ONLY_ATTRIBUTES = "read-only-attributes";
    public static final String MAX_EMAIL_LOCAL_PART_LENGTH = "max-email-local-part-length";
    private static final String[] DEFAULT_READ_ONLY_ATTRIBUTES = new String[]{"KERBEROS_PRINCIPAL", "LDAP_ID", "LDAP_ENTRY_DN", "CREATED_TIMESTAMP", "createTimestamp", "modifyTimestamp", "userCertificate", "saml.persistent.name.id.for.*", "ENABLED", "EMAIL_VERIFIED", "disabledReason"};
    private static final String[] DEFAULT_ADMIN_READ_ONLY_ATTRIBUTES = new String[]{"KERBEROS_PRINCIPAL", "LDAP_ID", "LDAP_ENTRY_DN", "CREATED_TIMESTAMP", "createTimestamp", "modifyTimestamp"};
    private static final Pattern readOnlyAttributesPattern = AbstractUserProfileProvider.getRegexPatternString(DEFAULT_READ_ONLY_ATTRIBUTES);
    private static final Pattern adminReadOnlyAttributesPattern = AbstractUserProfileProvider.getRegexPatternString(DEFAULT_ADMIN_READ_ONLY_ATTRIBUTES);
    protected final Map<UserProfileContext, UserProfileMetadata> contextualMetadataRegistry;
    protected final KeycloakSession session;

    private static boolean editUsernameCondition(AttributeContext c) {
        KeycloakSession session = c.getSession();
        KeycloakContext context = session.getContext();
        RealmModel realm = context.getRealm();
        if (UserProfileContext.REGISTRATION.equals((Object)c.getContext()) || UserProfileContext.IDP_REVIEW.equals((Object)c.getContext()) || AbstractUserProfileProvider.isNewUser(c)) {
            return !realm.isRegistrationEmailAsUsername();
        }
        if (realm.isRegistrationEmailAsUsername()) {
            return false;
        }
        return realm.isEditUsernameAllowed();
    }

    private static boolean readUsernameCondition(AttributeContext c) {
        KeycloakSession session = c.getSession();
        KeycloakContext context = session.getContext();
        RealmModel realm = context.getRealm();
        switch (c.getContext()) {
            case REGISTRATION: 
            case IDP_REVIEW: {
                return !realm.isRegistrationEmailAsUsername();
            }
            case UPDATE_PROFILE: {
                if (realm.isRegistrationEmailAsUsername()) {
                    return false;
                }
                return realm.isEditUsernameAllowed();
            }
            case UPDATE_EMAIL: {
                return false;
            }
        }
        return true;
    }

    private static boolean editEmailCondition(AttributeContext c) {
        RealmModel realm = c.getSession().getContext().getRealm();
        if (UserProfileContext.REGISTRATION.equals((Object)c.getContext()) || UserProfileContext.USER_API.equals((Object)c.getContext())) {
            return true;
        }
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.UPDATE_EMAIL)) {
            return !UserProfileContext.UPDATE_PROFILE.equals((Object)c.getContext()) && !UserProfileContext.ACCOUNT.equals((Object)c.getContext());
        }
        return AbstractUserProfileProvider.isNewUser(c) || !realm.isRegistrationEmailAsUsername() || realm.isEditUsernameAllowed();
    }

    private static boolean readEmailCondition(AttributeContext c) {
        RealmModel realm;
        UserProfileContext context = c.getContext();
        if (UserProfileContext.REGISTRATION.equals((Object)context) || UserProfileContext.USER_API.equals((Object)c.getContext())) {
            return true;
        }
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.UPDATE_EMAIL)) {
            return !UserProfileContext.UPDATE_PROFILE.equals((Object)context);
        }
        if (UserProfileContext.UPDATE_PROFILE.equals((Object)context) && (realm = c.getSession().getContext().getRealm()).isRegistrationEmailAsUsername()) {
            return realm.isEditUsernameAllowed();
        }
        return true;
    }

    public static Pattern getRegexPatternString(String[] builtinReadOnlyAttributes) {
        if (builtinReadOnlyAttributes != null) {
            ArrayList<String> readOnlyAttributes = new ArrayList<String>(Arrays.asList(builtinReadOnlyAttributes));
            String regexStr = readOnlyAttributes.stream().map(configAttrName -> configAttrName.endsWith("*") ? "^" + Pattern.quote(configAttrName.substring(0, configAttrName.length() - 1)) + ".*$" : "^" + Pattern.quote(configAttrName) + "$").collect(Collectors.joining("|"));
            regexStr = "(?i:" + regexStr + ")";
            return Pattern.compile(regexStr);
        }
        return null;
    }

    private static boolean isInternationalizationEnabled(AttributeContext context) {
        RealmModel realm = context.getSession().getContext().getRealm();
        return realm.isInternationalizationEnabled();
    }

    private static boolean isNewUser(AttributeContext c) {
        return c.getUser() == null;
    }

    public AbstractUserProfileProvider() {
        this(null, new HashMap<UserProfileContext, UserProfileMetadata>());
    }

    public AbstractUserProfileProvider(KeycloakSession session, Map<UserProfileContext, UserProfileMetadata> contextualMetadataRegistry) {
        this.session = session;
        this.contextualMetadataRegistry = contextualMetadataRegistry;
    }

    public UserProfile create(UserProfileContext context, UserModel user) {
        return this.createUserProfile(context, user.getAttributes(), user);
    }

    public UserProfile create(UserProfileContext context, Map<String, ?> attributes, UserModel user) {
        return this.createUserProfile(context, attributes, user);
    }

    public UserProfile create(UserProfileContext context, Map<String, ?> attributes) {
        return this.createUserProfile(context, attributes, null);
    }

    public U create(KeycloakSession session) {
        return this.create(session, this.contextualMetadataRegistry);
    }

    public void init(Config.Scope config) {
        this.contextualMetadataRegistry.clear();
        Pattern pattern = AbstractUserProfileProvider.getRegexPatternString(config.getArray(CONFIG_READ_ONLY_ATTRIBUTES));
        AttributeValidatorMetadata readOnlyValidator = null;
        if (pattern != null) {
            readOnlyValidator = this.createReadOnlyAttributeUnchangedValidator(pattern);
        }
        this.addContextualProfileMetadata(this.configureUserProfile(this.createBrokeringProfile(readOnlyValidator)));
        this.addContextualProfileMetadata(this.configureUserProfile(this.createAccountProfile(UserProfileContext.ACCOUNT, readOnlyValidator)));
        this.addContextualProfileMetadata(this.configureUserProfile(this.createDefaultProfile(UserProfileContext.UPDATE_PROFILE, readOnlyValidator)));
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.UPDATE_EMAIL)) {
            this.addContextualProfileMetadata(this.configureUserProfile(this.createDefaultProfile(UserProfileContext.UPDATE_EMAIL, readOnlyValidator)));
        }
        this.addContextualProfileMetadata(this.configureUserProfile(this.createRegistrationUserCreationProfile(readOnlyValidator)));
        this.addContextualProfileMetadata(this.configureUserProfile(this.createUserResourceValidation(config)));
    }

    private AttributeValidatorMetadata createReadOnlyAttributeUnchangedValidator(Pattern pattern) {
        return new AttributeValidatorMetadata("up-readonly-attribute-unchanged", ValidatorConfig.builder().config("pattern", (Object)pattern).build());
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public UPConfig getConfiguration() {
        return null;
    }

    public void setConfiguration(String configuration) {
    }

    protected abstract U create(KeycloakSession var1, Map<UserProfileContext, UserProfileMetadata> var2);

    protected UserProfileMetadata configureUserProfile(UserProfileMetadata metadata) {
        return metadata;
    }

    protected UserProfileMetadata configureUserProfile(UserProfileMetadata metadata, KeycloakSession session) {
        return metadata;
    }

    private Function<Attributes, UserModel> createUserFactory() {
        return new Function<Attributes, UserModel>(){
            private UserModel user;

            @Override
            public UserModel apply(Attributes attributes) {
                if (this.user == null) {
                    String userName = attributes.getFirstValue("username");
                    if (userName == null) {
                        userName = attributes.getFirstValue("email");
                    }
                    this.user = AbstractUserProfileProvider.this.session.users().addUser(AbstractUserProfileProvider.this.session.getContext().getRealm(), userName);
                }
                return this.user;
            }
        };
    }

    private UserProfile createUserProfile(UserProfileContext context, Map<String, ?> attributes, UserModel user) {
        UserProfileMetadata metadata = this.configureUserProfile(this.contextualMetadataRegistry.get(context), this.session);
        Attributes profileAttributes = this.createAttributes(context, attributes, user, metadata);
        return new DefaultUserProfile(metadata, profileAttributes, this.createUserFactory(), user, this.session);
    }

    protected Attributes createAttributes(UserProfileContext context, Map<String, ?> attributes, UserModel user, UserProfileMetadata metadata) {
        return new DefaultAttributes(context, attributes, user, metadata, this.session);
    }

    private void addContextualProfileMetadata(UserProfileMetadata metadata) {
        if (this.contextualMetadataRegistry.putIfAbsent(metadata.getContext(), metadata) != null) {
            throw new IllegalStateException("Multiple profile metadata found for context " + metadata.getContext());
        }
    }

    private UserProfileMetadata createRegistrationUserCreationProfile(AttributeValidatorMetadata readOnlyValidator) {
        UserProfileMetadata metadata = this.createDefaultProfile(UserProfileContext.REGISTRATION, readOnlyValidator);
        ((AttributeMetadata)metadata.getAttribute("username").get(0)).addValidators(Arrays.asList(new AttributeValidatorMetadata("up-registration-email-as-username-username-value"), new AttributeValidatorMetadata("up-registration-username-exists"), new AttributeValidatorMetadata("up-username-has-value")));
        ((AttributeMetadata)metadata.getAttribute("email").get(0)).addValidators(Collections.singletonList(new AttributeValidatorMetadata("up-registration-email-as-username-email-value")));
        return metadata;
    }

    private UserProfileMetadata createDefaultProfile(UserProfileContext context, AttributeValidatorMetadata readOnlyValidator) {
        UserProfileMetadata metadata = new UserProfileMetadata(context);
        metadata.addAttribute("username", -2, AbstractUserProfileProvider::editUsernameCondition, AbstractUserProfileProvider::readUsernameCondition, new AttributeValidatorMetadata[]{new AttributeValidatorMetadata("up-username-has-value"), new AttributeValidatorMetadata("up-duplicate-username"), new AttributeValidatorMetadata("up-username-mutation")}).setAttributeDisplayName("${username}");
        metadata.addAttribute("email", -1, AbstractUserProfileProvider::editEmailCondition, AbstractUserProfileProvider::readEmailCondition, new AttributeValidatorMetadata[]{new AttributeValidatorMetadata("up-blank-attribute-value", BlankAttributeValidator.createConfig("missingEmailMessage", false)), new AttributeValidatorMetadata("up-duplicate-email"), new AttributeValidatorMetadata("up-email-exists-as-username"), new AttributeValidatorMetadata("email", ValidatorConfig.builder().config("ignore.empty.value", (Object)true).build())}).setAttributeDisplayName("${email}");
        ArrayList<AttributeValidatorMetadata> readonlyValidators = new ArrayList<AttributeValidatorMetadata>();
        readonlyValidators.add(this.createReadOnlyAttributeUnchangedValidator(readOnlyAttributesPattern));
        if (readOnlyValidator != null) {
            readonlyValidators.add(readOnlyValidator);
        }
        metadata.addAttribute("kc.read.only", 1000, readonlyValidators);
        return metadata;
    }

    private UserProfileMetadata createBrokeringProfile(AttributeValidatorMetadata readOnlyValidator) {
        UserProfileMetadata metadata = new UserProfileMetadata(UserProfileContext.IDP_REVIEW);
        metadata.addAttribute("username", -2, AbstractUserProfileProvider::editUsernameCondition, AbstractUserProfileProvider::readUsernameCondition, new AttributeValidatorMetadata[]{new AttributeValidatorMetadata("up-brokering-federated-username-has-value")}).setAttributeDisplayName("${username}");
        metadata.addAttribute("email", -1, new AttributeValidatorMetadata[]{new AttributeValidatorMetadata("up-blank-attribute-value", BlankAttributeValidator.createConfig("missingEmailMessage", true))}).setAttributeDisplayName("${email}");
        ArrayList<AttributeValidatorMetadata> readonlyValidators = new ArrayList<AttributeValidatorMetadata>();
        readonlyValidators.add(this.createReadOnlyAttributeUnchangedValidator(readOnlyAttributesPattern));
        if (readOnlyValidator != null) {
            readonlyValidators.add(readOnlyValidator);
        }
        metadata.addAttribute("kc.read.only", 1000, readonlyValidators);
        return metadata;
    }

    private UserProfileMetadata createUserResourceValidation(Config.Scope config) {
        Pattern p = AbstractUserProfileProvider.getRegexPatternString(config.getArray(CONFIG_ADMIN_READ_ONLY_ATTRIBUTES));
        UserProfileMetadata metadata = new UserProfileMetadata(UserProfileContext.USER_API);
        metadata.addAttribute("username", -2, new AttributeValidatorMetadata[]{new AttributeValidatorMetadata("up-username-has-value")}).addWriteCondition(AbstractUserProfileProvider::editUsernameCondition);
        metadata.addAttribute("email", -1, new AttributeValidatorMetadata[]{new AttributeValidatorMetadata("email", ValidatorConfig.builder().config("ignore.empty.value", (Object)true).build())}).addWriteCondition(AbstractUserProfileProvider::editEmailCondition);
        ArrayList<AttributeValidatorMetadata> readonlyValidators = new ArrayList<AttributeValidatorMetadata>();
        if (p != null) {
            readonlyValidators.add(this.createReadOnlyAttributeUnchangedValidator(p));
        }
        readonlyValidators.add(this.createReadOnlyAttributeUnchangedValidator(adminReadOnlyAttributesPattern));
        metadata.addAttribute("kc.read.only", 1000, readonlyValidators);
        metadata.addAttribute("locale", -1, AbstractUserProfileProvider::isInternationalizationEnabled, AbstractUserProfileProvider::isInternationalizationEnabled, new AttributeValidatorMetadata[0]).setRequired(AttributeMetadata.ALWAYS_FALSE);
        return metadata;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name(CONFIG_READ_ONLY_ATTRIBUTES).type("MultivaluedString").helpText("Array of regular expressions to identify fields that should be treated read-only so users can't change them.").add().property().name(CONFIG_ADMIN_READ_ONLY_ATTRIBUTES).type("MultivaluedString").helpText("Array of regular expressions to identify fields that should be treated read-only so administrators can't change them.").add().property().name(MAX_EMAIL_LOCAL_PART_LENGTH).type("String").helpText("To set user profile max email local part length").add().build();
    }

    private UserProfileMetadata createAccountProfile(UserProfileContext context, AttributeValidatorMetadata readOnlyValidator) {
        UserProfileMetadata defaultProfile = this.createDefaultProfile(context, readOnlyValidator);
        defaultProfile.addAttribute("locale", -1, AbstractUserProfileProvider::isInternationalizationEnabled, AbstractUserProfileProvider::isInternationalizationEnabled, new AttributeValidatorMetadata[0]).setRequired(AttributeMetadata.ALWAYS_FALSE);
        return defaultProfile;
    }
}

