/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.deployment.binder.mpmetrics;

import io.quarkus.arc.processor.DotNames;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class MetricAnnotationInfo {
    private static final Logger log = Logger.getLogger(MetricAnnotationInfo.class);
    List<AnnotationValue> output = new ArrayList<AnnotationValue>();
    String name;
    String description;
    String unit;
    String[] tags;

    MetricAnnotationInfo(AnnotationInstance input, IndexView index, ClassInfo classInfo, MethodInfo method, FieldInfo fieldInfo) {
        String methodName;
        this.output.add(input.valueWithDefault(index, "displayName"));
        AnnotationValue value = input.value("unit");
        if (value != null) {
            this.output.add(value);
            if (!"none".equals(value.asString())) {
                this.unit = value.asString();
            }
        }
        value = input.valueWithDefault(index, "absolute");
        this.output.add(value);
        boolean absolute = value.asBoolean();
        this.name = input.valueWithDefault(index, "name").asString();
        if (input.target().kind() == AnnotationTarget.Kind.FIELD) {
            String fieldName = fieldInfo.name();
            this.name = absolute ? (this.name.isEmpty() ? fieldName : this.name) : MetricAnnotationInfo.append(classInfo.name().toString(), this.name.isEmpty() ? fieldName : this.name);
        }
        if (input.target().kind() == AnnotationTarget.Kind.METHOD) {
            methodName = method.name().replace("<init>", classInfo.simpleName());
            this.name = absolute ? (this.name.isEmpty() ? methodName : this.name) : MetricAnnotationInfo.append(classInfo.name().toString(), this.name.isEmpty() ? methodName : this.name);
        }
        if (input.target().kind() == AnnotationTarget.Kind.CLASS) {
            String string = methodName = method == null ? "<method>" : method.name();
            if (absolute) {
                this.name = MetricAnnotationInfo.append(this.name.isEmpty() ? classInfo.simpleName() : this.name, methodName);
            } else {
                DotName className = classInfo.name();
                this.name = this.name.isEmpty() ? MetricAnnotationInfo.append(className.toString(), methodName) : MetricAnnotationInfo.append(DotNames.packageName((DotName)className), this.name, methodName);
            }
        }
        this.output.add(AnnotationValue.createStringValue((String)"name", (String)this.name));
        this.description = input.valueWithDefault(index, "description").asString();
        this.output.add(AnnotationValue.createStringValue((String)"description", (String)this.description));
        this.tags = MetricAnnotationInfo.createTags(input, index);
        AnnotationValue[] tagValues = new AnnotationValue[this.tags.length];
        for (int i = 0; i < this.tags.length; ++i) {
            tagValues[i] = AnnotationValue.createStringValue((String)"tags", (String)this.tags[i]);
        }
        this.output.add(AnnotationValue.createArrayValue((String)"tags", (AnnotationValue[])tagValues));
        log.debugf("%s --> name='%s', description='%s', unit='%s', tags='%s'", new Object[]{input, this.name, this.description, this.unit == null ? "none" : this.unit, Arrays.asList(this.tags)});
    }

    static String append(String ... values) {
        StringBuilder b = new StringBuilder();
        for (String s : values) {
            if (b.length() > 0 && !s.isEmpty()) {
                b.append('.');
            }
            b.append(s);
        }
        return b.toString();
    }

    static String[] createTags(AnnotationInstance annotation, IndexView index) {
        ArrayList<String> tags = new ArrayList<String>();
        tags.add("scope");
        tags.add("application");
        for (String s : annotation.valueWithDefault(index, "tags").asStringArray()) {
            int pos = s.indexOf(61);
            if (pos > 0 && s.length() > 2) {
                tags.add(s.substring(0, pos));
                tags.add(s.substring(pos + 1));
                continue;
            }
            tags.add(s);
        }
        if (tags.size() % 2 == 1) {
            log.warnf("Problem parsing tag values from %s", (Object)annotation);
        }
        return tags.toArray(new String[0]);
    }

    public AnnotationValue[] getAnnotationValues() {
        return this.output.toArray(new AnnotationValue[0]);
    }
}

