/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.integration.resteasy;

import java.util.HashSet;
import java.util.Set;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.vertx.VertxResteasyReactiveRequestContext;
import org.keycloak.http.HttpCookie;
import org.keycloak.http.HttpResponse;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;

public final class QuarkusHttpResponse
implements HttpResponse,
KeycloakTransaction {
    private final ResteasyReactiveRequestContext requestContext;
    private Set<HttpCookie> cookies;
    private boolean transactionActive;
    private boolean writeCookiesOnTransactionComplete;

    public QuarkusHttpResponse(KeycloakSession session, ResteasyReactiveRequestContext requestContext) {
        this.requestContext = requestContext;
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this);
    }

    public int getStatus() {
        VertxResteasyReactiveRequestContext serverHttpResponse = (VertxResteasyReactiveRequestContext)this.requestContext.serverResponse();
        return serverHttpResponse.vertxServerResponse().getStatusCode();
    }

    public void setStatus(int statusCode) {
        this.requestContext.serverResponse().setStatusCode(statusCode);
    }

    public void addHeader(String name, String value) {
        this.requestContext.serverResponse().addResponseHeader((CharSequence)name, (CharSequence)value);
    }

    public void setHeader(String name, String value) {
        this.requestContext.serverResponse().setResponseHeader((CharSequence)name, (CharSequence)value);
    }

    public void setCookieIfAbsent(HttpCookie cookie) {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie is null");
        }
        if (this.cookies == null) {
            this.cookies = new HashSet<HttpCookie>();
        }
        if (this.cookies.add(cookie)) {
            if (this.writeCookiesOnTransactionComplete) {
                return;
            }
            this.addHeader("Set-Cookie", cookie.toHeaderValue());
        }
    }

    public void setWriteCookiesOnTransactionComplete() {
        this.writeCookiesOnTransactionComplete = true;
    }

    public void begin() {
        this.transactionActive = true;
    }

    public void commit() {
        if (!this.transactionActive) {
            throw new IllegalStateException("Transaction not active. Response already committed or rolled back");
        }
        try {
            this.addCookiesAfterTransaction();
        }
        finally {
            this.close();
        }
    }

    public void rollback() {
        this.close();
    }

    public void setRollbackOnly() {
    }

    public boolean getRollbackOnly() {
        return false;
    }

    public boolean isActive() {
        return this.transactionActive;
    }

    private void close() {
        this.transactionActive = false;
        this.cookies = null;
    }

    private void addCookiesAfterTransaction() {
        if (this.cookies == null || !this.writeCookiesOnTransactionComplete) {
            return;
        }
        for (HttpCookie cookie : this.cookies) {
            this.addHeader("Set-Cookie", cookie.toHeaderValue());
        }
    }
}

