/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.logging.Level;
import oracle.jdbc.clio.annotations.Format;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.Parameter;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.net.ns.NetException;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.NetStatImpl;
import oracle.net.nt.ProxyHelper;
import oracle.net.nt.SocketChannelWrapper;
import oracle.net.nt.TcpMultiplexer;
import oracle.net.nt.TimeoutInterruptHandler;

class TimeoutSocketChannel
extends SocketChannelWrapper {
    private static final String CLASS_NAME = TimeoutSocketChannel.class.getName();
    private int soTimeout = 0;
    NetStatImpl netStat = null;
    private final Proxy proxy;
    private final InetSocketAddress serverAddress;
    private Selector selector;
    private SelectionKey selectionKey;
    private boolean isWriteQueueEnabled = false;
    private final Queue<ByteBuffer> writeQueue = new ArrayDeque<ByteBuffer>(0);

    private TimeoutSocketChannel(InetSocketAddress serverAddress, NetStatImpl netStat, Proxy proxy, Diagnosable diagnosable) {
        super(null, diagnosable);
        this.serverAddress = serverAddress;
        this.netStat = netStat;
        this.proxy = proxy;
    }

    public TimeoutSocketChannel(InetSocketAddress serverAddress, int connectTimeout, NetStatImpl netStat, Proxy proxy, Diagnosable diagnosable) throws IOException, InterruptedIOException, TimeoutInterruptHandler.IOReadTimeoutException {
        this(serverAddress, netStat, proxy, diagnosable);
        try {
            this.connect(serverAddress, connectTimeout);
        }
        catch (IOException ioException) {
            this.disconnect();
            throw ioException;
        }
    }

    private void connect(InetSocketAddress socketAddress, int connectTimeout) throws IOException, InterruptedIOException, TimeoutInterruptHandler.IOReadTimeoutException {
        if (this.proxy == null) {
            this.initializeSocketChannel(this.serverAddress, connectTimeout);
        } else {
            this.initializeSocketChannel(this.proxy.address(), connectTimeout);
            ProxyHelper.connectViaProxy(this.proxy, this.serverAddress, this);
        }
    }

    private void initializeSocketChannel(SocketAddress remote, int connectTimeoutInMillis) throws IOException {
        this.selector = Selector.open();
        this.socketChannel = SocketChannel.open();
        this.socketChannel.configureBlocking(false);
        this.selectionKey = this.socketChannel.register(this.selector, 8);
        if (!this.socketChannel.connect(remote)) {
            long totalElapsedTimeInMillis = 0L;
            do {
                totalElapsedTimeInMillis = this.doSelect(connectTimeoutInMillis, totalElapsedTimeInMillis);
            } while (!this.socketChannel.finishConnect());
        }
        this.setInterestOps(1);
    }

    static CompletionStage<TimeoutSocketChannel> openAsync(InetSocketAddress serverAddress, int connectTimeout, NetStatImpl netStat, Diagnosable diagnosable, AsyncOutboundTimeoutHandler outboundTimeout, Executor asyncExecutor) {
        TimeoutSocketChannel newChannel = new TimeoutSocketChannel(serverAddress, netStat, null, diagnosable);
        return newChannel.connectAsync(connectTimeout, outboundTimeout, asyncExecutor).thenApply(nil -> newChannel);
    }

    private final CompletionStage<Void> connectAsync(int connectTimeout, AsyncOutboundTimeoutHandler outboundTimeout, Executor asyncExecutor) {
        if (this.proxy != null) {
            return CompletionStageUtil.failedStage(new IOException("Asynchronous proxy connection is not supported"));
        }
        try {
            SocketChannel newChannel = SocketChannel.open();
            outboundTimeout.setChannel(newChannel);
            this.socketChannel = newChannel;
            this.socketChannel.configureBlocking(false);
            if (this.socketChannel.connect(this.serverAddress)) {
                return CompletionStageUtil.completedStage(null);
            }
        }
        catch (IOException initializationFailure) {
            return CompletionStageUtil.failedStage(initializationFailure);
        }
        AsyncConnectTask connectTask = new AsyncConnectTask(asyncExecutor);
        connectTask.start();
        CompletionStage<Void> connectStage = connectTask.getConnectStage();
        if (connectTimeout > 0) {
            TimerTask keyCancellingTask = TimeoutInterruptHandler.scheduleTask(() -> connectTask.setTimeoutExpired(), connectTimeout);
            return connectStage.whenComplete((nil, err) -> keyCancellingTask.cancel());
        }
        return connectStage;
    }

    void setNetStat(NetStatImpl netStat) {
        this.netStat = netStat;
    }

    @Override
    public void disconnect() throws IOException {
        if (this.socketChannel != null && this.socketChannel.isOpen()) {
            try {
                this.socketChannel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.selector != null && this.selector.isOpen()) {
            try {
                this.selector.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }

    private IOException handleIOFailure(IOException e) {
        try {
            this.disconnect();
        }
        catch (Exception ex) {
            e.addSuppressed(ex);
        }
        return e;
    }

    @Override
    public int read(ByteBuffer dst) throws NetException, IOException {
        this.ensureOpen();
        try {
            int read = this.readFromSocket(dst);
            if (this.blockingReadMode && read == 0) {
                read = this.doSelectForRead(dst);
            }
            return read;
        }
        catch (IOException e) {
            throw this.handleIOFailure(e);
        }
        catch (CancelledKeyException | ClosedSelectorException ce) {
            NetException ne = new NetException(17909);
            ne.initCause(ce);
            throw ne;
        }
    }

    @Override
    public int write(ByteBuffer src) throws NetException, IOException {
        this.ensureOpen();
        try {
            if (this.isWriteQueueEnabled && src.hasRemaining() && !this.completeBlockedWrites()) {
                int writeBytes = src.remaining();
                this.enqueueWrite(src);
                return writeBytes;
            }
            int writeBytes = this.writeToSocket(src);
            if (src.hasRemaining() && !this.enqueueWrite(src)) {
                writeBytes += this.doSelectForWrite(src);
            }
            return writeBytes;
        }
        catch (IOException e) {
            throw this.handleIOFailure(e);
        }
        catch (CancelledKeyException | ClosedSelectorException ce) {
            NetException ne = new NetException(17909);
            ne.initCause(ce);
            throw ne;
        }
    }

    private void ensureOpen() throws NetException, IOException {
        if (this.socketChannel == null || !this.socketChannel.isOpen()) {
            throw new NetException(17909);
        }
    }

    private int doSelectForRead(ByteBuffer dst) throws IOException {
        this.setInterestOps(1);
        long totalElapsedTime = 0L;
        int readBytes = 0;
        do {
            totalElapsedTime = this.doSelect(this.soTimeout, totalElapsedTime);
            if (!this.selectionKey.isReadable()) continue;
            readBytes += this.readFromSocket(dst);
        } while (readBytes == 0);
        return readBytes;
    }

    private int doSelectForWrite(ByteBuffer src) throws IOException {
        this.setInterestOps(4);
        long totalElapsedTime = 0L;
        int writeBytes = 0;
        do {
            totalElapsedTime = this.doSelect(this.soTimeout, totalElapsedTime);
            if (!this.selectionKey.isWritable()) continue;
            writeBytes += this.writeToSocket(src);
        } while (src.hasRemaining());
        return writeBytes;
    }

    private long doSelect(long maxSelectTime, long totalElapsedTime) throws IOException {
        int selectionKeysCount = 0;
        if (maxSelectTime > 0L) {
            long timeRemaining = maxSelectTime - totalElapsedTime;
            if (timeRemaining <= 0L) {
                throw TimeoutSocketChannel.newTimeoutException();
            }
            long selectStartTime = System.currentTimeMillis();
            selectionKeysCount = this.selector.select(timeRemaining);
            if ((totalElapsedTime += System.currentTimeMillis() - selectStartTime) >= maxSelectTime) {
                throw TimeoutSocketChannel.newTimeoutException();
            }
        } else {
            selectionKeysCount = this.selector.select();
        }
        if (selectionKeysCount > 0) {
            this.selector.selectedKeys().clear();
        } else if (Thread.interrupted()) {
            throw new InterruptedIOException("Socket read interrupted");
        }
        return totalElapsedTime;
    }

    private void setInterestOps(int interestedOp) throws NetException, IOException {
        try {
            if (this.selectionKey.isValid() && this.selectionKey.interestOps() != interestedOp) {
                this.selectionKey.interestOps(interestedOp);
            }
        }
        catch (CancelledKeyException cke) {
            NetException ne = new NetException(17909);
            ne.initCause(cke);
            throw ne;
        }
    }

    private final int readFromSocket(ByteBuffer dst) throws IOException {
        this.ensureOpen();
        int read = this.socketChannel.read(dst);
        if (this.netStat != null && read > 0) {
            this.netStat.incrementBytesReceived(read);
        }
        if (read > 0) {
            this.tracep(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "readFromSocket", "{0} bytes", "{0} bytes\n{1}", null, () -> {
                if (this.isSensitiveEnabled()) {
                    Parameter<?> dumpBuffer = Parameter.arg(Format.Style.PACKET_DUMP, TimeoutSocketChannel.copy(dst, read), 0L, read);
                    return new Object[]{read, dumpBuffer};
                }
                return new Object[]{read};
            });
        }
        return read;
    }

    private final int writeToSocket(ByteBuffer src) throws IOException {
        this.ensureOpen();
        int writeBytes = this.socketChannel.write(src);
        if (this.netStat != null && writeBytes > 0) {
            this.netStat.incrementBytesSent(writeBytes);
        }
        this.tracep(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "writeToSocket", "{0} bytes written to the Socket.", "{0} bytes written to the Socket. Packet Dump : \n{1}", null, () -> {
            if (this.isSensitiveEnabled()) {
                Parameter<?> dumpBuffer = Parameter.arg(Format.Style.PACKET_DUMP, TimeoutSocketChannel.copy(src, writeBytes), 0L, writeBytes);
                return new Object[]{writeBytes, dumpBuffer};
            }
            return new Object[]{writeBytes};
        });
        return writeBytes;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        throw new IOException("Unsupported feature");
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        throw new IOException("Unsupported feature");
    }

    public String toString() {
        return "TimeoutSocketChannel[" + this.socket().toString() + "]";
    }

    @Override
    final void registerForNonBlockingRead(Consumer<Throwable> onReadReady) throws IOException {
        SocketChannel socketChannel = this.requireOpenChannel();
        if (this.soTimeout > 0) {
            AtomicBoolean isRegistered = new AtomicBoolean(false);
            TimerTask cancelTask = TimeoutSocketChannel.scheduleRegistrationCancel(socketChannel, this.soTimeout, isRegistered);
            try {
                TcpMultiplexer.registerForReadEvent(socketChannel, err -> {
                    cancelTask.cancel();
                    onReadReady.accept((Throwable)err);
                });
                isRegistered.set(true);
            }
            catch (IOException registrationException) {
                cancelTask.cancel();
                throw registrationException;
            }
        } else {
            TcpMultiplexer.registerForReadEvent(socketChannel, onReadReady);
        }
    }

    @Override
    final void registerForNonBlockingWrite(Consumer<Throwable> onWriteReady) throws IOException {
        SocketChannel socketChannel = this.requireOpenChannel();
        if (this.soTimeout > 0) {
            AtomicBoolean isRegistered = new AtomicBoolean(false);
            TimerTask cancelTask = TimeoutSocketChannel.scheduleRegistrationCancel(socketChannel, this.soTimeout, isRegistered);
            try {
                TcpMultiplexer.registerForWriteEvent(socketChannel, err -> {
                    cancelTask.cancel();
                    onWriteReady.accept((Throwable)err);
                });
                isRegistered.set(true);
            }
            catch (IOException registrationException) {
                cancelTask.cancel();
                throw registrationException;
            }
        } else {
            TcpMultiplexer.registerForWriteEvent(socketChannel, onWriteReady);
        }
    }

    private static TimerTask scheduleRegistrationCancel(SocketChannel socketChannel, int soTimeout, AtomicBoolean isRegistered) {
        return TimeoutInterruptHandler.scheduleTask(() -> {
            while (!isRegistered.get() && !Thread.currentThread().isInterrupted()) {
            }
            TcpMultiplexer.cancelRegistration(socketChannel, TimeoutSocketChannel.newTimeoutException());
        }, soTimeout);
    }

    @Override
    protected void enqueueBlockedWrites(boolean isEnabled) {
        this.isWriteQueueEnabled = isEnabled;
    }

    @Override
    protected boolean completeBlockedWrites() throws IOException {
        ByteBuffer buffer;
        while ((buffer = this.writeQueue.peek()) != null) {
            this.writeToSocket(buffer);
            if (buffer.hasRemaining()) {
                return false;
            }
            this.writeQueue.remove();
        }
        return true;
    }

    private boolean enqueueWrite(ByteBuffer buffer) {
        if (!this.isWriteQueueEnabled) {
            return false;
        }
        ByteBuffer copy = ByteBuffer.allocateDirect(buffer.remaining());
        copy.put(buffer).flip();
        this.writeQueue.add(copy);
        return true;
    }

    private static TimeoutInterruptHandler.IOReadTimeoutException newTimeoutException() {
        return new TimeoutInterruptHandler.IOReadTimeoutException("Socket read timed out");
    }

    private class AsyncConnectTask
    implements Consumer<Throwable> {
        private final Executor asyncExecutor;
        private final Monitor cancellationLock = Monitor.newInstance();
        private final CompletableFuture<Void> connectFuture = new CompletableFuture();
        private boolean isTimeoutExpired = false;

        private AsyncConnectTask(Executor asyncExecutor) {
            this.asyncExecutor = asyncExecutor;
        }

        private void start() {
            try {
                TcpMultiplexer.registerForConnectEvent(TimeoutSocketChannel.this.socketChannel, this);
            }
            catch (IOException registrationFailure) {
                this.connectFuture.completeExceptionally(registrationFailure);
            }
        }

        @Override
        public void accept(Throwable err) {
            this.asyncExecutor.execute(() -> this.handleReadiness(err));
        }

        private final void handleReadiness(Throwable err) {
            try (Monitor.CloseableLock lock = this.cancellationLock.acquireCloseableLock();){
                if (err != null) {
                    this.connectFuture.completeExceptionally(err);
                } else if (!this.isTimeoutExpired) {
                    TimeoutSocketChannel.this.socketChannel.configureBlocking(false);
                    if (TimeoutSocketChannel.this.socketChannel.finishConnect()) {
                        TimeoutSocketChannel.this.selector = Selector.open();
                        TimeoutSocketChannel.this.selectionKey = TimeoutSocketChannel.this.socketChannel.register(TimeoutSocketChannel.this.selector, 1);
                        this.connectFuture.complete(null);
                    } else {
                        TcpMultiplexer.registerForConnectEvent(TimeoutSocketChannel.this.socketChannel, this);
                    }
                }
            }
            catch (IOException connectFailure) {
                this.connectFuture.completeExceptionally(connectFailure);
            }
        }

        private final void setTimeoutExpired() {
            this.isTimeoutExpired = true;
            try (Monitor.CloseableLock lock = this.cancellationLock.acquireCloseableLock();){
                TimeoutInterruptHandler.IOReadTimeoutException timeoutException = new TimeoutInterruptHandler.IOReadTimeoutException("Socket connect timed out");
                this.asyncExecutor.execute(() -> this.connectFuture.completeExceptionally(timeoutException));
                try {
                    TcpMultiplexer.cancelRegistration(TimeoutSocketChannel.this.socketChannel, timeoutException);
                    TimeoutSocketChannel.this.socketChannel.close();
                }
                catch (IOException closeException) {
                    this.connectFuture.completeExceptionally(timeoutException);
                }
            }
        }

        private final CompletionStage<Void> getConnectStage() {
            return this.connectFuture;
        }
    }
}

