/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.index;

import io.quarkus.bootstrap.classloading.JarClassPathElement;
import io.quarkus.deployment.util.IoUtil;
import io.quarkus.paths.OpenPathTree;
import io.quarkus.paths.PathVisit;
import io.quarkus.paths.PathVisitor;
import io.smallrye.common.io.jar.JarFiles;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassSummary;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.UnsupportedVersion;
import org.jboss.logging.Logger;

public class IndexingUtil {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.deployment.index");
    public static final DotName OBJECT = DotName.createSimple((String)Object.class.getName());
    public static final String JANDEX_INDEX = "META-INF/jandex.idx";
    private static final int REQUIRED_INDEX_VERSION = 8;

    public static Index indexJar(Path path) throws IOException {
        return IndexingUtil.indexJar(path.toFile(), Collections.emptySet());
    }

    public static Index indexJar(File file) throws IOException {
        return IndexingUtil.indexJar(file, Collections.emptySet());
    }

    public static Index indexJar(Path path, Set<String> removed) throws IOException {
        return IndexingUtil.indexJar(path.toFile(), removed);
    }

    public static Index indexTree(OpenPathTree tree, Set<String> removed) throws IOException {
        Index i;
        if (removed == null && (i = (Index)tree.apply(JANDEX_INDEX, (Function)MetaInfJandexReader.getInstance())) != null) {
            return i;
        }
        Indexer indexer = new Indexer();
        PathTreeIndexer treeIndexer = new PathTreeIndexer(indexer, removed);
        tree.walk((PathVisitor)treeIndexer);
        return indexer.complete();
    }

    public static Index indexJar(File file, Set<String> removed) throws IOException {
        try (JarFile jarFile = new JarFile(file);){
            ZipEntry existing = jarFile.getEntry(JANDEX_INDEX);
            if (existing != null && removed == null) {
                InputStream in = jarFile.getInputStream(existing);
                IndexReader reader = new IndexReader(in);
                if (reader.getIndexVersion() < 8) {
                    log.warnf("Re-indexing %s - at least Jandex 2.1 must be used to index an application dependency", (Object)file);
                    Index index = IndexingUtil.indexJar(jarFile, removed);
                    return index;
                }
                Index index = reader.read();
                return index;
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            Index index = IndexingUtil.indexJar(jarFile, removed);
            return index;
        }
    }

    private static Index indexJar(JarFile file, Set<String> removed) throws IOException {
        Indexer indexer = new Indexer();
        Enumeration<JarEntry> e = file.entries();
        boolean multiRelease = JarFiles.isMultiRelease((JarFile)file);
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (removed != null && removed.contains(entry.getName()) || !entry.getName().endsWith(".class")) continue;
            if (multiRelease && entry.getName().startsWith("META-INF/versions/")) {
                String part = entry.getName().substring("META-INF/versions/".length());
                int slash = part.indexOf("/");
                if (slash == -1) continue;
                try {
                    int ver = Integer.parseInt(part.substring(0, slash));
                    if (ver > JarClassPathElement.JAVA_VERSION) continue;
                    try (InputStream inputStream = file.getInputStream(entry);){
                        indexer.index(inputStream);
                    }
                }
                catch (NumberFormatException ex) {
                    log.debug((Object)"Failed to parse META-INF/versions entry", (Throwable)ex);
                }
                continue;
            }
            InputStream inputStream = file.getInputStream(entry);
            try {
                indexer.index(inputStream);
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        return indexer.complete();
    }

    public static void indexClass(String className, Indexer indexer, IndexView quarkusIndex, Set<DotName> additionalIndex, ClassLoader classLoader) {
        IndexingUtil.indexClass(className, indexer, quarkusIndex, additionalIndex, new HashSet<DotName>(), classLoader);
    }

    public static void indexClass(String className, Indexer indexer, IndexView quarkusIndex, Set<DotName> additionalIndex, Set<DotName> knownMissingClasses, ClassLoader classLoader) {
        Set annotationNames;
        DotName superclassName;
        block20: {
            DotName classDotName = DotName.createSimple((String)className);
            if (additionalIndex.contains(classDotName)) {
                return;
            }
            ClassInfo classInfo = quarkusIndex.getClassByName(classDotName);
            if (classInfo == null) {
                log.debugf("Index class: %s", (Object)className);
                try (InputStream stream = IoUtil.readClass(classLoader, className);){
                    ClassSummary summary = indexer.indexWithSummary(stream);
                    additionalIndex.add(summary.name());
                    superclassName = summary.superclassName();
                    annotationNames = summary.annotations();
                    break block20;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to index: " + className, e);
                }
            }
            additionalIndex.add(classDotName);
            superclassName = classInfo.superName();
            annotationNames = classInfo.annotationsMap().keySet();
        }
        for (DotName annotationName : annotationNames) {
            if (additionalIndex.contains(annotationName) || quarkusIndex.getClassByName(annotationName) != null) continue;
            try {
                InputStream annotationStream = IoUtil.readClass(classLoader, annotationName.toString());
                try {
                    if (annotationStream == null) {
                        log.debugf("Could not index annotation: %s (missing class or dependency)", (Object)annotationName);
                        knownMissingClasses.add(annotationName);
                        continue;
                    }
                    log.debugf("Index annotation: %s", (Object)annotationName);
                    IndexingUtil.indexClass(annotationName.toString(), indexer, quarkusIndex, additionalIndex, knownMissingClasses, classLoader);
                }
                finally {
                    if (annotationStream == null) continue;
                    annotationStream.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to index: " + className, e);
            }
        }
        if (superclassName != null && !superclassName.equals((Object)OBJECT)) {
            IndexingUtil.indexClass(superclassName.toString(), indexer, quarkusIndex, additionalIndex, knownMissingClasses, classLoader);
        }
    }

    public static void indexClass(String className, Indexer indexer, IndexView quarkusIndex, Set<DotName> additionalIndex, ClassLoader classLoader, byte[] beanData) {
        IndexingUtil.indexClass(className, indexer, quarkusIndex, additionalIndex, new HashSet<DotName>(), classLoader, beanData);
    }

    public static void indexClass(String className, Indexer indexer, IndexView quarkusIndex, Set<DotName> additionalIndex, Set<DotName> knownMissingClasses, ClassLoader classLoader, byte[] beanData) {
        Set annotationNames;
        block18: {
            DotName classDotName = DotName.createSimple((String)className);
            if (additionalIndex.contains(classDotName)) {
                return;
            }
            ClassInfo classInfo = quarkusIndex.getClassByName(classDotName);
            if (classInfo == null) {
                log.debugf("Index class: %s", (Object)className);
                try (ByteArrayInputStream stream = new ByteArrayInputStream(beanData);){
                    ClassSummary summary = indexer.indexWithSummary((InputStream)stream);
                    additionalIndex.add(summary.name());
                    annotationNames = summary.annotations();
                    break block18;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to index: " + className, e);
                }
            }
            additionalIndex.add(classDotName);
            annotationNames = classInfo.annotationsMap().keySet();
        }
        for (DotName annotationName : annotationNames) {
            if (additionalIndex.contains(annotationName) || quarkusIndex.getClassByName(annotationName) != null) continue;
            try {
                InputStream annotationStream = IoUtil.readClass(classLoader, annotationName.toString());
                try {
                    if (annotationStream == null) {
                        log.debugf("Could not index annotation: %s (missing class or dependency)", (Object)annotationName);
                        knownMissingClasses.add(annotationName);
                        continue;
                    }
                    log.debugf("Index annotation: %s", (Object)annotationName);
                    IndexingUtil.indexClass(annotationName.toString(), indexer, quarkusIndex, additionalIndex, knownMissingClasses, classLoader);
                    additionalIndex.add(annotationName);
                }
                finally {
                    if (annotationStream == null) continue;
                    annotationStream.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to index: " + className, e);
            }
        }
    }

    private static class MetaInfJandexReader
    implements Function<PathVisit, Index> {
        private static MetaInfJandexReader instance;

        private MetaInfJandexReader() {
        }

        private static MetaInfJandexReader getInstance() {
            return instance == null ? (instance = new MetaInfJandexReader()) : instance;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Index apply(PathVisit visit) {
            if (visit == null) {
                return null;
            }
            try (InputStream in = Files.newInputStream(visit.getPath(), new OpenOption[0]);){
                IndexReader reader = new IndexReader(in);
                try {
                    if (reader.getIndexVersion() < 8) {
                        log.warnf("Re-indexing %s - at least Jandex 2.1 must be used to index an application dependency", (Object)visit.getPath());
                        Index index = null;
                        return index;
                    }
                }
                catch (UnsupportedVersion e) {
                    throw new UnsupportedVersion("Can't read Jandex index from " + visit.getPath() + ": " + e.getMessage());
                }
                Index index = reader.read();
                return index;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Can't read Jandex index from " + visit.getPath(), e);
            }
        }
    }

    private static class PathTreeIndexer
    implements PathVisitor {
        final Indexer indexer;
        final Set<String> removed;

        PathTreeIndexer(Indexer indexer, Set<String> removed) {
            this.indexer = indexer;
            this.removed = removed;
        }

        public void visitPath(PathVisit visit) {
            Path fileName = visit.getPath().getFileName();
            if (fileName == null || !fileName.toString().endsWith(".class") || Files.isDirectory(visit.getPath(), new LinkOption[0]) || this.removed != null && this.removed.contains(visit.getRelativePath("/"))) {
                return;
            }
            try (InputStream inputStream = Files.newInputStream(visit.getPath(), new OpenOption[0]);){
                this.indexer.index(inputStream);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

