/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes.sessions;

import java.util.UUID;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.sessions.CrossDCLastSessionRefreshStore;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;

public class CrossDCLastSessionRefreshChecker {
    public static final Logger logger = Logger.getLogger(CrossDCLastSessionRefreshChecker.class);
    private final CrossDCLastSessionRefreshStore store;
    private final CrossDCLastSessionRefreshStore offlineStore;

    public CrossDCLastSessionRefreshChecker(CrossDCLastSessionRefreshStore store, CrossDCLastSessionRefreshStore offlineStore) {
        this.store = store;
        this.offlineStore = offlineStore;
    }

    public SessionUpdateTask.CrossDCMessageStatus shouldSaveUserSessionToRemoteCache(KeycloakSession kcSession, RealmModel realm, SessionEntityWrapper<UserSessionEntity> sessionWrapper, boolean offline, int newLastSessionRefresh) {
        SessionUpdateTask.CrossDCMessageStatus baseChecks = this.baseChecks(kcSession, realm, offline);
        if (baseChecks != null) {
            return baseChecks;
        }
        String userSessionId = sessionWrapper.getEntity().getId();
        if (offline) {
            Integer lsrr = sessionWrapper.getLocalMetadataNoteInt("lsrr");
            if (lsrr == null) {
                lsrr = sessionWrapper.getEntity().getStarted();
            }
            if (lsrr + realm.getOfflineSessionIdleTimeout() / 2 <= newLastSessionRefresh) {
                logger.debugf("We are going to write remotely userSession %s. Remote last session refresh: %d, New last session refresh: %d", (Object)userSessionId, (Object)lsrr, (Object)newLastSessionRefresh);
                return SessionUpdateTask.CrossDCMessageStatus.SYNC;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debugf("Skip writing last session refresh to the remoteCache. Session %s newLastSessionRefresh %d", (Object)userSessionId, (Object)newLastSessionRefresh);
        }
        CrossDCLastSessionRefreshStore storeToUse = offline ? this.offlineStore : this.store;
        storeToUse.putLastSessionRefresh(kcSession, userSessionId, realm.getId(), newLastSessionRefresh);
        return SessionUpdateTask.CrossDCMessageStatus.NOT_NEEDED;
    }

    public SessionUpdateTask.CrossDCMessageStatus shouldSaveClientSessionToRemoteCache(KeycloakSession kcSession, RealmModel realm, SessionEntityWrapper<AuthenticatedClientSessionEntity> sessionWrapper, UserSessionModel userSession, boolean offline, int newTimestamp) {
        SessionUpdateTask.CrossDCMessageStatus baseChecks = this.baseChecks(kcSession, realm, offline);
        if (baseChecks != null) {
            return baseChecks;
        }
        UUID clientSessionId = sessionWrapper.getEntity().getId();
        if (offline) {
            Integer lsrr = sessionWrapper.getLocalMetadataNoteInt("lstr");
            if (lsrr == null) {
                lsrr = userSession.getStarted();
            }
            if (lsrr + realm.getOfflineSessionIdleTimeout() / 2 <= newTimestamp) {
                logger.debugf("We are going to write remotely for clientSession %s. Remote timestamp: %d, New timestamp: %d", (Object)clientSessionId, (Object)lsrr, (Object)newTimestamp);
                return SessionUpdateTask.CrossDCMessageStatus.SYNC;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debugf("Skip writing timestamp to the remoteCache. ClientSession %s timestamp %d", (Object)clientSessionId, (Object)newTimestamp);
        }
        return SessionUpdateTask.CrossDCMessageStatus.NOT_NEEDED;
    }

    private SessionUpdateTask.CrossDCMessageStatus baseChecks(KeycloakSession kcSession, RealmModel realm, boolean offline) {
        CrossDCLastSessionRefreshStore storeToUse;
        if (realm.isRevokeRefreshToken()) {
            return SessionUpdateTask.CrossDCMessageStatus.SYNC;
        }
        CrossDCLastSessionRefreshStore crossDCLastSessionRefreshStore = storeToUse = offline ? this.offlineStore : this.store;
        if (storeToUse == null) {
            return SessionUpdateTask.CrossDCMessageStatus.SYNC;
        }
        Boolean ignoreRemoteCacheUpdate = (Boolean)kcSession.getAttribute("IGNORE_REMOTE_CACHE_UPDATE");
        if (ignoreRemoteCacheUpdate != null && ignoreRemoteCacheUpdate.booleanValue()) {
            return SessionUpdateTask.CrossDCMessageStatus.NOT_NEEDED;
        }
        return null;
    }
}

