/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http.wagon.shared;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.wagon.providers.http.httpclient.Header;
import org.apache.maven.wagon.providers.http.httpclient.HttpHost;
import org.apache.maven.wagon.providers.http.httpclient.client.config.RequestConfig;
import org.apache.maven.wagon.providers.http.httpclient.message.BasicHeader;
import org.apache.maven.wagon.providers.http.wagon.shared.HttpMethodConfiguration;

public class ConfigurationUtils {
    private static final String SO_TIMEOUT = "http.socket.timeout";
    private static final String STALE_CONNECTION_CHECK = "http.connection.stalecheck";
    private static final String CONNECTION_TIMEOUT = "http.connection.timeout";
    private static final String USE_EXPECT_CONTINUE = "http.protocol.expect-continue";
    private static final String DEFAULT_PROXY = "http.route.default-proxy";
    private static final String LOCAL_ADDRESS = "http.route.local-address";
    private static final String PROXY_AUTH_PREF = "http.auth.proxy-scheme-pref";
    private static final String TARGET_AUTH_PREF = "http.auth.target-scheme-pref";
    private static final String HANDLE_AUTHENTICATION = "http.protocol.handle-authentication";
    private static final String ALLOW_CIRCULAR_REDIRECTS = "http.protocol.allow-circular-redirects";
    private static final String CONN_MANAGER_TIMEOUT = "http.conn-manager.timeout";
    private static final String COOKIE_POLICY = "http.protocol.cookie-policy";
    private static final String MAX_REDIRECTS = "http.protocol.max-redirects";
    private static final String HANDLE_REDIRECTS = "http.protocol.handle-redirects";
    private static final String REJECT_RELATIVE_REDIRECT = "http.protocol.reject-relative-redirect";
    private static final String HANDLE_CONTENT_COMPRESSION = "http.protocol.handle-content-compression";
    private static final String HANDLE_URI_NORMALIZATION = "http.protocol.handle-uri-normalization";
    private static final String COERCE_PATTERN = "%(\\w+),(.+)";

    public static void copyConfig(HttpMethodConfiguration config, RequestConfig.Builder builder) {
        builder.setConnectTimeout(config.getConnectionTimeout());
        builder.setSocketTimeout(config.getReadTimeout());
        Properties params = config.getParams();
        if (params != null) {
            Pattern coercePattern = Pattern.compile(COERCE_PATTERN);
            for (Map.Entry<Object, Object> entry : params.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                Matcher matcher = coercePattern.matcher(value);
                if (matcher.matches()) {
                    value = matcher.group(2);
                }
                if (key.equals(SO_TIMEOUT)) {
                    builder.setSocketTimeout(Integer.parseInt(value));
                    continue;
                }
                if (key.equals(STALE_CONNECTION_CHECK)) {
                    builder.setStaleConnectionCheckEnabled(Boolean.valueOf(value));
                    continue;
                }
                if (key.equals(CONNECTION_TIMEOUT)) {
                    builder.setConnectTimeout(Integer.parseInt(value));
                    continue;
                }
                if (key.equals(USE_EXPECT_CONTINUE)) {
                    builder.setExpectContinueEnabled(Boolean.valueOf(value));
                    continue;
                }
                if (key.equals(DEFAULT_PROXY)) {
                    builder.setProxy(HttpHost.create(value));
                    continue;
                }
                if (key.equals(LOCAL_ADDRESS)) {
                    try {
                        builder.setLocalAddress(InetAddress.getByName(value));
                    }
                    catch (UnknownHostException unknownHostException) {}
                    continue;
                }
                if (key.equals(PROXY_AUTH_PREF)) {
                    builder.setProxyPreferredAuthSchemes(Arrays.asList(value.split(",")));
                    continue;
                }
                if (key.equals(TARGET_AUTH_PREF)) {
                    builder.setTargetPreferredAuthSchemes(Arrays.asList(value.split(",")));
                    continue;
                }
                if (key.equals(HANDLE_AUTHENTICATION)) {
                    builder.setAuthenticationEnabled(Boolean.valueOf(value));
                    continue;
                }
                if (key.equals(ALLOW_CIRCULAR_REDIRECTS)) {
                    builder.setCircularRedirectsAllowed(Boolean.valueOf(value));
                    continue;
                }
                if (key.equals(CONN_MANAGER_TIMEOUT)) {
                    builder.setConnectionRequestTimeout(Integer.parseInt(value));
                    continue;
                }
                if (key.equals(COOKIE_POLICY)) {
                    builder.setCookieSpec(value);
                    continue;
                }
                if (key.equals(MAX_REDIRECTS)) {
                    builder.setMaxRedirects(Integer.parseInt(value));
                    continue;
                }
                if (key.equals(HANDLE_REDIRECTS)) {
                    builder.setRedirectsEnabled(Boolean.valueOf(value));
                    continue;
                }
                if (key.equals(REJECT_RELATIVE_REDIRECT)) {
                    builder.setRelativeRedirectsAllowed(Boolean.valueOf(value) == false);
                    continue;
                }
                if (key.equals(HANDLE_CONTENT_COMPRESSION)) {
                    builder.setContentCompressionEnabled(Boolean.valueOf(value));
                    continue;
                }
                if (!key.equals(HANDLE_URI_NORMALIZATION)) continue;
                builder.setNormalizeUri(Boolean.valueOf(value));
            }
        }
    }

    public static Header[] asRequestHeaders(HttpMethodConfiguration config) {
        Properties headers = config.getHeaders();
        if (headers == null) {
            return new Header[0];
        }
        Header[] result = new Header[headers.size()];
        int index = 0;
        for (Map.Entry<Object, Object> entry : headers.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            BasicHeader header = new BasicHeader(key, value);
            result[index++] = header;
        }
        return result;
    }

    public static HttpMethodConfiguration merge(HttpMethodConfiguration defaults, HttpMethodConfiguration base, HttpMethodConfiguration local) {
        HttpMethodConfiguration result = ConfigurationUtils.merge(defaults, base);
        return ConfigurationUtils.merge(result, local);
    }

    public static HttpMethodConfiguration merge(HttpMethodConfiguration base, HttpMethodConfiguration local) {
        if (base == null && local == null) {
            return null;
        }
        if (base == null) {
            return local;
        }
        if (local == null) {
            return base;
        }
        HttpMethodConfiguration result = base.copy();
        if (local.getConnectionTimeout() != 60000) {
            result.setConnectionTimeout(local.getConnectionTimeout());
        }
        if (local.getReadTimeout() != 1800000) {
            result.setReadTimeout(local.getReadTimeout());
        }
        if (local.getHeaders() != null) {
            result.getHeaders().putAll((Map<?, ?>)local.getHeaders());
        }
        if (local.getParams() != null) {
            result.getParams().putAll((Map<?, ?>)local.getParams());
        }
        if (local.getUseDefaultHeaders() != null) {
            result.setUseDefaultHeaders(local.isUseDefaultHeaders());
        }
        return result;
    }
}

