/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class NoranProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_UPLOAD_POSITION = 8;
    public static final int MSG_UPLOAD_POSITION_NEW = 50;
    public static final int MSG_CONTROL = 2;
    public static final int MSG_CONTROL_RESPONSE = 32777;
    public static final int MSG_ALARM = 3;
    public static final int MSG_SHAKE_HAND = 0;
    public static final int MSG_SHAKE_HAND_RESPONSE = 32768;
    public static final int MSG_IMAGE_SIZE = 512;
    public static final int MSG_IMAGE_PACKET = 513;

    public NoranProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedShortLE();
        int type = buf.readUnsignedShortLE();
        if (type == 0 && channel != null) {
            ByteBuf response = Unpooled.buffer((int)13);
            response.writeCharSequence((CharSequence)"\r\n*KW", StandardCharsets.US_ASCII);
            response.writeByte(0);
            response.writeShortLE(response.capacity());
            response.writeShortLE(32768);
            response.writeByte(1);
            response.writeCharSequence((CharSequence)"\r\n", StandardCharsets.US_ASCII);
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        } else if (type == 8 || type == 50 || type == 32777 || type == 3) {
            ByteBuf rawId;
            String id;
            DeviceSession deviceSession;
            boolean newFormat = false;
            if (type == 8 && buf.readableBytes() == 48 || type == 3 && buf.readableBytes() == 48 || type == 32777 && buf.readableBytes() == 57) {
                newFormat = true;
            }
            Position position = new Position(this.getProtocolName());
            if (type == 32777) {
                buf.readUnsignedIntLE();
                buf.readUnsignedIntLE();
            }
            position.setValid(BitUtil.check(buf.readUnsignedByte(), 0));
            short alarm = buf.readUnsignedByte();
            switch (alarm) {
                case 1: {
                    position.set("alarm", "sos");
                    break;
                }
                case 2: {
                    position.set("alarm", "overspeed");
                    break;
                }
                case 3: {
                    position.set("alarm", "geofenceExit");
                    break;
                }
                case 9: {
                    position.set("alarm", "powerOff");
                    break;
                }
            }
            if (newFormat) {
                position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedIntLE()));
                position.setCourse(buf.readFloatLE());
            } else {
                position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
                position.setCourse(buf.readUnsignedShortLE());
            }
            position.setLongitude(buf.readFloatLE());
            position.setLatitude(buf.readFloatLE());
            if (!newFormat) {
                long timeValue = buf.readUnsignedIntLE();
                DateBuilder dateBuilder = new DateBuilder().setYear((int)BitUtil.from(timeValue, 26)).setMonth((int)BitUtil.between(timeValue, 22, 26)).setDay((int)BitUtil.between(timeValue, 17, 22)).setHour((int)BitUtil.between(timeValue, 12, 17)).setMinute((int)BitUtil.between(timeValue, 6, 12)).setSecond((int)BitUtil.to(timeValue, 6));
                position.setTime(dateBuilder.getDate());
            }
            if ((deviceSession = this.getDeviceSession(channel, remoteAddress, id = (rawId = newFormat ? buf.readSlice(12) : buf.readSlice(11)).toString(StandardCharsets.US_ASCII).replaceAll("[^\\p{Print}]", ""))) == null) {
                return null;
            }
            position.setDeviceId(deviceSession.getDeviceId());
            if (newFormat) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
                position.setTime(dateFormat.parse(buf.readSlice(17).toString(StandardCharsets.US_ASCII)));
                buf.readByte();
            }
            if (!newFormat) {
                position.set("io1", buf.readUnsignedByte());
                position.set("fuel", buf.readUnsignedByte());
            } else if (type == 50) {
                position.set("temp1", buf.readShortLE());
                position.set("odometer", Float.valueOf(buf.readFloatLE()));
            }
            return position;
        }
        return null;
    }
}

