
#ifndef KWALLET_EXPORT_H
#define KWALLET_EXPORT_H

#ifdef KWALLET_STATIC_DEFINE
#  define KWALLET_EXPORT
#  define KWALLET_NO_EXPORT
#else
#  ifndef KWALLET_EXPORT
#    ifdef KF5Wallet_EXPORTS
        /* We are building this library */
#      define KWALLET_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KWALLET_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KWALLET_NO_EXPORT
#    define KWALLET_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KWALLET_DECL_DEPRECATED
#  define KWALLET_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KWALLET_DECL_DEPRECATED_EXPORT
#  define KWALLET_DECL_DEPRECATED_EXPORT KWALLET_EXPORT KWALLET_DECL_DEPRECATED
#endif

#ifndef KWALLET_DECL_DEPRECATED_NO_EXPORT
#  define KWALLET_DECL_DEPRECATED_NO_EXPORT KWALLET_NO_EXPORT KWALLET_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KWALLET_NO_DEPRECATED
#    define KWALLET_NO_DEPRECATED
#  endif
#endif

#define KWALLET_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KWALLET_NO_DEPRECATED) && !defined(KWALLET_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KWALLET_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KWALLET_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KWALLET_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KWALLET_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KWALLET_NO_DEPRECATED_WARNINGS) && !defined(KWALLET_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KWALLET_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KWALLET_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KWALLET_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KWALLET_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KWALLET_NO_DEPRECATED)
#  undef KWALLET_DEPRECATED
#  define KWALLET_DEPRECATED_EXPORT KWALLET_EXPORT
#  define KWALLET_DEPRECATED_NO_EXPORT KWALLET_NO_EXPORT
#elif defined(KWALLET_NO_DEPRECATED_WARNINGS)
#  define KWALLET_DEPRECATED
#  define KWALLET_DEPRECATED_EXPORT KWALLET_EXPORT
#  define KWALLET_DEPRECATED_NO_EXPORT KWALLET_NO_EXPORT
#else
#  define KWALLET_DEPRECATED KWALLET_DECL_DEPRECATED
#  define KWALLET_DEPRECATED_EXPORT KWALLET_DECL_DEPRECATED_EXPORT
#  define KWALLET_DEPRECATED_NO_EXPORT KWALLET_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KWALLET_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KWALLET_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KWALLET_NO_DEPRECATED
#  define KWALLET_DISABLE_DEPRECATED_BEFORE_AND_AT 0x57300
#endif
#ifdef KWALLET_NO_DEPRECATED_WARNINGS
#  define KWALLET_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KWALLET_DEPRECATED_WARNINGS_SINCE
#  ifdef KWALLET_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KWALLET_DEPRECATED_WARNINGS_SINCE KWALLET_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KWALLET_DEPRECATED_WARNINGS_SINCE 0x57300
#  endif
#endif

#ifndef KWALLET_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KWALLET_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KWALLET_DEPRECATED
#  define KWALLET_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KWALLET_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KWALLET_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KWALLET_DEPRECATED_WARNINGS_SINCE >= 0x54800
#  define KWALLET_DEPRECATED_VERSION_5_72(text) KWALLET_DECL_DEPRECATED_TEXT(text)
#else
#  define KWALLET_DEPRECATED_VERSION_5_72(text)
#endif
#define KWALLET_DEPRECATED_VERSION_5(minor, text)      KWALLET_DEPRECATED_VERSION_5_##minor(text)
#define KWALLET_DEPRECATED_VERSION(major, minor, text) KWALLET_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KWALLET_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KWALLET_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KWALLET_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KWALLET_DEPRECATED_VERSION(major, minor, text)
#  define KWALLET_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KWALLET_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KWALLET_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KWALLET_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KWALLET_EXPORT_H */
