"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.GET_FINDINGS_SORT_FIELDS = exports.DEFAULT_GET_FINDINGS_PARAMS = void 0;

var _lodash = _interopRequireDefault(require("lodash"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /*
                                                                                                                                                                                                                   * Copyright OpenSearch Contributors
                                                                                                                                                                                                                   * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                   */

// TODO DRAFT: Are these sortField options appropriate?
const GET_FINDINGS_SORT_FIELDS = {
  INDEX: 'index',
  MONITOR_NAME: 'monitor_name',
  TIMESTAMP: 'timestamp'
}; // TODO DRAFT: RestGetFindingsAction.kt in the backend references a `missing` field in params.
//  Investigate if/how we should make use of that.

exports.GET_FINDINGS_SORT_FIELDS = GET_FINDINGS_SORT_FIELDS;
const DEFAULT_GET_FINDINGS_PARAMS = {
  // TODO DRAFT: Does providing a finding ID serve a particular function? Results with/without the ID seemed the same.
  id: undefined,
  from: 0,
  search: '',
  size: 20,
  sortDirection: 'desc',
  sortField: GET_FINDINGS_SORT_FIELDS.TIMESTAMP
};
exports.DEFAULT_GET_FINDINGS_PARAMS = DEFAULT_GET_FINDINGS_PARAMS;

class FindingService {
  constructor(esDriver) {
    _defineProperty(this, "getFindings", async (context, req, res) => {
      const {
        id = DEFAULT_GET_FINDINGS_PARAMS.id,
        from = DEFAULT_GET_FINDINGS_PARAMS.from,
        size = DEFAULT_GET_FINDINGS_PARAMS.size,
        search = DEFAULT_GET_FINDINGS_PARAMS.search,
        sortDirection = DEFAULT_GET_FINDINGS_PARAMS.sortDirection,
        sortField = DEFAULT_GET_FINDINGS_PARAMS.sortField
      } = req.query;
      var params;

      switch (sortField) {
        case GET_FINDINGS_SORT_FIELDS.INDEX:
          params = {
            sortString: `${sortField}.keyword`,
            sortOrder: sortDirection
          };
          break;

        case GET_FINDINGS_SORT_FIELDS.MONITOR_NAME:
          params = {
            sortString: `${sortField}.keyword`,
            sortOrder: sortDirection
          };
          break;

        default:
          // If the sortField parsed from the URL isn't a valid option for this API, use a default option.
          params = {
            sortString: GET_FINDINGS_SORT_FIELDS.TIMESTAMP,
            sortOrder: sortDirection
          };
      }

      if (!_lodash.default.isEmpty(id)) params.findingId = id;
      params.startIndex = from;
      params.size = size;
      params.searchString = search;
      if (search.trim()) params.searchString = `*${search.trim().split(' ').join('* *')}*`;
      const {
        callAsCurrentUser
      } = this.esDriver.asScoped(req);

      try {
        const resp = await callAsCurrentUser('alerting.getFindings', params);
        const findings = resp.findings.map(result => ({
          [result.finding.id]: { ...result
          }
        }));
        const totalFindings = resp.totalFindings;
        return res.ok({
          body: {
            ok: true,
            findings,
            totalFindings
          }
        });
      } catch (err) {
        console.log(err.message);
        return res.ok({
          body: {
            ok: false,
            err: err.message
          }
        });
      }
    });

    this.esDriver = esDriver;
  }

}

exports.default = FindingService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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