"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PPLQueryBuilder = void 0;

var _ppl_syntax_parser = require("../antlr/ppl_syntax_parser");

var _stats_builder = require("../ast/builder/stats_builder");

var _stats_ast_builder = require("../ast/builder/stats_ast_builder");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /*
                                                                                                                                                                                                                   * Copyright OpenSearch Contributors
                                                                                                                                                                                                                   * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                   */

class PPLQueryBuilder {
  constructor() {
    _defineProperty(this, "parser", null);
  }

  build(query, pplTokens) {
    this.parser = new _ppl_syntax_parser.PPLSyntaxParser().parse(query);
    return this.buildStats(query, pplTokens);
  }

  buildStats(query, statsTokens) {
    const statsTree = new _stats_ast_builder.StatsAstBuilder().visitRoot(this.parser.root());
    const newStatsAstTree = new _stats_builder.StatsBuilder(statsTokens).build();

    if (typeof statsTree.getStartEndIndicesOfOriginQuery !== 'function') {
      return query + ' | ' + newStatsAstTree.toString();
    }

    const indices = statsTree.getStartEndIndicesOfOriginQuery();

    if (indices.start !== -1 && indices.end !== -1) {
      return query.substring(0, indices.start) + newStatsAstTree.toString() + query.substring(indices.end + 1, query.length);
    } else if (indices && newStatsAstTree) {
      return query + ' | ' + newStatsAstTree.toString();
    }

    return '';
  }

}

exports.PPLQueryBuilder = PPLQueryBuilder;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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