.\"
.\" Copyright (c) 2023 Andrea Biscuola <a@abiscuola.com>
.\"
.\" Permission to use, copy, modify, and distribute this software for any
.\" purpose with or without fee is hereby granted, provided that the above
.\" copyright notice and this permission notice appear in all copies.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
.\" WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
.\" MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
.\" ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
.\" WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
.\" ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
.\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.Dd September 3, 2023
.Dt IRCTK-GUI n
.Os
.Sh NAME
.Nm irctk-gui
.Nd graphical user interface
.Sh SYNOPSIS
.Cm gui adduser Ar id nick
.Pp
.Cm gui away Ar id status
.Pp
.Cm gui changech Ar id
.Pp
.Cm gui closechannel Ar id
.Pp
.Cm gui displaymsg Ar msg nick id level datetime
.Pp
.Cm gui displaytopic Ar id datetime topic
.Pp
.Cm gui init
.Pp
.Cm gui newchanneltab Ar fd nick parent id channel
.Pp
.Cm gui newprivatetab Ar fd nick parent id channel
.Pp
.Cm gui newreadtab Ar parent id channel
.Pp
.Cm gui newserver Ar item
.Pp
.Cm gui newservertab Ar fd nick network id
.Pp
.Cm gui onexit
.Pp
.Cm gui privatechat Ar fd id
.Pp
.Cm gui quiet
.Pp
.Cm gui raisewin
.Pp
.Cm gui removeuser Ar id nick
.Pp
.Cm gui savefont Ar sets
.Pp
.Cm gui setmode Ar id nick mode
.Pp
.Cm gui showmode
.Pp
.Cm gui updateuser Ar id oldnick newnick
.Sh DESCRIPTION
The gui namespace, takes care of handling everything related to the user
interface of
.Xr irctk 1 .
It sits on top of the application's stack, communicating with the irctk
middleware and, on some occasions, with the lower level libraries.
.Pp
.Cm gui init
is called during the
.Xr irctk 1
startup, to initialize the main user interface and drawing the main window
on the screen.
.Cm gui onexit ,
on the other hand, is called when the user quits the application,
triggering all the cleanup commands from the other layers.
.Pp
The
.Cm gui newchanneltab ,
.Cm gui newprivatetab ,
.Cm gui newprivatechat ,
.Cm gui newreadtab
and
.Cm gui newreadtab
are all used to create a new channel in the interface.
A channel may be of different types:
.Bl -tag -width channel
.It server
The channel where the network messages and the messages without a
clear target are written to.
Useful for logging of the server itself.
Can be also used, in general, to run commands related to the network.
Generally is represented as a root node in the
.Dq servers
treeview.
.It channel
A channel the user explicitly join.
It's created when the application receives the confirmation of the user
successfully joining a specific channel.
It also shows the list of users present in the new channel itself.
.It private
A private communication with another user.
Created when the user receive a direct message, or after the user issues
a QUERY command in one of the prompts.
.It read
A read-only channel.
Generally created when an extension wants to write something in output
and a channel with the given name does not exists.
It can be used only to show informations, it's not possible to interact with
it, outside explicitly closing it.
.El
.Pp
.Cm gui closechannel
destroy the interface components related to the channel identified by
.Ar id
and remove the channel from the treeview.
.Pp
.Cm gui displaytopic
shows the channel topic on the top editor line dedicated to it and in the
chat panel whenever the user joins a channel, or the topic is changed.
.Pp
.Cm gui displaymsg
posts the text in
.Ar msg
coming from a server in the channel identified
by the given
.Ar id .
The message is written showing the given
.Ar nick
and a
.Ar datetime
timestamp with the hour, minute and second the message is
received.
The level is used to color the message, and the channel in the treeview
with different colors:
.Bl -tag -width message
.It mention
The message mentions the user in it's text and it will be written in
purple.
Also, the channel name in the servers treeview will be shown as
purple.
.It message
A chat message, coming from another user.
The channel name is colored in orange.
.It info
A message coming from the server, like
.Dq foo has joined ,
or
.Dq bar has quit .
The channel is colored in blue.
.El
.Pp
If the quiet mode is active through, by being activated with the
.Cm gui quiet
command, messages of level info are suppressed.
The current mode may be visualized with
.Cm gui showmode .
.Pp
.Cm gui adduser
and
.Cm gui removeuser
updates the users list of the channel
.Ar id
joined by the application user, by, respectively, adding a new user
or removing it.
.Pp
.Dq gui away
marks the user in the various channel of the server identified by
.Ar id
as grey if
.Ar status
is 1
or enabled if
.Ar status
is 0.
.Pp
.Cm gui setmode
marks the given
.Ar nick
in the channel
.Ar id
with the provided irc mode.
If
.Ar nick
is an operator, it's visualized in green.
.Pp
.Cm gui changech
and
.Cm gui raisewin
are function used, generally, by the extensions.
Those are mapped by the custom IRC SWITCH and RAISE
commands.
SWITCH, select, programmatically, the channel identified by
.Ar id
and RAISE, show the application window.
.Pp
.Cm gui savefont
saves the current font settings in the fonts configurations file.
.Sh FILES
.Bl -tag -compact -width "${HOME}/.config/irctk/font.confXXXXXX"
.It Pa ${HOME}/.config/irctk/font.conf
Font configurations file
.El
.Sh SEE ALSO
.Xr irctk 1 ,
.Xr irctk-exts n ,
.Xr irctk-irc n ,
.Xr irctk-irctk n ,
.Xr irctk-log n
.Sh AUTHORS
.An Andrea Biscuola Aq Mt a@abiscuola.com
