"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addLogTypeMethods = addLogTypeMethods;

var _constants = require("../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function addLogTypeMethods(securityAnalytics, createAction) {
  securityAnalytics[_constants.METHOD_NAMES.SEARCH_LOGTYPES] = createAction({
    url: {
      fmt: `${_constants.API.LOGTYPE_BASE}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  securityAnalytics[_constants.METHOD_NAMES.CREATE_LOGTYPE] = createAction({
    url: {
      fmt: `${_constants.API.LOGTYPE_BASE}`
    },
    needBody: true,
    method: 'POST'
  });
  securityAnalytics[_constants.METHOD_NAMES.UPDATE_LOGTYPE] = createAction({
    url: {
      fmt: `${_constants.API.LOGTYPE_BASE}/<%=logTypeId%>`,
      req: {
        logTypeId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  securityAnalytics[_constants.METHOD_NAMES.DELETE_LOGTYPE] = createAction({
    url: {
      fmt: `${_constants.API.LOGTYPE_BASE}/<%=logTypeId%>`,
      req: {
        logTypeId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: false,
    method: 'DELETE'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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