"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupRulesRoutes = setupRulesRoutes;

var _configSchema = require("@osd/config-schema");

var _constants = require("../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function setupRulesRoutes(services, router) {
  const {
    rulesService
  } = services;
  router.post({
    path: `${_constants.API.RULES_BASE}/_search`,
    validate: {
      query: _configSchema.schema.object({
        prePackaged: _configSchema.schema.boolean()
      }),
      body: _configSchema.schema.any()
    }
  }, rulesService.getRules);
  router.post({
    path: `${_constants.API.RULES_BASE}`,
    validate: {
      body: _configSchema.schema.any()
    }
  }, rulesService.createRule);
  router.delete({
    path: `${_constants.API.RULES_BASE}/{ruleId}`,
    validate: {
      params: _configSchema.schema.object({
        ruleId: _configSchema.schema.string()
      })
    }
  }, rulesService.deleteRule);
  router.put({
    path: `${_constants.API.RULES_BASE}/{ruleId}`,
    validate: {
      query: _configSchema.schema.object({
        category: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any(),
      params: _configSchema.schema.object({
        ruleId: _configSchema.schema.string()
      })
    }
  }, rulesService.updateRule);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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