/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.popup;

import com.almworks.tracker.eapi.alpha.ArtifactInfo;
import com.almworks.tracker.eapi.alpha.ArtifactInfoStatus;
import com.almworks.tracklink.popup.ArtifactInfoList;
import com.almworks.tracklink.util.StringBundle;
import com.almworks.tracklink.util.Utils;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.GuiUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

class ToolbarPanel
extends JPanel {
    private final JLabel myTitleLabel = new JLabel();
    private final JLabel myStatusLabel = new JLabel("", 0);

    public ToolbarPanel() {
        this.initBorder();
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(GuiUtils.createBorderLayout());
        this.setOpaque(false);
        ActionToolbar actionToolbar = Utils.createActionToolbar("Tracklink.Popup.Toolbar");
        if (actionToolbar != null) {
            this.add((Component)actionToolbar.getComponent(), "West");
        }
        this.add((Component)this.myStatusLabel, "Center");
        this.add((Component)this.myTitleLabel, "East");
    }

    private void initBorder() {
        this.setBorder(new UnderlineBorder());
    }

    void updateLabels(ArtifactInfoList model) {
        boolean isWaitingForConnection = false;
        boolean isWaitingForDownload = false;
        long firstTimestamp = Long.MAX_VALUE;
        for (ArtifactInfo artifactInfo : model.getValuesSnapshot()) {
            long timestamp;
            ArtifactInfoStatus status = artifactInfo.getStatus();
            if (status == ArtifactInfoStatus.WAIT_CONNECTION_SETUP) {
                isWaitingForConnection = true;
            }
            if (status == ArtifactInfoStatus.WAIT_DOWNLOADING) {
                isWaitingForDownload = true;
            }
            if ((timestamp = artifactInfo.getTimestamp()) >= firstTimestamp) continue;
            firstTimestamp = timestamp;
        }
        if (firstTimestamp != 0L) {
            this.myTitleLabel.setText(new MessageFormat(StringBundle.get("popup.title", new Object[0])).format(new Object[]{new Date(firstTimestamp)}));
        } else {
            this.myTitleLabel.setText(null);
        }
        if (isWaitingForConnection) {
            this.setStatus(Utils.getStatusPresentation(ArtifactInfoStatus.WAIT_CONNECTION_SETUP));
        } else if (isWaitingForDownload) {
            this.setStatus(Utils.getStatusPresentation(ArtifactInfoStatus.WAIT_DOWNLOADING));
        } else {
            this.setStatus("");
        }
    }

    private void setStatus(String status) {
        this.myStatusLabel.setText(StringUtil.isEmpty((String)status) ? "" : status + "...");
    }

    private static class UnderlineBorder
    implements Border {
        private UnderlineBorder() {
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 2, 0);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color base = c.getBackground();
            if (base == null) {
                base = Color.GRAY;
            }
            g.setColor(base.darker());
            g.drawLine(0, height - 2, width, height - 2);
            g.setColor(base.brighter());
            g.drawLine(0, height - 1, width, height - 1);
        }
    }
}

