/*
 * Decompiled with CFR 0.152.
 */
package tr.view.topics.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import org.jdesktop.swingx.util.WindowUtils;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import tr.model.Data;
import tr.model.topic.Topic;
import tr.util.Observable;
import tr.view.topics.dialog.TopicDialogPanel;

public class TopicDialog
extends JDialog {
    private Mode mode;
    private Data data;
    private TopicDialogPanel topicPanel;
    private Topic topic;
    private JButton okButton;
    private JButton cancelButton;

    public TopicDialog(Data data) {
        super(WindowManager.getDefault().getMainWindow(), true);
        this.data = data;
        this.construct();
    }

    private void construct() {
        this.setDefaultCloseOperation(2);
        ActionListener cancelListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TopicDialog.this.cancel();
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane rp = this.getRootPane();
        rp.registerKeyboardAction(cancelListener, stroke, 2);
        this.topicPanel = new TopicDialogPanel();
        this.topicPanel.setPreferredSize(new Dimension(680, 140));
        this.cancelButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TopicDialog.this.cancel();
            }
        });
        this.okButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"ok"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TopicDialog.this.ok();
            }
        });
        JPanel buttons = new JPanel(new FlowLayout(2, 2, 2));
        buttons.setPreferredSize(new Dimension(0, 36));
        buttons.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 36));
        buttons.add(new JLabel("   "));
        buttons.add(this.cancelButton);
        buttons.add(this.okButton);
        this.add((Component)this.topicPanel, "Center");
        this.add((Component)buttons, "South");
        this.pack();
        this.setLocation(WindowUtils.getPointForCentering((Window)this));
    }

    private void setMode(Mode mode) {
        this.mode = mode;
        if (mode == Mode.CREATE) {
            this.setTitle(NbBundle.getMessage(this.getClass(), (String)"create"));
            this.okButton.setText(NbBundle.getMessage(this.getClass(), (String)"add"));
        } else {
            this.setTitle(NbBundle.getMessage(this.getClass(), (String)"modify"));
            this.okButton.setText(NbBundle.getMessage(this.getClass(), (String)"ok"));
        }
    }

    private boolean isValid(Topic topic) {
        return topic.getName().trim().length() != 0;
    }

    private void ok() {
        this.topic.setName(this.topicPanel.getTopicName());
        this.topic.setDescription(this.topicPanel.getDescription());
        this.topic.setBackground(this.topicPanel.getBgColor());
        this.topic.setForeground(this.topicPanel.getFgColor());
        if (!this.isValid(this.topic)) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (this.mode == Mode.MODIFY) {
            this.setVisible(false);
            this.dispose();
        } else {
            this.data.getTopicManager().add((Observable)this.topic);
            this.topic = new Topic(this.data.getNextID());
            this.topicPanel.setTopicName(this.topic.getName());
            this.topicPanel.setDescription(this.topic.getDescription());
            this.topicPanel.setBgColor(this.topic.getBackground());
            this.topicPanel.setFgColor(this.topic.getForeground());
            this.topicPanel.focus();
        }
    }

    private void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    private void showDialog() {
        this.getRootPane().setDefaultButton(this.okButton);
        this.setVisible(true);
    }

    public void showCreateDialog() {
        this.topic = new Topic(this.data.getNextID());
        this.topicPanel.setTopicName(this.topic.getName());
        this.topicPanel.setDescription(this.topic.getDescription());
        this.topicPanel.setBgColor(this.topic.getBackground());
        this.topicPanel.setFgColor(this.topic.getForeground());
        this.setMode(Mode.CREATE);
        this.showDialog();
    }

    public void showModifyDialog(Topic topic) {
        if (topic == null) {
            return;
        }
        this.topic = topic;
        this.topicPanel.setTopicName(topic.getName());
        this.topicPanel.setDescription(topic.getDescription());
        this.topicPanel.setBgColor(topic.getBackground());
        this.topicPanel.setFgColor(topic.getForeground());
        this.setMode(Mode.MODIFY);
        this.showDialog();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        CREATE,
        MODIFY;

    }
}

