/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sah extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Iran = new String[] {
               "\u0418\u0440\u0430\u0430\u043d \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u042b\u0440\u0430\u0430\u043d \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u0418\u0440\u0430\u0430\u043d \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Moscow = new String[] {
               "\u041c\u043e\u0441\u043a\u0443\u0431\u0430 \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u041c\u043e\u0441\u043a\u0443\u0431\u0430 \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u041c\u043e\u0441\u043a\u0443\u0431\u0430 \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] EMPTY_ZONE = new String[] {
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "\u0414\u044c\u043e\u043f\u043f\u0443\u043e\u043d \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u0414\u044c\u043e\u043f\u043f\u0443\u043e\u043d \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u0414\u044c\u043e\u043f\u043f\u0443\u043e\u043d \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Pakistan = new String[] {
               "\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u0430\u043d \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u0430\u043d \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u0430\u043d \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Magadan = new String[] {
               "\u041c\u0430\u0433\u0430\u0434\u0430\u0430\u043d \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u041c\u0430\u0433\u0430\u0434\u0430\u0430\u043d \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u041c\u0430\u0433\u0430\u0434\u0430\u0430\u043d \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Sakhalin = new String[] {
               "\u0421\u0430\u0445\u0430\u043b\u044b\u044b\u043d \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u0421\u0430\u0445\u0430\u043b\u044b\u044b\u043d \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u0421\u0430\u0445\u0430\u043b\u0438\u0438\u043d \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Korea = new String[] {
               "\u041a\u044d\u0440\u0438\u044d\u0439 \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u041a\u044d\u0440\u0438\u044d\u0439 \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u041a\u044d\u0440\u0438\u044d\u0439 \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Omsk = new String[] {
               "\u041e\u043c\u0441\u043a\u0430\u0439 \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u041e\u043c\u0441\u043a\u0430\u0439 \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u041e\u043c\u0441\u043a\u0430\u0439 \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Australia_Western = new String[] {
               "\u0410\u0440\u0495\u0430\u0430 \u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u0410\u0440\u0495\u0430\u0430 \u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u0410\u0440\u0495\u0430\u0430 \u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "\u041a\u044b\u0440\u0433\u044b\u0441\u0442\u0430\u0430\u043d \u043a\u044d\u043c\u044d",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "\u041a\u0438\u0438\u043d \u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u041a\u0438\u0438\u043d \u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u041a\u0438\u0438\u043d \u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Mongolia = new String[] {
               "\u0423\u043b\u0430\u043d \u0411\u0430\u0430\u0442\u0430\u0440 \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u0423\u043b\u0430\u043d \u0411\u0430\u0430\u0442\u0430\u0440 \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u0423\u043b\u0430\u043d \u0411\u0430\u0430\u0442\u0430\u0440 \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] New_Zealand = new String[] {
               "\u0421\u0430\u04a5\u0430 \u0421\u044d\u0439\u043b\u044d\u043d\u0434 \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u0421\u0430\u04a5\u0430 \u0421\u044d\u0439\u043b\u044d\u043d\u0434 \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u0421\u0430\u04a5\u0430 \u0417\u0435\u043b\u0430\u043d\u0434\u0438\u044f \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "\u0418\u043b\u0438\u043d \u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u0418\u043b\u0438\u043d \u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u0418\u043b\u0438\u043d \u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Yakutsk = new String[] {
               "\u0414\u044c\u043e\u043a\u0443\u0443\u0441\u043a\u0430\u0439 \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u0414\u044c\u043e\u043a\u0443\u0443\u0441\u043a\u0430\u0439 \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u0414\u044c\u043e\u043a\u0443\u0443\u0441\u043a\u0430\u0439 \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Arabian = new String[] {
               "\u0410\u0440\u0430\u0430\u0431 \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u0410\u0440\u0430\u0430\u0431 \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u0410\u0440\u0430\u0430\u0431 \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "\u041d\u043e\u0432\u043e\u0441\u0438\u0431\u0438\u0440\u0441\u043a\u0430\u0439 \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u041d\u043e\u0432\u043e\u0441\u0438\u0431\u0438\u0440\u0441\u043a\u0430\u0439 \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u041d\u043e\u0432\u043e\u0441\u0438\u0431\u0438\u0440\u0441\u043a\u0430\u0439 \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Vladivostok = new String[] {
               "\u0411\u044b\u043b\u0430\u0434\u044c\u044b\u0431\u0430\u0441\u0442\u044b\u0430\u043a \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u0411\u044b\u043b\u0430\u0434\u044c\u044b\u0431\u0430\u0441\u0442\u044b\u0430\u043a \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u0412\u043b\u0430\u0434\u0438\u0432\u043e\u0441\u0442\u043e\u043a \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Georgia = new String[] {
               "\u041a\u0443\u0440\u0443\u0441\u0443\u0443\u043d \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u041a\u0443\u0440\u0443\u0441\u0443\u0443\u043d \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u041a\u0443\u0440\u0443\u0441\u0443\u0443\u043d \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Choibalsan = new String[] {
               "\u0427\u043e\u0439\u0431\u0430\u043b\u0441\u0430\u043d \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u0427\u043e\u0439\u0431\u0430\u043b\u0441\u0430\u043d \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u0427\u043e\u0439\u0431\u0430\u043b\u0441\u0430\u043d \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] China = new String[] {
               "\u041a\u044b\u0442\u0430\u0439 \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u041a\u044b\u0442\u0430\u0439 \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u041a\u044b\u0442\u0430\u0439 \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Armenia = new String[] {
               "\u042d\u0440\u043c\u044d\u044d\u043d \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u042d\u0440\u043c\u044d\u044d\u043d \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u042d\u0440\u043c\u044d\u044d\u043d \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u041a\u0440\u0430\u0441\u043d\u043e\u044f\u0440\u0441\u043a\u0430\u0439 \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u041a\u0440\u0430\u0441\u043d\u043e\u044f\u0440\u0441\u043a\u0430\u0439 \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u041a\u0440\u0430\u0441\u043d\u043e\u044f\u0440\u0441\u043a\u0430\u0439 \u043a\u044d\u043c\u044d",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u0410\u0440\u0495\u0430\u0430 \u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u0430\u043d \u043a\u044d\u043c\u044d",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "\u0418\u0438\u043d\u0434\u0438\u0439\u044d \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u0418\u043b\u0438\u043d \u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u0430\u043d \u043a\u044d\u043c\u044d",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "\u0415\u043a\u0430\u0442\u0435\u0440\u0438\u043d\u0431\u0443\u0443\u0440 \u0441\u04af\u0440\u04af\u043d \u043a\u044d\u043c\u044d",
               "",
               "\u0415\u043a\u0430\u0442\u0435\u0440\u0438\u043d\u0431\u0443\u0443\u0440 \u0441\u0430\u0439\u044b\u04a5\u04a5\u044b \u043a\u044d\u043c\u044d",
               "",
               "\u0415\u043a\u0430\u0442\u0435\u0440\u0438\u043d\u0431\u0443\u0440\u0433 \u043a\u044d\u043c\u044d",
               "",
            };
        final Object[][] data = new Object[][] {
            { "Asia/Tokyo", Japan },
            { "Asia/Shanghai", China },
            { "UTC", EMPTY_ZONE },
            { "Asia/Aden", Arabian },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "CTT", China },
            { "Asia/Vladivostok", Vladivostok },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "timezone.excity.Asia/Irkutsk", "\u0418\u0440\u043a\u0443\u0442\u0441\u043a\u0430\u0439" },
            { "timezone.excity.Asia/Ulaanbaatar", "\u0423\u043b\u0430\u043d \u0411\u0430\u0430\u0442\u0430\u0440" },
            { "Europe/Moscow", Moscow },
            { "Australia/Hobart", Australia_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Asia/Sakhalin", Sakhalin },
            { "timezone.excity.Asia/Novosibirsk", "\u041d\u043e\u0432\u043e\u0441\u0438\u0431\u0438\u0440\u0441\u043a\u0430\u0439" },
            { "timezone.excity.Asia/Baghdad", "\u0411\u0430\u0433\u0434\u0430\u0430\u0434" },
            { "Asia/Yerevan", Armenia },
            { "JST", Japan },
            { "timezone.excity.Asia/Srednekolymsk", "\u041e\u0440\u0442\u043e \u0425\u0430\u043b\u044b\u043c\u0430" },
            { "timezone.excity.Asia/Kamchatka", "\u041a\u0430\u043c\u0447\u0430\u0430\u0442\u043a\u0430" },
            { "NST", New_Zealand },
            { "Asia/Yakutsk", Yakutsk },
            { "timezone.excity.Asia/Samarkand", "\u0421\u0430\u043c\u0430\u0440\u043a\u0430\u0430\u043d" },
            { "timezone.excity.Asia/Yakutsk", "\u0414\u044c\u043e\u043a\u0443\u0443\u0441\u043a\u0430\u0439" },
            { "timezone.excity.Europe/Simferopol", "\u0421\u0438\u043c\u0444\u0435\u0440\u043e\u043f\u043e\u043b\u044c" },
            { "Asia/Tehran", Iran },
            { "Asia/Oral", Kazakhstan_Western },
            { "timezone.excity.Asia/Omsk", "\u041e\u043c\u0441\u043a\u0430\u0439" },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.Asia/Chita", "\u0427\u0438\u0442\u0430\u0430" },
            { "timezone.excity.Asia/Colombo", "\u041a\u043e\u043b\u043e\u043c\u0431\u043e" },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Europe/Simferopol", Moscow },
            { "ACT", Australia_Central },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "timezone.excity.Asia/Anadyr", "\u0410\u043d\u0430\u0430\u0434\u044b\u0440" },
            { "timezone.excity.Asia/Ashgabat", "\u0410\u0441\u0445\u0430\u0431\u0430\u0430\u0442" },
            { "timezone.excity.Asia/Urumqi", "\u0423\u0440\u0443\u043c\u0447\u0443" },
            { "NET", Armenia },
            { "timezone.excity.Asia/Barnaul", "\u0411\u0430\u0440\u043d\u0430\u0443\u043b" },
            { "timezone.excity.Asia/Sakhalin", "\u0421\u0430\u0445\u0430\u043b\u0438\u0438\u043d" },
            { "Asia/Riyadh", Arabian },
            { "timezone.excity.Asia/Magadan", "\u041c\u0430\u0433\u0430\u0434\u0430\u0430\u043d" },
            { "Asia/Karachi", Pakistan },
            { "Asia/Harbin", China },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "timezone.excity.Etc/Unknown", "\u0411\u0438\u043b\u043b\u0438\u0431\u044d\u0442" },
            { "Australia/Perth", Australia_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "Asia/Chita", Yakutsk },
            { "timezone.excity.Asia/Krasnoyarsk", "\u041a\u0440\u0430\u0441\u043d\u043e\u044f\u0440\u0441\u043a\u0430\u0439" },
            { "Asia/Kuwait", Arabian },
            { "Antarctica/McMurdo", New_Zealand },
            { "Asia/Calcutta", India },
            { "Asia/Macau", China },
            { "timezone.excity.Asia/Ust-Nera", "\u0423\u0443\u0441 \u041d\u044c\u0430\u0440\u0430" },
            { "timezone.excity.Asia/Damascus", "\u0414\u0430\u043c\u0430\u0430\u0441" },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "timezone.excity.Asia/Choibalsan", "\u0427\u043e\u0439\u0431\u0430\u043b\u0441\u0430\u043d" },
            { "AET", Australia_Eastern },
            { "timezone.excity.Asia/Baku", "\u0411\u0430\u043a\u0443\u0443" },
            { "timezone.excity.Europe/Moscow", "\u041c\u043e\u0441\u043a\u0443\u0431\u0430" },
            { "timezone.excity.Asia/Dubai", "\u0414\u0443\u0431\u0430\u0430\u0439" },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "Asia/Qatar", Arabian },
            { "Asia/Magadan", Magadan },
            { "Asia/Ust-Nera", Vladivostok },
            { "timezone.excity.Asia/Khandyga", "\u0425\u0430\u0430\u043d\u0434\u044b\u0433\u0430" },
            { "timezone.excity.Europe/Kaliningrad", "\u041a\u0430\u043b\u0438\u043d\u0438\u043d\u0433\u0440\u0430\u0434" },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Bahrain", Arabian },
            { "timezone.excity.Asia/Kabul", "\u041a\u0430\u0431\u0443\u0443\u043b" },
            { "Asia/Chongqing", China },
            { "PLT", Pakistan },
            { "timezone.excity.Europe/Ulyanovsk", "\u0423\u043b\u044c\u044f\u043d\u043e\u0432\u0441\u043a\u0430\u0439" },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "timezone.excity.Asia/Yekaterinburg", "\u0415\u043a\u0430\u0442\u0435\u0440\u0438\u043d\u0431\u0443\u0443\u0440" },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Colombo", India },
            { "Asia/Omsk", Omsk },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "timezone.excity.Europe/Astrakhan", "\u0410\u0430\u0441\u0442\u0440\u0430\u0445\u0430\u043d" },
            { "timezone.excity.Europe/Samara", "\u0421\u0430\u043c\u0430\u0430\u0440\u0430" },
            { "Europe/Volgograd", Moscow },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Asia/Bishkek", Kyrgystan },
            { "timezone.excity.Europe/Istanbul", "\u0421\u0442\u0430\u043c\u0431\u0443\u0443\u043b" },
            { "timezone.excity.Asia/Almaty", "\u0410\u043b\u043c\u0430\u0442\u044b" },
        };
        return data;
    }
}
