/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap.action;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.olap.SchemaEditPanel;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class EditSchemaAction
extends AbstractArchitectAction {
    private final MondrianModel.Schema schema;
    private final ArchitectSwingSession session;
    private final Window dialogOwner;

    public EditSchemaAction(ArchitectSwingSession session, MondrianModel.Schema schema, PlayPen pp) {
        super(session, pp, "Schema Properties...", "Edit the properties of " + schema.getName() + " in a dialog", (String)null);
        this.dialogOwner = SwingUtilities.getWindowAncestor(pp);
        this.schema = schema;
        this.session = session;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            SchemaEditPanel panel = new SchemaEditPanel(this.session, this.schema);
            JDialog dialog = DataEntryPanelBuilder.createDataEntryPanelDialog((DataEntryPanel)panel, (Component)this.dialogOwner, (String)"Schema Properties", (String)DataEntryPanelBuilder.OK_BUTTON_LABEL);
            dialog.setLocationRelativeTo(this.session.getArchitectFrame());
            dialog.setVisible(true);
        }
        catch (SQLObjectException ex) {
            ASUtils.showExceptionDialogNoReport(this.dialogOwner, "Failed to get list of databases.", ex);
        }
    }
}

