/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ldap.group;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.filter.AndNode;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.NotNode;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.ldap.ConnectedLDAPConfiguration;
import org.apache.guacamole.auth.ldap.ObjectQueryService;
import org.apache.guacamole.auth.ldap.conf.LDAPConfiguration;
import org.apache.guacamole.auth.ldap.conf.MemberAttributeType;
import org.apache.guacamole.auth.ldap.user.LDAPAuthenticatedUser;
import org.apache.guacamole.net.auth.UserGroup;
import org.apache.guacamole.net.auth.simple.SimpleUserGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserGroupService {
    private static final Logger logger = LoggerFactory.getLogger(UserGroupService.class);
    @Inject
    private ObjectQueryService queryService;

    private ExprNode getGroupSearchFilter(LDAPConfiguration config) throws GuacamoleException {
        ExprNode groupFilter = config.getGroupSearchFilter();
        if (config.getConfigurationBaseDN() != null) {
            groupFilter = new AndNode(new ExprNode[]{groupFilter, new NotNode((ExprNode)new EqualityNode("objectClass", "guacConfigGroup"))});
        }
        return groupFilter;
    }

    public Map<String, UserGroup> getUserGroups(LDAPAuthenticatedUser user) throws GuacamoleException {
        ConnectedLDAPConfiguration config = user.getLDAPConfiguration();
        Dn groupBaseDN = config.getGroupBaseDN();
        if (groupBaseDN == null) {
            return Collections.emptyMap();
        }
        String memberAttribute = config.getMemberAttribute();
        HashSet<String> groupAttributes = new HashSet<String>(config.getGroupNameAttributes());
        groupAttributes.add(memberAttribute);
        List<String> attributes = config.getGroupNameAttributes();
        List<Entry> results = this.queryService.search(config, config.getLDAPConnection(), groupBaseDN, this.getGroupSearchFilter(config), attributes, null, groupAttributes);
        return this.queryService.asMap(results, entry -> {
            try {
                String name = this.queryService.getIdentifier((Entry)entry, (Collection<String>)attributes);
                if (name != null) {
                    return new SimpleUserGroup(name);
                }
            }
            catch (LdapInvalidAttributeValueException e) {
                return null;
            }
            logger.debug("User group \"{}\" is missing a name attribute and will be ignored.", (Object)entry.getDn().toString());
            return null;
        });
    }

    public List<Entry> getParentUserGroupEntries(ConnectedLDAPConfiguration config, Dn userDN) throws GuacamoleException {
        Dn groupBaseDN = config.getGroupBaseDN();
        if (groupBaseDN == null) {
            return Collections.emptyList();
        }
        MemberAttributeType memberAttributeType = config.getMemberAttributeType();
        String userIDorDN = userDN.toString();
        List<String> userAttributes = config.getUsernameAttributes();
        if (memberAttributeType == MemberAttributeType.UID) {
            List<Entry> userEntries = this.queryService.search(config, config.getLDAPConnection(), userDN, config.getUserSearchFilter(), 0, userAttributes);
            if (userEntries.size() != 1) {
                logger.warn("user DN \"{}\" does not return unique value and will be ignored", (Object)userDN.toString());
            } else {
                Entry userEntry = userEntries.get(0);
                try {
                    userIDorDN = this.queryService.getIdentifier(userEntry, userAttributes);
                }
                catch (LdapInvalidAttributeValueException e) {
                    logger.error("User group missing identifier: {}", (Object)e.getMessage());
                    logger.debug("LDAP exception while getting group identifier.", (Throwable)e);
                }
            }
        }
        String memberAttribute = config.getMemberAttribute();
        HashSet<String> groupAttributes = new HashSet<String>(config.getGroupNameAttributes());
        groupAttributes.add(memberAttribute);
        return this.queryService.search(config, config.getLDAPConnection(), groupBaseDN, this.getGroupSearchFilter(config), Collections.singleton(memberAttribute), userIDorDN, groupAttributes);
    }

    public Set<String> getParentUserGroupIdentifiers(ConnectedLDAPConfiguration config, Dn userDN) throws GuacamoleException {
        List<String> attributes = config.getGroupNameAttributes();
        List<Entry> userGroups = this.getParentUserGroupEntries(config, userDN);
        HashSet<String> identifiers = new HashSet<String>(userGroups.size());
        userGroups.forEach(entry -> {
            try {
                String name = this.queryService.getIdentifier((Entry)entry, (Collection<String>)attributes);
                if (name != null) {
                    identifiers.add(name);
                } else {
                    logger.debug("User group \"{}\" is missing a name attribute and will be ignored.", (Object)entry.getDn().toString());
                }
            }
            catch (LdapInvalidAttributeValueException e) {
                logger.error("User group missing identifier: {}", (Object)e.getMessage());
                logger.debug("LDAP exception while getting group identifier.", (Throwable)e);
            }
        });
        return identifiers;
    }
}

