/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui;

import jadx.cli.JadxCLIArgs;
import jadx.cli.LogHelper;
import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.JadxSettingsAdapter;
import jadx.gui.ui.ExceptionDialog;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.LafManager;
import jadx.gui.utils.NLS;
import jadx.gui.utils.SystemInfo;
import jadx.gui.utils.logs.LogCollector;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxGUI {
    private static final Logger LOG = LoggerFactory.getLogger(JadxGUI.class);

    public static void main(String[] args) {
        try {
            LogCollector.register();
            JadxSettings settings = JadxSettingsAdapter.load();
            settings.setLogLevel(LogHelper.LogLevelEnum.INFO);
            if (!settings.overrideProvided(args)) {
                return;
            }
            LogHelper.initLogLevel((JadxCLIArgs)settings);
            LogHelper.setLogLevelsForDecompileStage();
            JadxGUI.printSystemInfo();
            LafManager.init(settings);
            NLS.setLocale(settings.getLangLocale());
            ExceptionDialog.registerUncaughtExceptionHandler();
            SwingUtilities.invokeLater(new MainWindow(settings)::init);
        }
        catch (Exception e) {
            LOG.error("Error: {}", (Object)e.getMessage(), (Object)e);
            System.exit(1);
        }
    }

    private static void printSystemInfo() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting jadx-gui. Version: '{}'. JVM: {} {}. OS: {} {}", new Object[]{SystemInfo.JADX_VERSION, SystemInfo.JAVA_VM, SystemInfo.JAVA_VER, SystemInfo.OS_NAME, SystemInfo.OS_VERSION});
        }
    }
}

