/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.sctp;

import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.videobridge.sctp.SctpConfig;
import org.jitsi.videobridge.util.ByteBufferPool;
import org.jitsi_modified.sctp4j.Sctp4j;
import org.jitsi_modified.sctp4j.SctpClientSocket;
import org.jitsi_modified.sctp4j.SctpDataSender;
import org.jitsi_modified.sctp4j.SctpServerSocket;
import org.jitsi_modified.sctp4j.SctpSocket;

public class SctpManager {
    private static final Logger classLogger = new LoggerImpl(SctpManager.class.getName());
    private final Logger logger;
    private final SctpDataSender dataSender;
    private SctpSocket socket = null;
    public static int DEFAULT_SCTP_PORT = 5000;

    public SctpManager(SctpDataSender dataSender, Logger parentLogger) {
        if (!SctpConfig.config.enabled()) {
            throw new IllegalStateException("SCTP is disabled in configuration");
        }
        this.dataSender = new BufferCopyingSctpDataSender(dataSender);
        this.logger = parentLogger.createChildLogger(SctpManager.class.getName());
    }

    public void handleIncomingSctp(PacketInfo sctpPacket) {
        this.logger.debug(() -> "SCTP Socket " + this.socket.hashCode() + " receiving incoming SCTP data");
        this.socket.onConnIn(sctpPacket.getPacket().getBuffer(), sctpPacket.getPacket().getOffset(), sctpPacket.getPacket().getLength());
        ByteBufferPool.returnBuffer(sctpPacket.getPacket().getBuffer());
    }

    public SctpServerSocket createServerSocket(Logger parentLogger) {
        this.socket = Sctp4j.createServerSocket(DEFAULT_SCTP_PORT, parentLogger);
        this.socket.outgoingDataSender = this.dataSender;
        this.logger.debug(() -> "Created SCTP server socket " + this.socket.hashCode());
        return (SctpServerSocket)this.socket;
    }

    public SctpClientSocket createClientSocket(Logger parentLogger) {
        this.socket = Sctp4j.createClientSocket(DEFAULT_SCTP_PORT, parentLogger);
        this.socket.outgoingDataSender = this.dataSender;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Created SCTP client socket " + this.socket.hashCode());
        }
        return (SctpClientSocket)this.socket;
    }

    public void closeConnection() {
        if (this.socket != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Closing SCTP socket " + this.socket.hashCode());
            }
            this.socket.close();
            this.socket = null;
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("No SCTP socket to close");
        }
    }

    static {
        if (SctpConfig.config.enabled()) {
            classLogger.info("Initializing Sctp4j");
            Sctp4j.init(0);
        } else {
            classLogger.info("Will not initialize Sctp4j, SCTP is not configured.");
        }
    }

    private static class BufferCopyingSctpDataSender
    implements SctpDataSender {
        private final SctpDataSender innerSctpDataSender;

        BufferCopyingSctpDataSender(@NotNull SctpDataSender sctpDataSender) {
            this.innerSctpDataSender = sctpDataSender;
        }

        @Override
        public int send(byte[] data, int offset, int length) {
            byte[] newBuf = ByteBufferPool.getBuffer(length);
            System.arraycopy(data, offset, newBuf, 0, length);
            return this.innerSctpDataSender.send(newBuf, 0, length);
        }
    }
}

