/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.datastore;

import java.util.Arrays;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.migration.MigrationModelManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;
import org.keycloak.services.scheduled.ClearExpiredAdminEvents;
import org.keycloak.services.scheduled.ClearExpiredClientInitialAccessTokens;
import org.keycloak.services.scheduled.ClearExpiredEvents;
import org.keycloak.services.scheduled.ClearExpiredUserSessions;
import org.keycloak.services.scheduled.ClusterAwareScheduledTaskRunner;
import org.keycloak.storage.DatastoreProvider;
import org.keycloak.storage.DatastoreProviderFactory;
import org.keycloak.storage.StoreMigrateRepresentationEvent;
import org.keycloak.storage.StoreSyncEvent;
import org.keycloak.storage.datastore.DefaultDatastoreProvider;
import org.keycloak.storage.managers.UserStorageSyncManager;
import org.keycloak.timer.ScheduledTask;
import org.keycloak.timer.TaskRunner;
import org.keycloak.timer.TimerProvider;

public class DefaultDatastoreProviderFactory
implements DatastoreProviderFactory,
ProviderEventListener {
    private static final String PROVIDER_ID = "legacy";
    private static final Logger logger = Logger.getLogger(DefaultDatastoreProviderFactory.class);
    private long clientStorageProviderTimeout;
    private long roleStorageProviderTimeout;
    private Runnable onClose;

    public DatastoreProvider create(KeycloakSession session) {
        return new DefaultDatastoreProvider(this, session);
    }

    public void init(Config.Scope config) {
        this.clientStorageProviderTimeout = Config.scope((String[])new String[]{"client"}).getLong("storageProviderTimeout", Long.valueOf(3000L));
        this.roleStorageProviderTimeout = Config.scope((String[])new String[]{"role"}).getLong("storageProviderTimeout", Long.valueOf(3000L));
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register((ProviderEventListener)this);
        this.onClose = () -> factory.unregister((ProviderEventListener)this);
    }

    public void close() {
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public long getClientStorageProviderTimeout() {
        return this.clientStorageProviderTimeout;
    }

    public long getRoleStorageProviderTimeout() {
        return this.roleStorageProviderTimeout;
    }

    public void onEvent(ProviderEvent event) {
        if (event instanceof PostMigrationEvent) {
            this.setupScheduledTasks(((PostMigrationEvent)event).getFactory());
        } else if (event instanceof StoreSyncEvent) {
            StoreSyncEvent ev = (StoreSyncEvent)event;
            UserStorageSyncManager.notifyToRefreshPeriodicSyncAll(ev.getSession(), ev.getRealm(), ev.getRemoved());
        } else if (event instanceof StoreMigrateRepresentationEvent) {
            StoreMigrateRepresentationEvent ev = (StoreMigrateRepresentationEvent)event;
            MigrationModelManager.migrateImport(ev.getSession(), ev.getRealm(), ev.getRep(), ev.isSkipUserDependent());
        }
    }

    public void setupScheduledTasks(KeycloakSessionFactory sessionFactory) {
        long interval = Config.scope((String[])new String[]{"scheduled"}).getLong("interval", Long.valueOf(900L)) * 1000L;
        try (KeycloakSession session = sessionFactory.create();){
            TimerProvider timer = (TimerProvider)session.getProvider(TimerProvider.class);
            if (timer != null) {
                this.scheduleTasks(sessionFactory, timer, interval);
            }
        }
    }

    protected void scheduleTasks(KeycloakSessionFactory sessionFactory, TimerProvider timer, long interval) {
        for (ScheduledTask task : this.getScheduledTasks()) {
            this.scheduleTask(timer, sessionFactory, task, interval);
        }
        UserStorageSyncManager.bootstrapPeriodic(sessionFactory, timer);
    }

    protected List<ScheduledTask> getScheduledTasks() {
        return Arrays.asList(new ClearExpiredEvents(), new ClearExpiredAdminEvents(), new ClearExpiredClientInitialAccessTokens(), new ClearExpiredUserSessions());
    }

    protected void scheduleTask(TimerProvider timer, KeycloakSessionFactory sessionFactory, ScheduledTask task, long interval) {
        timer.schedule((TaskRunner)new ClusterAwareScheduledTaskRunner(sessionFactory, task, interval), interval);
        logger.debugf("Scheduled cluster task %s with interval %s ms", (Object)task.getTaskName(), (Object)interval);
    }
}

