/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.processors.FlowableProcessor;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.persistence.sifs.EntryHeader;
import org.infinispan.persistence.sifs.EntryInfo;
import org.infinispan.persistence.sifs.EntryMetadata;
import org.infinispan.persistence.sifs.EntryPosition;
import org.infinispan.persistence.sifs.EntryRecord;
import org.infinispan.persistence.sifs.FileProvider;
import org.infinispan.persistence.sifs.Index;
import org.infinispan.persistence.sifs.IndexRequest;
import org.infinispan.persistence.sifs.Log;
import org.infinispan.persistence.sifs.TemporaryTable;
import org.infinispan.util.concurrent.NonBlockingManager;
import org.infinispan.util.logging.LogFactory;

class Compactor {
    private static final Log log = LogFactory.getLog(Compactor.class, Log.class);
    private final NonBlockingManager nonBlockingManager;
    private final ConcurrentMap<Integer, Stats> fileStats = new ConcurrentHashMap<Integer, Stats>();
    private final FileProvider fileProvider;
    private final TemporaryTable temporaryTable;
    private final Marshaller marshaller;
    private final TimeService timeService;
    private final KeyPartitioner keyPartitioner;
    private final int maxFileSize;
    private final double compactionThreshold;
    private final Executor blockingExecutor;
    private FlowableProcessor<CompletableFuture<Void>> processor = UnicastProcessor.create().toSerialized();
    private Index index;
    private final AtomicBoolean clearSignal = new AtomicBoolean();
    private volatile boolean terminateSignal = false;
    private volatile CompletableFuture<?> stopped = CompletableFutures.completedNull();
    private final java.nio.ByteBuffer REUSED_BUFFER = java.nio.ByteBuffer.allocate(27);
    FileProvider.Log logFile = null;
    long nextExpirationTime = -1L;
    int currentOffset = 0;

    public Compactor(NonBlockingManager nonBlockingManager, FileProvider fileProvider, TemporaryTable temporaryTable, Marshaller marshaller, TimeService timeService, KeyPartitioner keyPartitioner, int maxFileSize, double compactionThreshold, Executor blockingExecutor) {
        this.nonBlockingManager = nonBlockingManager;
        this.fileProvider = fileProvider;
        this.temporaryTable = temporaryTable;
        this.marshaller = marshaller;
        this.timeService = timeService;
        this.keyPartitioner = keyPartitioner;
        this.maxFileSize = maxFileSize;
        this.compactionThreshold = compactionThreshold;
        this.blockingExecutor = blockingExecutor;
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    public void releaseStats(int file) {
        this.fileStats.remove(file);
    }

    public void free(int file, int size) {
        if (file < 0) {
            return;
        }
        this.recordFreeSpace(this.getStats(file, -1, -1L), file, size);
    }

    public void completeFile(int file, int currentSize, long nextExpirationTime) {
        this.completeFile(file, currentSize, nextExpirationTime, true);
    }

    public void completeFile(int file, int currentSize, long nextExpirationTime, boolean canSchedule) {
        Stats stats = this.getStats(file, currentSize, nextExpirationTime);
        stats.setCompleted();
        if (canSchedule && stats.readyToBeScheduled(this.compactionThreshold, stats.getFree())) {
            this.schedule(file, stats);
        }
    }

    ConcurrentMap<Integer, Stats> getFileStats() {
        return this.fileStats;
    }

    void addLogFileOnShutdown(int file, long expirationTime) {
        int fileSize = (int)this.fileProvider.getFileSize(file);
        Stats stats = new Stats(fileSize, 0, expirationTime);
        Stats prevStats = this.fileStats.put(file, stats);
        if (prevStats != null) {
            stats.free.addAndGet(prevStats.getFree());
        }
        log.tracef("Added log file %s to compactor at shutdown with total size %s and free size %s", file, fileSize, stats.getFree());
    }

    boolean addFreeFile(int file, int expectedSize, int freeSize, long expirationTime, boolean canScheduleCompaction) {
        int fileSize = (int)this.fileProvider.getFileSize(file);
        if (fileSize != expectedSize) {
            log.tracef("Unable to add file %s as it its size %s does not match expected %s, index may be dirty", file, fileSize, expectedSize);
            return false;
        }
        Stats stats = new Stats(fileSize, freeSize, expirationTime);
        if (this.fileStats.putIfAbsent(file, stats) != null) {
            log.tracef("Unable to add file %s as it is already present, index may be dirty", file);
            return false;
        }
        log.tracef("Added new file %s to compactor manually with total size %s and free size %s", file, fileSize, freeSize);
        stats.setCompleted();
        if (canScheduleCompaction && stats.readyToBeScheduled(this.compactionThreshold, freeSize)) {
            this.schedule(file, stats);
        }
        return true;
    }

    public void start() {
        this.stopped = new CompletableFuture();
        Scheduler scheduler = Schedulers.from((Executor)this.blockingExecutor);
        this.processor.observeOn(scheduler).concatMapCompletable(stage -> {
            this.processRequest((CompletableFuture<Void>)stage);
            Completable completable = Completable.fromCompletionStage((CompletionStage)stage);
            if (!stage.isDone()) {
                completable = completable.observeOn(scheduler);
            }
            return completable;
        }).subscribe(() -> this.stopped.complete(null), error -> {
            log.compactorEncounteredException((Throwable)error, -1);
            this.stopped.completeExceptionally((Throwable)error);
        });
        this.fileStats.forEach((file, stats) -> {
            if (stats.readyToBeScheduled(this.compactionThreshold, stats.getFree())) {
                this.schedule((int)file, (Stats)stats);
            }
        });
    }

    public void performExpirationCompaction(CompactionExpirationSubscriber subscriber) {
        HashSet<Integer> currentFiles = new HashSet<Integer>();
        try (CloseableIterator<Integer> iter = this.fileProvider.getFileIterator();){
            while (iter.hasNext()) {
                currentFiles.add((Integer)iter.next());
            }
        }
        long currentTimeMilliseconds = this.timeService.wallClockTime();
        log.tracef("Performing expiration compaction, found possible files %s", currentFiles);
        CompletionStages.performSequentially(currentFiles.iterator(), fileId -> {
            Stats stats;
            boolean isLogFile = this.fileProvider.isLogFile((int)fileId);
            if (isLogFile) {
                this.free((int)fileId, 0);
                stats = (Stats)this.fileStats.get(fileId);
            } else {
                stats = (Stats)this.fileStats.get(fileId);
                if (stats == null) {
                    log.tracef("Skipping expiration compaction for file %d as it is not included in fileStats", fileId);
                    return CompletableFutures.completedNull();
                }
                if (stats.markedForDeletion() || stats.nextExpirationTime == -1L || stats.nextExpirationTime > currentTimeMilliseconds) {
                    log.tracef("Skipping expiration compaction for file %d since it is marked for deletion: %s or already scheduled %s or its expiration time %s is not yet", new Object[]{fileId, stats.markedForDeletion(), stats.isScheduled(), stats.nextExpirationTime});
                    return CompletableFutures.completedNull();
                }
            }
            if (stats.setScheduled()) {
                log.tracef("Submitting expiration compaction for file %d with stats %s", fileId, stats);
                CompactionRequest request = new CompactionRequest((int)fileId, isLogFile, subscriber);
                this.processor.onNext((Object)request);
                return request.thenRunAsync(() -> {}, this.blockingExecutor);
            }
            log.tracef("Skipping expiration compaction for file %d as already scheduled for compaction", fileId);
            return CompletableFutures.completedNull();
        }).whenComplete((ignore, t) -> {
            if (t != null) {
                subscriber.onError((Throwable)t);
            } else {
                subscriber.onComplete();
            }
        });
    }

    CompletionStage<Void> forceCompactionForAllNonLogFiles() {
        AggregateCompletionStage aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
        HashMap<Integer, Stats> copy = new HashMap<Integer, Stats>(this.fileStats);
        for (Map.Entry stats : copy.entrySet()) {
            int fileId = (Integer)stats.getKey();
            if (this.fileProvider.isLogFile(fileId) || ((Stats)stats.getValue()).markedForDeletion || !((Stats)stats.getValue()).setScheduled()) continue;
            CompactionRequest compactionRequest = new CompactionRequest(fileId);
            this.processor.onNext((Object)compactionRequest);
            aggregateCompletionStage.dependsOn((CompletionStage)compactionRequest);
        }
        return aggregateCompletionStage.freeze();
    }

    Set<Integer> getFiles() {
        return this.fileStats.keySet();
    }

    private Stats getStats(int file, int currentSize, long expirationTime) {
        int fileSize;
        Stats stats = (Stats)this.fileStats.get(file);
        if (stats == null) {
            fileSize = currentSize < 0 ? (int)this.fileProvider.getFileSize(file) : currentSize;
            stats = new Stats(fileSize, 0, expirationTime);
            Stats other = this.fileStats.putIfAbsent(file, stats);
            if (other != null) {
                if (fileSize > other.getTotal()) {
                    other.setTotal(fileSize);
                }
                return other;
            }
        }
        if (stats.getTotal() < 0) {
            int n = fileSize = currentSize < 0 ? (int)this.fileProvider.getFileSize(file) : currentSize;
            if (fileSize >= 0) {
                stats.setTotal(fileSize);
            }
            stats.setNextExpirationTime(ExpiryHelper.mostRecentExpirationTime(stats.nextExpirationTime, expirationTime));
        }
        return stats;
    }

    private void recordFreeSpace(Stats stats, int file, int size) {
        if (stats.addFree(size, this.compactionThreshold)) {
            this.schedule(file, stats);
        }
    }

    private void schedule(int file, Stats stats) {
        assert (stats.isScheduled());
        if (!this.terminateSignal) {
            log.debugf("Scheduling file %d for compaction: %d/%d free", file, stats.free.get(), stats.total);
            CompactionRequest request = new CompactionRequest(file);
            this.processor.onNext((Object)request);
            request.whenComplete((__, t) -> {
                if (t != null) {
                    log.compactorEncounteredException((Throwable)t, file);
                    this.fileStats.remove(file);
                }
            });
        }
    }

    public CompletionStage<Void> clearAndPause() {
        if (this.clearSignal.getAndSet(true)) {
            throw new IllegalStateException("Clear signal was already set for compactor, clear cannot be invoked concurrently with another!");
        }
        ClearFuture clearFuture = new ClearFuture();
        clearFuture.whenComplete((ignore, t) -> this.fileStats.clear());
        this.processor.onNext((Object)clearFuture);
        return clearFuture;
    }

    public void resumeAfterClear() {
        if (!this.clearSignal.getAndSet(false)) {
            throw new IllegalStateException("Resume of compactor invoked without first clear and pausing!");
        }
        log.tracef("Resuming compactor after clear", new Object[0]);
    }

    public void stopOperations() {
        log.tracef("Stopping compactor", new Object[0]);
        this.terminateSignal = true;
        this.processor.onComplete();
        this.stopped.join();
        if (this.logFile != null) {
            Util.close((AutoCloseable)this.logFile);
            this.completeFile(this.logFile.fileId, this.currentOffset, this.nextExpirationTime, false);
            this.logFile = null;
        }
        this.processor = UnicastProcessor.create().toSerialized();
    }

    void completeFuture(CompletableFuture<Void> future) {
        this.nonBlockingManager.complete(future, null);
    }

    public void processRequest(CompletableFuture<Void> stageRequest) throws Throwable {
        if (this.terminateSignal) {
            log.tracef("Compactor already terminated, ignoring request " + String.valueOf(stageRequest), new Object[0]);
            this.completeFuture(stageRequest);
            return;
        }
        if (this.clearSignal.get()) {
            if (stageRequest instanceof ClearFuture) {
                log.tracef("Compactor ignoring all future compactions until clear completes", new Object[0]);
                if (this.logFile != null) {
                    this.logFile.close();
                    this.logFile = null;
                    this.nextExpirationTime = -1L;
                }
                this.completeFuture(stageRequest);
            } else {
                log.tracef("Ignoring compaction request for %s as compactor is being cleared", stageRequest);
                this.completeFuture(stageRequest);
            }
            return;
        }
        CompactionRequest request = (CompactionRequest)stageRequest;
        try {
            Stats stats = (Stats)this.fileStats.get(request.fileId);
            if (stats != null && !stats.markedForDeletion()) {
                this.compactSingleFile(request, this.timeService.wallClockTime());
                if (request.isLogFile) {
                    stats.scheduled.set(false);
                    if (stats.isCompleted() && stats.readyToBeScheduled(this.compactionThreshold, stats.free.get())) {
                        this.schedule(request.fileId, stats);
                    }
                }
            } else {
                log.tracef("Ignoring compaction request for a file %s that isn't present in stats or was marked for deletion %s", request.fileId, stats);
                this.completeFuture(request);
            }
        }
        catch (Throwable t) {
            log.trace("Completing compaction for file: " + request.fileId + " due to exception!", t);
            request.completeExceptionally(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactSingleFile(CompactionRequest compactionRequest, long currentTimeMilliseconds) throws IOException, ClassNotFoundException {
        int scheduledFile = compactionRequest.fileId;
        assert (scheduledFile >= 0);
        if (this.clearSignal.get() || this.terminateSignal) {
            log.tracef("Not compacting file %d as either the terminate or clear signal were set", scheduledFile);
            this.completeFuture(compactionRequest);
            return;
        }
        CompactionExpirationSubscriber subscriber = compactionRequest.subscriber;
        boolean isLogFile = compactionRequest.isLogFile;
        if (subscriber == null) {
            log.tracef("Compacting file %d isLogFile %b", scheduledFile, isLogFile);
        } else {
            log.tracef("Removing expired entries from file %d isLogFile %b", scheduledFile, isLogFile);
        }
        int scheduledOffset = 0;
        ArrayList<EntryPosition> expiredTemp = subscriber != null ? new ArrayList<EntryPosition>() : null;
        ArrayList<EntryRecord> expiredIndex = subscriber != null ? new ArrayList<EntryRecord>() : null;
        FileProvider.Handle handle = this.fileProvider.getFile(scheduledFile);
        if (handle == null) {
            throw new IllegalStateException("Compactor should not get deleted file for compaction!");
        }
        try (FileProvider.Handle handle2 = handle;){
            EntryHeader header;
            long fileSize = handle.getFileSize();
            AggregateCompletionStage aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
            while ((header = EntryRecord.readEntryHeader(handle, scheduledOffset)) != null) {
                byte[] serializedKey;
                long remainingBytes = fileSize - (long)scheduledOffset;
                if ((long)header.totalLength() > remainingBytes) {
                    if (isLogFile) {
                        log.tracef("Log file %d compacted %d bytes, but file is now larger ignoring remaining contents", scheduledFile, scheduledOffset);
                        break;
                    }
                    serializedKey = null;
                    if ((long)header.keyLength() < remainingBytes) {
                        serializedKey = EntryRecord.readKey(handle, header, scheduledOffset);
                    }
                    log.compactedFileNotLongEnough(serializedKey, scheduledFile, scheduledOffset, fileSize, header);
                    break;
                }
                serializedKey = EntryRecord.readKey(handle, header, scheduledOffset);
                if (serializedKey == null) {
                    throw new IllegalStateException("Concurrent update to compacting file when reading key on " + handle.getFileId() + ": " + scheduledOffset + ": " + String.valueOf(header) + "|" + handle.getFileSize());
                }
                Object key = this.marshaller.objectFromByteBuffer(serializedKey);
                int segment = this.keyPartitioner.getSegment(key);
                int valueLength = header.valueLength();
                int indexedOffset = valueLength > 0 ? scheduledOffset : ~scheduledOffset;
                int prevFile = -1;
                int prevOffset = -1;
                boolean drop = !isLogFile;
                boolean truncate = false;
                EntryPosition entry = this.temporaryTable.get(segment, key);
                if (entry != null) {
                    EntryPosition entryPosition = entry;
                    synchronized (entryPosition) {
                        if (log.isTraceEnabled()) {
                            log.tracef("Key for %d:%d was found in temporary table on %d:%d", new Object[]{scheduledFile, scheduledOffset, entry.file, entry.offset});
                        }
                        if (entry.file == scheduledFile && entry.offset == indexedOffset) {
                            long entryExpiryTime = header.expiryTime();
                            if (entryExpiryTime >= 0L && entryExpiryTime <= currentTimeMilliseconds) {
                                if (expiredTemp != null && entry.offset >= 0) {
                                    truncate = true;
                                    expiredTemp.add(entry);
                                }
                            } else if (isLogFile) {
                                scheduledOffset += header.totalLength();
                                continue;
                            }
                        } else {
                            if (entry.file == scheduledFile && entry.offset == ~scheduledOffset) {
                                log.tracef("Key for %d:%d ignored as it was expired but was in temporary table", new Object[0]);
                                scheduledOffset += header.totalLength();
                                continue;
                            }
                            truncate = true;
                        }
                    }
                    drop = false;
                } else {
                    log.tracef("Loading from index for key %s when processing file %s", key, scheduledFile);
                    EntryInfo info = this.index.getInfo(key, segment, serializedKey);
                    if (info == null) {
                        if (isLogFile) {
                            log.tracef("No index found for key %s, but it is a logFile, ignoring rest of the file", key);
                            break;
                        }
                        log.tracef("No index found for key %s, dropping - assuming lost due to segments removed", key);
                        scheduledOffset += header.totalLength();
                        continue;
                    }
                    if (info.numRecords <= 0) {
                        throw new IllegalArgumentException("Number of records " + info.numRecords + " for index of key " + String.valueOf(key) + " should be more than zero!");
                    }
                    if (info.file == scheduledFile && info.offset == scheduledOffset) {
                        assert (header.valueLength() > 0);
                        long entryExpiryTime = header.expiryTime();
                        if (entryExpiryTime >= 0L && entryExpiryTime <= currentTimeMilliseconds) {
                            if (expiredIndex != null) {
                                EntryRecord record = this.index.getRecordEvenIfExpired(key, segment, serializedKey);
                                if (record == null) {
                                    log.tracef("Key %s is not in index to do expiration event - assuming lost due to segments removed", key);
                                    scheduledOffset += header.totalLength();
                                    continue;
                                }
                                truncate = true;
                                expiredIndex.add(record);
                                if (info.numRecords > 1) {
                                    drop = false;
                                }
                            } else {
                                drop = false;
                            }
                        } else {
                            if (isLogFile) {
                                scheduledOffset += header.totalLength();
                                continue;
                            }
                            drop = false;
                        }
                        if (log.isTraceEnabled()) {
                            log.tracef("Is key %s at %d:%d expired? %s, numRecords? %d", new Object[]{key, scheduledFile, scheduledOffset, truncate, info.numRecords});
                        }
                    } else {
                        if (isLogFile) {
                            scheduledOffset += header.totalLength();
                            continue;
                        }
                        if (info.file == scheduledFile && info.offset == ~scheduledOffset && info.numRecords > 1) {
                            drop = false;
                        } else if (log.isTraceEnabled()) {
                            log.tracef("Key %s for %d:%d was found in index on %d:%d, %d record => drop", new Object[]{key, scheduledFile, scheduledOffset, info.file, info.offset, info.numRecords});
                        }
                    }
                    prevFile = info.file;
                    prevOffset = info.offset;
                }
                if (drop) {
                    if (log.isTraceEnabled()) {
                        log.tracef("Drop index for key %s, file %d:%d (%s)", new Object[]{key, scheduledFile, scheduledOffset, header.valueLength() > 0 ? "record" : "tombstone"});
                    }
                    this.index.handleRequest(IndexRequest.dropped(segment, key, (ByteBuffer)ByteBufferImpl.create((byte[])serializedKey), prevFile, prevOffset, scheduledFile, scheduledOffset));
                } else {
                    int writtenLength;
                    int entryOffset;
                    block76: {
                        if (this.logFile == null || this.currentOffset + header.totalLength() > this.maxFileSize) {
                            if (this.logFile != null) {
                                this.logFile.close();
                                this.completeFile(this.logFile.fileId, this.currentOffset, this.nextExpirationTime);
                                this.nextExpirationTime = -1L;
                            }
                            this.currentOffset = 0;
                            this.logFile = this.fileProvider.getFileForLog();
                            log.debugf("Compacting to %d", this.logFile.fileId);
                        }
                        byte[] serializedValue = null;
                        EntryMetadata metadata = null;
                        byte[] serializedInternalMetadata = null;
                        if (header.valueLength() > 0 && !truncate) {
                            if (header.metadataLength() > 0) {
                                metadata = EntryRecord.readMetadata(handle, header, scheduledOffset);
                            }
                            serializedValue = EntryRecord.readValue(handle, header, scheduledOffset);
                            if (header.internalMetadataLength() > 0) {
                                serializedInternalMetadata = EntryRecord.readInternalMetadata(handle, header, scheduledOffset);
                            }
                            entryOffset = this.currentOffset;
                            writtenLength = header.totalLength();
                            this.nextExpirationTime = ExpiryHelper.mostRecentExpirationTime(this.nextExpirationTime, header.expiryTime());
                        } else {
                            entryOffset = ~this.currentOffset;
                            writtenLength = header.getHeaderLength() + header.keyLength();
                        }
                        EntryRecord.writeEntry(this.logFile.fileChannel, this.REUSED_BUFFER, serializedKey, metadata, serializedValue, serializedInternalMetadata, header.seqId(), header.expiryTime());
                        TemporaryTable.LockedEntry lockedEntry = this.temporaryTable.replaceOrLock(segment, key, this.logFile.fileId, entryOffset, scheduledFile, indexedOffset);
                        if (lockedEntry == null) {
                            if (log.isTraceEnabled()) {
                                log.trace("Found entry in temporary table");
                            }
                        } else {
                            boolean update = false;
                            try {
                                EntryInfo info = this.index.getInfo(key, segment, serializedKey);
                                if (info == null) {
                                    log.tracef("Key %s was not found in index or temporary table assuming it is gone from removing segments, dropping", key);
                                    scheduledOffset += header.totalLength();
                                    continue;
                                }
                                boolean bl = update = info.file == scheduledFile && info.offset == indexedOffset;
                                if (!log.isTraceEnabled()) break block76;
                                log.tracef("In index the key is on %d:%d (%s)", info.file, info.offset, String.valueOf(update));
                            }
                            finally {
                                if (update) {
                                    this.temporaryTable.updateAndUnlock(lockedEntry, this.logFile.fileId, entryOffset);
                                    continue;
                                }
                                this.temporaryTable.removeAndUnlock(lockedEntry, segment, key);
                                continue;
                            }
                        }
                    }
                    if (log.isTraceEnabled()) {
                        log.tracef("Update %d:%d -> %d:%d | %d,%d", new Object[]{scheduledFile, indexedOffset, this.logFile.fileId, entryOffset, this.logFile.fileChannel.position(), this.logFile.fileChannel.size()});
                    }
                    ByteBufferImpl keyBuffer = ByteBufferImpl.create((byte[])serializedKey);
                    IndexRequest indexRequest = isLogFile ? IndexRequest.update(segment, key, (ByteBuffer)keyBuffer, this.logFile.fileId, entryOffset, writtenLength) : IndexRequest.moved(segment, key, (ByteBuffer)keyBuffer, this.logFile.fileId, entryOffset, writtenLength, scheduledFile, indexedOffset);
                    aggregateCompletionStage.dependsOn(this.index.handleRequest(indexRequest));
                    this.currentOffset += writtenLength;
                }
                scheduledOffset += header.totalLength();
            }
            if (subscriber != null) {
                log.tracef("Expired entries in temporary table %s and in index %s", expiredTemp, expiredIndex);
                for (EntryPosition entryPosition : expiredTemp) {
                    subscriber.onEntryPosition(entryPosition);
                }
                for (EntryRecord entryRecord : expiredIndex) {
                    subscriber.onEntryEntryRecord(entryRecord);
                }
            }
            if (!this.clearSignal.get()) {
                CompletionStage aggregate = aggregateCompletionStage.freeze();
                if (!CompletionStages.isCompletedSuccessfully((CompletionStage)aggregate)) {
                    log.tracef("Compactor paused, waiting for previous index updates to complete", new Object[0]);
                    aggregate.whenComplete((ignore, t) -> {
                        if (t != null) {
                            log.error("There was a problem moving indexes for compactor with file " + this.logFile.fileId, (Throwable)t);
                            compactionRequest.completeExceptionally((Throwable)t);
                        } else {
                            log.tracef("Compaction ended after index was updated for %s", scheduledFile);
                            this.completeFuture(compactionRequest);
                        }
                    });
                } else {
                    log.tracef("Compaction ended synchronously for %s", scheduledFile);
                    this.completeFuture(compactionRequest);
                }
            } else {
                log.tracef("Compaction ended early for %s due to pending clear signalled", scheduledFile);
                this.completeFuture(compactionRequest);
            }
        }
        if (isLogFile) {
            log.tracef("Finished expiring entries in log file %d, leaving file as is", scheduledFile);
        } else {
            log.tracef("Finished compacting %d, scheduling delete", scheduledFile);
            Stats stats = (Stats)this.fileStats.get(scheduledFile);
            if (stats != null) {
                stats.markForDeletion();
            }
            this.index.deleteFileAsync(scheduledFile);
        }
    }

    static class Stats {
        private final AtomicInteger free;
        private volatile int total;
        private volatile long nextExpirationTime;
        private volatile boolean completed = false;
        private final AtomicBoolean scheduled = new AtomicBoolean();
        private boolean markedForDeletion = false;

        private Stats(int total, int free, long nextExpirationTime) {
            this.free = new AtomicInteger(free);
            this.total = total;
            this.nextExpirationTime = nextExpirationTime;
        }

        public int getTotal() {
            return this.total;
        }

        public void setTotal(int total) {
            this.total = total;
        }

        public boolean addFree(int size, double compactionThreshold) {
            int free = this.free.addAndGet(size);
            return this.readyToBeScheduled(compactionThreshold, free);
        }

        public int getFree() {
            return this.free.get();
        }

        public long getNextExpirationTime() {
            return this.nextExpirationTime;
        }

        public void setNextExpirationTime(long nextExpirationTime) {
            this.nextExpirationTime = nextExpirationTime;
        }

        public boolean readyToBeScheduled(double compactionThreshold, int free) {
            int total = this.total;
            return this.completed && total >= 0 && (double)free >= (double)total * compactionThreshold && this.setScheduled();
        }

        public boolean isScheduled() {
            return this.scheduled.get();
        }

        public boolean setScheduled() {
            boolean scheduled = !this.scheduled.getAndSet(true);
            return scheduled;
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public void setCompleted() {
            this.completed = true;
        }

        public void markForDeletion() {
            this.markedForDeletion = true;
        }

        public boolean markedForDeletion() {
            return this.markedForDeletion;
        }

        public String toString() {
            return "Stats{free=" + String.valueOf(this.free) + ", total=" + this.total + ", nextExpirationTime=" + this.nextExpirationTime + ", completed=" + this.completed + ", scheduled=" + String.valueOf(this.scheduled) + ", markedForDeletion=" + this.markedForDeletion + "}";
        }
    }

    public static interface CompactionExpirationSubscriber {
        public void onEntryPosition(EntryPosition var1) throws IOException;

        public void onEntryEntryRecord(EntryRecord var1) throws IOException;

        public void onComplete();

        public void onError(Throwable var1);
    }

    private static class CompactionRequest
    extends CompletableFuture<Void> {
        private final int fileId;
        private final boolean isLogFile;
        private final CompactionExpirationSubscriber subscriber;

        private CompactionRequest(int fileId) {
            this(fileId, false, null);
        }

        private CompactionRequest(int fileId, boolean isLogFile, CompactionExpirationSubscriber subscriber) {
            this.fileId = fileId;
            this.isLogFile = isLogFile;
            this.subscriber = subscriber;
        }

        @Override
        public String toString() {
            return "CompactionRequest{fileId=" + this.fileId + "isLogFile=" + this.isLogFile + "isExpiration=" + (this.subscriber != null) + "}";
        }
    }

    private static class ClearFuture
    extends CompletableFuture<Void> {
        private ClearFuture() {
        }

        @Override
        public String toString() {
            return "ClearFuture{}";
        }
    }
}

