/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import liquibase.resource.ResourceAccessor;

public class MockResourceAccessor
implements ResourceAccessor {
    private Map<String, String> contentByFileName;

    public MockResourceAccessor() {
        this(new HashMap<String, String>());
    }

    public MockResourceAccessor(Map<String, String> contentByFileName) {
        this.contentByFileName = contentByFileName;
    }

    @Override
    public Set<InputStream> getResourcesAsStream(String path) throws IOException {
        ByteArrayInputStream stream = null;
        if (this.contentByFileName.containsKey(path)) {
            stream = new ByteArrayInputStream(this.contentByFileName.get(path).getBytes());
        }
        if (stream == null) {
            return null;
        }
        return new HashSet<InputStream>(Arrays.asList(stream));
    }

    @Override
    public Set<String> list(String relativeTo, String path, boolean includeFiles, boolean includeDirectories, boolean recursive) throws IOException {
        HashSet<String> returnSet = new HashSet<String>();
        for (String file : this.contentByFileName.keySet()) {
            if (!file.startsWith(path)) continue;
            returnSet.add(file);
        }
        return returnSet;
    }

    @Override
    public ClassLoader toClassLoader() {
        return null;
    }
}

