/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.yaml.internal;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.model.yaml.YamlElement;
import org.openhab.core.model.yaml.YamlElementName;
import org.openhab.core.model.yaml.YamlModelListener;
import org.openhab.core.model.yaml.YamlModelRepository;
import org.openhab.core.model.yaml.internal.YamlModelWrapper;
import org.openhab.core.service.WatchService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true)
public class YamlModelRepositoryImpl
implements WatchService.WatchEventListener,
YamlModelRepository {
    private static final int DEFAULT_MODEL_VERSION = 1;
    private final Logger logger = LoggerFactory.getLogger(YamlModelRepositoryImpl.class);
    private final WatchService watchService;
    private final Path watchPath;
    private final ObjectMapper objectMapper;
    private final Map<String, List<YamlModelListener<?>>> elementListeners = new ConcurrentHashMap();
    private final Map<String, YamlModelWrapper> modelCache = new ConcurrentHashMap<String, YamlModelWrapper>();

    @Activate
    public YamlModelRepositoryImpl(@Reference(target="(watchservice.name=configWatcher)") WatchService watchService) {
        YAMLFactory yamlFactory = YAMLFactory.builder().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).disable(YAMLGenerator.Feature.SPLIT_LINES).enable(YAMLGenerator.Feature.INDENT_ARRAYS_WITH_INDICATOR).enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).enable(YAMLParser.Feature.PARSE_BOOLEAN_LIKE_WORDS_AS_STRINGS).build();
        this.objectMapper = new ObjectMapper((JsonFactory)yamlFactory);
        this.objectMapper.findAndRegisterModules();
        this.objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        this.objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        this.watchService = watchService;
        watchService.registerListener((WatchService.WatchEventListener)this, Path.of("", new String[0]));
        this.watchPath = watchService.getWatchPath();
        try {
            Files.walkFileTree(this.watchPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(@NonNullByDefault(value={}) Path file, @NonNullByDefault(value={}) BasicFileAttributes attrs) throws IOException {
                    if (attrs.isRegularFile()) {
                        Path relativePath = YamlModelRepositoryImpl.this.watchPath.relativize(file);
                        YamlModelRepositoryImpl.this.processWatchEvent(WatchService.Kind.CREATE, relativePath);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(@NonNullByDefault(value={}) Path file, @NonNullByDefault(value={}) IOException exc) throws IOException {
                    YamlModelRepositoryImpl.this.logger.warn("Failed to process {}: {}", (Object)file.toAbsolutePath(), (Object)exc.getClass().getSimpleName());
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            this.logger.warn("Could not list YAML files in '{}', models might be missing: {}", (Object)this.watchPath, (Object)e.getMessage());
        }
    }

    @Deactivate
    public void deactivate() {
        this.watchService.unregisterListener((WatchService.WatchEventListener)this);
    }

    public synchronized void processWatchEvent(WatchService.Kind kind, Path path) {
        Path fullPath = this.watchPath.resolve(path);
        String pathString = path.toString();
        if (!Files.isReadable(fullPath) || Files.isDirectory(fullPath, new LinkOption[0]) || path.startsWith("automation") || !pathString.endsWith(".yaml") || fullPath.toFile().isHidden()) {
            this.logger.trace("Ignored {}", (Object)fullPath);
            return;
        }
        String modelName = pathString.substring(0, pathString.lastIndexOf("."));
        if (kind == WatchService.Kind.DELETE) {
            this.logger.info("Removing YAML model {}", (Object)modelName);
            YamlModelWrapper removedModel = this.modelCache.remove(modelName);
            if (removedModel == null) {
                return;
            }
            for (Map.Entry<String, List<JsonNode>> modelEntry : removedModel.getNodes().entrySet()) {
                String elementName = modelEntry.getKey();
                List<JsonNode> removedNodes = modelEntry.getValue();
                if (removedNodes.isEmpty()) continue;
                this.getElementListeners(elementName).forEach(listener -> {
                    List removedElements = this.parseJsonNodes(removedNodes, listener.getElementClass());
                    listener.removedModel(modelName, removedElements);
                });
            }
        } else {
            if (kind == WatchService.Kind.CREATE) {
                this.logger.info("Adding YAML model {}", (Object)modelName);
            } else {
                this.logger.info("Updating YAML model {}", (Object)modelName);
            }
            try {
                JsonNode fileContent = this.objectMapper.readTree(fullPath.toFile());
                JsonNode versionNode = fileContent.get("version");
                if (versionNode == null || !versionNode.canConvertToInt()) {
                    this.logger.warn("Version is missing or not a number in model {}. Ignoring it.", (Object)modelName);
                    return;
                }
                int modelVersion = versionNode.asInt();
                if (modelVersion != 1) {
                    this.logger.warn("Model {} has version {}, but only version 1 is supported. Ignoring it.", (Object)modelName, (Object)modelVersion);
                    return;
                }
                JsonNode readOnlyNode = fileContent.get("readOnly");
                boolean readOnly = readOnlyNode == null || readOnlyNode.asBoolean(false);
                YamlModelWrapper model = Objects.requireNonNull(this.modelCache.computeIfAbsent(modelName, k -> new YamlModelWrapper(modelVersion, readOnly)));
                Iterator it = fileContent.fields();
                while (it.hasNext()) {
                    Map.Entry element = (Map.Entry)it.next();
                    String elementName = (String)element.getKey();
                    JsonNode node = (JsonNode)element.getValue();
                    if (!node.isArray()) {
                        this.logger.trace("Element {} in model {} is not an array, ignoring it", (Object)elementName, (Object)modelName);
                        continue;
                    }
                    List<JsonNode> oldNodeElements = model.getNodes().getOrDefault(elementName, List.of());
                    ArrayList<JsonNode> newNodeElements = new ArrayList<JsonNode>();
                    node.elements().forEachRemaining(newNodeElements::add);
                    for (YamlModelListener<?> elementListener : this.getElementListeners(elementName)) {
                        Class<?> elementClass = elementListener.getElementClass();
                        Map<String, ? extends YamlElement> oldElements = this.listToMap(this.parseJsonNodes(oldNodeElements, elementClass));
                        Map<String, ? extends YamlElement> newElements = this.listToMap(this.parseJsonNodes(newNodeElements, elementClass));
                        List<YamlElement> addedElements = newElements.values().stream().filter(e -> !oldElements.containsKey(e.getId())).toList();
                        List<YamlElement> removedElements = oldElements.values().stream().filter(e -> !newElements.containsKey(e.getId())).toList();
                        List<YamlElement> updatedElements = newElements.values().stream().filter(e -> oldElements.containsKey(e.getId()) && !e.equals(oldElements.get(e.getId()))).toList();
                        if (!addedElements.isEmpty()) {
                            elementListener.addedModel(modelName, addedElements);
                        }
                        if (!removedElements.isEmpty()) {
                            elementListener.removedModel(modelName, removedElements);
                        }
                        if (updatedElements.isEmpty()) continue;
                        elementListener.updatedModel(modelName, updatedElements);
                    }
                    model.getNodes().put(elementName, newNodeElements);
                }
            }
            catch (IOException e2) {
                this.logger.warn("Failed to read {}: {}", (Object)modelName, (Object)e2.getMessage());
            }
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addYamlModelListener(YamlModelListener<? extends YamlElement> listener) {
        Class<? extends YamlElement> elementClass = listener.getElementClass();
        YamlElementName annotation = elementClass.getAnnotation(YamlElementName.class);
        if (annotation == null) {
            this.logger.warn("Class {} is missing the mandatory YamlElementName annotation. This is a bug.", elementClass);
            return;
        }
        String elementName = annotation.value();
        this.getElementListeners(elementName).add(listener);
        for (Map.Entry<String, YamlModelWrapper> model : this.modelCache.entrySet()) {
            String modelName = model.getKey();
            List<JsonNode> modelNodes = model.getValue().getNodes().get(elementName);
            if (modelNodes == null || modelNodes.isEmpty()) continue;
            List<? extends YamlElement> modelElements = this.parseJsonNodes(modelNodes, elementClass);
            listener.addedModel(modelName, modelElements);
        }
    }

    public void removeYamlModelListener(YamlModelListener<? extends YamlElement> listener) {
        this.elementListeners.values().forEach(list -> {
            boolean bl = list.remove(listener);
        });
    }

    @Override
    public void addElementToModel(String modelName, YamlElement element) {
        YamlElementName annotation = element.getClass().getAnnotation(YamlElementName.class);
        if (annotation == null) {
            this.logger.warn("Failed to add element {}. Class {}) is missing the mandatory YamlElementName annotation. This is a bug.", (Object)element.getId(), element.getClass());
            return;
        }
        String elementName = annotation.value();
        YamlModelWrapper model = Objects.requireNonNull(this.modelCache.computeIfAbsent(modelName, k -> new YamlModelWrapper(1, false)));
        if (model.isReadOnly()) {
            this.logger.warn("Modifying {} is not allowed, model is marked read-only", (Object)modelName);
            return;
        }
        List modelNodes = model.getNodes().computeIfAbsent(elementName, k -> new CopyOnWriteArrayList());
        JsonNode newNode = (JsonNode)this.objectMapper.convertValue((Object)element, JsonNode.class);
        modelNodes.add(newNode);
        this.getElementListeners(elementName).forEach(l -> {
            List newElements = this.parseJsonNodes(List.of(newNode), l.getElementClass());
            if (!newElements.isEmpty()) {
                l.addedModel(modelName, newElements);
            }
        });
        this.writeModel(modelName);
    }

    @Override
    public void removeElementFromModel(String modelName, YamlElement element) {
        YamlElementName annotation = element.getClass().getAnnotation(YamlElementName.class);
        if (annotation == null) {
            this.logger.warn("Failed to remove element {}. Class {}) is missing the mandatory YamlElementName annotation. This is a bug.", (Object)element.getId(), element.getClass());
            return;
        }
        String elementName = annotation.value();
        YamlModelWrapper model = this.modelCache.get(modelName);
        if (model == null) {
            this.logger.warn("Failed to remove {} from model {} because the model is not known.", (Object)element, (Object)modelName);
            return;
        }
        if (model.isReadOnly()) {
            this.logger.warn("Modifying {} is not allowed, model is marked read-only", (Object)modelName);
            return;
        }
        List<JsonNode> modelNodes = model.getNodes().get(elementName);
        if (modelNodes == null) {
            this.logger.warn("Failed to remove {} from model {} because type {} is not known in the model.", new Object[]{element, modelName, elementName});
            return;
        }
        JsonNode toRemove = this.findNodeById(modelNodes, element.getClass(), element.getId());
        if (toRemove == null) {
            this.logger.warn("Failed to remove {} from model {} because element is not in model.", (Object)element, (Object)modelName);
            return;
        }
        modelNodes.remove(toRemove);
        this.getElementListeners(elementName).forEach(l -> {
            List newElements = this.parseJsonNodes(List.of(toRemove), l.getElementClass());
            if (!newElements.isEmpty()) {
                l.addedModel(modelName, newElements);
            }
        });
        this.writeModel(modelName);
    }

    @Override
    public void updateElementInModel(String modelName, YamlElement element) {
        YamlElementName annotation = element.getClass().getAnnotation(YamlElementName.class);
        if (annotation == null) {
            this.logger.warn("Failed to update element {}. Class {}) is missing the mandatory YamlElementName annotation. This is a bug.", (Object)element.getId(), element.getClass());
            return;
        }
        String elementName = annotation.value();
        YamlModelWrapper model = this.modelCache.get(modelName);
        if (model == null) {
            this.logger.warn("Failed to update {} in model {} because the model is not known.", (Object)element, (Object)modelName);
            return;
        }
        if (model.isReadOnly()) {
            this.logger.warn("Modifying {} is not allowed, model is marked read-only", (Object)modelName);
            return;
        }
        List<JsonNode> modelNodes = model.getNodes().get(elementName);
        if (modelNodes == null) {
            this.logger.warn("Failed to update {} in model {} because type {} is not known in the model.", new Object[]{element, modelName, elementName});
            return;
        }
        JsonNode oldElement = this.findNodeById(modelNodes, element.getClass(), element.getId());
        if (oldElement == null) {
            this.logger.warn("Failed to update {} in model {} because element is not in model.", (Object)element, (Object)modelName);
            return;
        }
        JsonNode newNode = (JsonNode)this.objectMapper.convertValue((Object)element, JsonNode.class);
        modelNodes.set(modelNodes.indexOf(oldElement), newNode);
        this.getElementListeners(elementName).forEach(l -> {
            List newElements = this.parseJsonNodes(List.of(newNode), l.getElementClass());
            if (!newElements.isEmpty()) {
                l.updatedModel(modelName, newElements);
            }
        });
        this.writeModel(modelName);
    }

    private void writeModel(String modelName) {
        YamlModelWrapper model = this.modelCache.get(modelName);
        if (model == null) {
            this.logger.warn("Failed to write model {} to disk because it is not known.", (Object)modelName);
            return;
        }
        if (model.isReadOnly()) {
            this.logger.warn("Failed to write model {} to disk because it is marked as read-only.", (Object)modelName);
            return;
        }
        JsonNodeFactory nodeFactory = this.objectMapper.getNodeFactory();
        ObjectNode rootNode = nodeFactory.objectNode();
        rootNode.put("version", model.getVersion());
        rootNode.put("readOnly", model.isReadOnly());
        for (Map.Entry<String, List<JsonNode>> elementNodes : model.getNodes().entrySet()) {
            ArrayNode arrayNode = nodeFactory.arrayNode();
            elementNodes.getValue().forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
            rootNode.set(elementNodes.getKey(), (JsonNode)arrayNode);
        }
        try {
            Path outFile = this.watchPath.resolve(modelName + ".yaml");
            String fileContent = this.objectMapper.writeValueAsString((Object)rootNode);
            if (Files.exists(outFile, new LinkOption[0]) && !Files.isWritable(outFile)) {
                this.logger.warn("Failed writing model {}: model exists but is read-only.", (Object)modelName);
                return;
            }
            Files.writeString(outFile, (CharSequence)fileContent, new OpenOption[0]);
        }
        catch (JsonProcessingException e) {
            this.logger.warn("Failed to serialize model {}: {}", (Object)modelName, (Object)e.getMessage());
        }
        catch (IOException e) {
            this.logger.warn("Failed writing model {}: {}", (Object)modelName, (Object)e.getMessage());
        }
    }

    private List<YamlModelListener<?>> getElementListeners(String elementName) {
        return Objects.requireNonNull(this.elementListeners.computeIfAbsent(elementName, k -> new CopyOnWriteArrayList()));
    }

    private <T extends YamlElement> @Nullable JsonNode findNodeById(List<JsonNode> nodes, Class<T> elementClass, String id) {
        return nodes.stream().filter(node -> {
            Optional<YamlElement> parsedNode = this.parseJsonNode((JsonNode)node, elementClass);
            return parsedNode.filter(yamlDTO -> id.equals(yamlDTO.getId())).isPresent();
        }).findAny().orElse(null);
    }

    private Map<String, ? extends YamlElement> listToMap(List<? extends YamlElement> elements) {
        return elements.stream().collect(Collectors.toMap(YamlElement::getId, e -> e));
    }

    private <T extends YamlElement> List<T> parseJsonNodes(List<JsonNode> nodes, Class<T> elementClass) {
        return nodes.stream().map(nE -> this.parseJsonNode((JsonNode)nE, elementClass)).flatMap(Optional::stream).filter(YamlElement::isValid).toList();
    }

    private <T extends YamlElement> Optional<T> parseJsonNode(JsonNode node, Class<T> elementClass) {
        try {
            return Optional.of((YamlElement)this.objectMapper.treeToValue((TreeNode)node, elementClass));
        }
        catch (JsonProcessingException e) {
            this.logger.warn("Could not parse element {} to {}: {}", new Object[]{node, elementClass, e.getMessage()});
            return Optional.empty();
        }
    }
}

