/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geocoder;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.ws.rs.client.Client;
import org.traccar.geocoder.Address;
import org.traccar.geocoder.AddressFormat;
import org.traccar.geocoder.JsonGeocoder;

public class GeocodeJsonGeocoder
extends JsonGeocoder {
    private static String formatUrl(String url, String key, String language) {
        if (url == null) {
            url = "https://photon.komoot.io/reverse";
        }
        url = (String)url + "?lat=%f&lon=%f";
        if (key != null) {
            url = (String)url + "&key=" + key;
        }
        if (language != null) {
            url = (String)url + "&lang=" + language;
        }
        return url;
    }

    public GeocodeJsonGeocoder(Client client, String url, String key, String language, int cacheSize, AddressFormat addressFormat) {
        super(client, GeocodeJsonGeocoder.formatUrl(url, key, language), cacheSize, addressFormat);
    }

    @Override
    public Address parseAddress(JsonObject json) {
        JsonArray features = json.getJsonArray("features");
        if (!features.isEmpty()) {
            Address address = new Address();
            JsonObject properties = features.getJsonObject(0).getJsonObject("properties");
            if (properties.containsKey((Object)"label")) {
                address.setFormattedAddress(properties.getString("label"));
            }
            if (properties.containsKey((Object)"housenumber")) {
                address.setHouse(properties.getString("housenumber"));
            }
            if (properties.containsKey((Object)"street")) {
                address.setStreet(properties.getString("street"));
            }
            if (properties.containsKey((Object)"city")) {
                address.setSettlement(properties.getString("city"));
            }
            if (properties.containsKey((Object)"district")) {
                address.setDistrict(properties.getString("district"));
            }
            if (properties.containsKey((Object)"state")) {
                address.setState(properties.getString("state"));
            }
            if (properties.containsKey((Object)"countrycode")) {
                address.setCountry(properties.getString("countrycode").toUpperCase());
            }
            if (properties.containsKey((Object)"postcode")) {
                address.setPostcode(properties.getString("postcode"));
            }
            return address;
        }
        return null;
    }
}

