/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.ice4j.ice.CandidatePair;
import org.ice4j.ice.CandidatePairState;
import org.ice4j.ice.CheckListState;
import org.ice4j.ice.Component;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.RemoteCandidate;
import org.jitsi.utils.logging2.Logger;

public class CheckList
extends Vector<CandidatePair> {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_CHECK_LIST_STATE = "CheckListState";
    public static final String PROPERTY_CHECK_LIST_CHECKS = "CheckListChecks";
    private CheckListState state = CheckListState.RUNNING;
    private final List<CandidatePair> triggeredCheckQueue = new LinkedList<CandidatePair>();
    private final IceMediaStream parentStream;
    private final List<PropertyChangeListener> stateListeners = new LinkedList<PropertyChangeListener>();
    private final List<PropertyChangeListener> checkListeners = new LinkedList<PropertyChangeListener>();
    private Logger logger;

    protected CheckList(IceMediaStream parentStream) {
        this.parentStream = parentStream;
        this.logger = parentStream.getLogger().createChildLogger(this.getClass().getName());
    }

    public CheckListState getState() {
        return this.state;
    }

    protected void setState(CheckListState newState) {
        CheckListState oldState = this.state;
        this.state = newState;
        this.fireStateChange(oldState, newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleTriggeredCheck(CandidatePair pair) {
        List<CandidatePair> list = this.triggeredCheckQueue;
        synchronized (list) {
            if (!this.triggeredCheckQueue.contains(pair)) {
                this.triggeredCheckQueue.add(pair);
                pair.setStateWaiting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CandidatePair popTriggeredCheck() {
        List<CandidatePair> list = this.triggeredCheckQueue;
        synchronized (list) {
            if (this.triggeredCheckQueue.size() > 0) {
                return this.triggeredCheckQueue.remove(0);
            }
        }
        return null;
    }

    protected synchronized CandidatePair getNextOrdinaryPairToCheck() {
        if (this.size() < 1) {
            return null;
        }
        CandidatePair highestPriorityPair = null;
        for (CandidatePair pair : this) {
            if (pair.getState() != CandidatePairState.WAITING || highestPriorityPair != null && pair.getPriority() <= highestPriorityPair.getPriority()) continue;
            highestPriorityPair = pair;
        }
        if (highestPriorityPair != null) {
            return highestPriorityPair;
        }
        for (CandidatePair pair : this) {
            if (pair.getState() != CandidatePairState.FROZEN || highestPriorityPair != null && pair.getPriority() <= highestPriorityPair.getPriority()) continue;
            highestPriorityPair = pair;
            pair.setStateWaiting();
        }
        return highestPriorityPair;
    }

    public synchronized CandidatePair findPairMatching(LocalCandidate local, RemoteCandidate remote) {
        for (CandidatePair pair : this) {
            if (pair.getLocalCandidate() != local && !pair.getLocalCandidate().getTransportAddress().equals(local.getTransportAddress()) || pair.getRemoteCandidate() != remote && !pair.getRemoteCandidate().getTransportAddress().equals(remote.getTransportAddress())) continue;
            return pair;
        }
        return null;
    }

    public synchronized boolean isActive() {
        for (CandidatePair pair : this) {
            if (pair.getState() != CandidatePairState.WAITING) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean allChecksCompleted() {
        for (CandidatePair pair : this) {
            CandidatePairState pairState = pair.getState();
            if (pairState == CandidatePairState.SUCCEEDED || pairState == CandidatePairState.FAILED) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean isFrozen() {
        for (CandidatePair pair : this) {
            if (pair.getState() == CandidatePairState.FROZEN) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder buff = new StringBuilder("CheckList. (num pairs=");
        buff.append(this.size()).append(")\n");
        for (CandidatePair pair : this) {
            buff.append(pair).append("\n");
        }
        return buff.toString();
    }

    protected synchronized void computeInitialCheckListPairStates() {
        Hashtable<String, CandidatePair> pairsToWait = new Hashtable<String, CandidatePair>();
        for (CandidatePair pair : this) {
            CandidatePair prevPair = (CandidatePair)pairsToWait.get(pair.getFoundation());
            if (prevPair == null) {
                pairsToWait.put(pair.getFoundation(), pair);
                continue;
            }
            if (prevPair.getParentComponent() == pair.getParentComponent()) {
                if (pair.getPriority() <= prevPair.getPriority()) continue;
                pairsToWait.put(pair.getFoundation(), pair);
                continue;
            }
            if (pair.getParentComponent().getComponentID() >= prevPair.getParentComponent().getComponentID()) continue;
            pairsToWait.put(pair.getFoundation(), pair);
        }
        for (CandidatePair pairToWait : pairsToWait.values()) {
            pairToWait.setStateWaiting();
        }
    }

    protected synchronized void recomputePairPriorities() {
        for (CandidatePair pair : this) {
            pair.computePriority();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void handleNominationConfirmed(CandidatePair nominatedPair) {
        Component cmp = nominatedPair.getParentComponent();
        if (cmp.getSelectedPair() != null) {
            return;
        }
        this.logger.info("Selected pair for stream " + cmp.toShortString() + ": " + nominatedPair.toRedactedShortString());
        cmp.setSelectedPair(nominatedPair);
        Iterator pairsIter = this.iterator();
        while (pairsIter.hasNext()) {
            CandidatePair pair = (CandidatePair)pairsIter.next();
            if (pair.getParentComponent() != cmp || pair.getState() != CandidatePairState.WAITING && pair.getState() != CandidatePairState.FROZEN && (pair.getState() != CandidatePairState.IN_PROGRESS || pair.getPriority() >= nominatedPair.getPriority())) continue;
            pairsIter.remove();
        }
        List<CandidatePair> list = this.triggeredCheckQueue;
        synchronized (list) {
            Iterator<CandidatePair> triggeredPairsIter = this.triggeredCheckQueue.iterator();
            while (triggeredPairsIter.hasNext()) {
                CandidatePair pair = triggeredPairsIter.next();
                if (pair.getParentComponent() != cmp || pair.getState() != CandidatePairState.WAITING && pair.getState() != CandidatePairState.FROZEN && (pair.getState() != CandidatePairState.IN_PROGRESS || pair.getPriority() >= nominatedPair.getPriority())) continue;
                triggeredPairsIter.remove();
            }
        }
    }

    public String getName() {
        return this.parentStream.getName();
    }

    @Deprecated
    public synchronized boolean containsNomineeForComponent(Component component) {
        for (CandidatePair pair : this) {
            if (!pair.isNominated() || pair.getParentComponent() != component) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStateChangeListener(PropertyChangeListener l) {
        List<PropertyChangeListener> list = this.stateListeners;
        synchronized (list) {
            if (!this.stateListeners.contains(l)) {
                this.stateListeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStateChangeListener(PropertyChangeListener l) {
        List<PropertyChangeListener> list = this.stateListeners;
        synchronized (list) {
            this.stateListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateChange(CheckListState oldState, CheckListState newState) {
        LinkedList<PropertyChangeListener> listenersCopy;
        List<PropertyChangeListener> list = this.stateListeners;
        synchronized (list) {
            listenersCopy = new LinkedList<PropertyChangeListener>(this.stateListeners);
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, PROPERTY_CHECK_LIST_STATE, (Object)oldState, (Object)newState);
        for (PropertyChangeListener l : listenersCopy) {
            l.propertyChange(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChecksListener(PropertyChangeListener l) {
        List<PropertyChangeListener> list = this.checkListeners;
        synchronized (list) {
            if (!this.checkListeners.contains(l)) {
                this.checkListeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChecksListener(PropertyChangeListener l) {
        List<PropertyChangeListener> list = this.checkListeners;
        synchronized (list) {
            if (this.checkListeners.contains(l)) {
                this.checkListeners.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEndOfOrdinaryChecks() {
        LinkedList<PropertyChangeListener> listenersCopy;
        List<PropertyChangeListener> list = this.checkListeners;
        synchronized (list) {
            listenersCopy = new LinkedList<PropertyChangeListener>(this.checkListeners);
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, PROPERTY_CHECK_LIST_CHECKS, false, true);
        for (PropertyChangeListener l : listenersCopy) {
            l.propertyChange(evt);
        }
    }

    public IceMediaStream getParentStream() {
        return this.parentStream;
    }
}

