/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.security.AuthenticationCompletionException;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.AuthenticationRedirectException;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.security.AbstractPathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.EagerSecurityInterceptorStorage;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.HttpAuthorizer;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.quarkus.vertx.http.runtime.security.MtlsAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.PathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import io.smallrye.mutiny.tuples.Functions;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class HttpSecurityRecorder {
    private static final Logger log = Logger.getLogger(HttpSecurityRecorder.class);

    public Handler<RoutingContext> authenticationMechanismHandler(boolean proactiveAuthentication) {
        return new HttpAuthenticationHandler(proactiveAuthentication);
    }

    public Handler<RoutingContext> permissionCheckHandler() {
        return new Handler<RoutingContext>(){
            volatile HttpAuthorizer authorizer;

            public void handle(RoutingContext event) {
                if (this.authorizer == null) {
                    this.authorizer = (HttpAuthorizer)CDI.current().select(HttpAuthorizer.class, new Annotation[0]).get();
                }
                this.authorizer.checkPermission(event);
            }
        };
    }

    public Handler<RoutingContext> formAuthPostHandler() {
        return new Handler<RoutingContext>(){

            public void handle(final RoutingContext event) {
                Uni user = (Uni)event.get("io.quarkus.vertx.http.deferred-identity");
                user.subscribe().withSubscriber((UniSubscriber)new UniSubscriber<SecurityIdentity>(){

                    public void onSubscribe(UniSubscription uniSubscription) {
                    }

                    public void onItem(SecurityIdentity securityIdentity) {
                        event.next();
                    }

                    public void onFailure(Throwable throwable) {
                        event.fail(throwable);
                    }
                });
            }
        };
    }

    public Supplier<EagerSecurityInterceptorStorage> createSecurityInterceptorStorage(Map<RuntimeValue<MethodDescription>, Consumer<RoutingContext>> endpointRuntimeValToInterceptor) {
        final HashMap<MethodDescription, Consumer<RoutingContext>> endpointToInterceptor = new HashMap<MethodDescription, Consumer<RoutingContext>>();
        for (Map.Entry<RuntimeValue<MethodDescription>, Consumer<RoutingContext>> entry : endpointRuntimeValToInterceptor.entrySet()) {
            endpointToInterceptor.put((MethodDescription)entry.getKey().getValue(), entry.getValue());
        }
        return new Supplier<EagerSecurityInterceptorStorage>(){

            @Override
            public EagerSecurityInterceptorStorage get() {
                return new EagerSecurityInterceptorStorage(endpointToInterceptor);
            }
        };
    }

    public RuntimeValue<HttpSecurityPolicy> createNamedHttpSecurityPolicy(final Supplier<HttpSecurityPolicy> policySupplier, final String name) {
        return new RuntimeValue((Object)new HttpSecurityPolicy(){
            private final HttpSecurityPolicy delegate;
            {
                this.delegate = (HttpSecurityPolicy)policySupplier.get();
            }

            @Override
            public Uni<HttpSecurityPolicy.CheckResult> checkPermission(RoutingContext request, Uni<SecurityIdentity> identity, HttpSecurityPolicy.AuthorizationRequestContext requestContext) {
                return this.delegate.checkPermission(request, identity, requestContext);
            }

            @Override
            public String name() {
                return name;
            }
        });
    }

    public void setMtlsCertificateRoleProperties(HttpConfiguration config) {
        InstanceHandle mtls = Arc.container().instance(MtlsAuthenticationMechanism.class, new Annotation[0]);
        if (mtls.isAvailable() && config.auth.certificateRoleProperties.isPresent()) {
            Path rolesPath = config.auth.certificateRoleProperties.get();
            URL rolesResource = null;
            if (Files.exists(rolesPath, new LinkOption[0])) {
                try {
                    rolesResource = rolesPath.toUri().toURL();
                }
                catch (MalformedURLException malformedURLException) {}
            } else {
                rolesResource = Thread.currentThread().getContextClassLoader().getResource(rolesPath.toString());
            }
            if (rolesResource == null) {
                throw new ConfigurationException("quarkus.http.auth.certificate-role-properties location can not be resolved", Set.of("quarkus.http.auth.certificate-role-properties"));
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(rolesResource.openStream(), StandardCharsets.UTF_8));){
                Properties rolesProps = new Properties();
                rolesProps.load(reader);
                HashMap<String, Set<String>> roles = new HashMap<String, Set<String>>();
                for (Map.Entry<Object, Object> e : rolesProps.entrySet()) {
                    log.debugf("Added role mapping for %s:%s", e.getKey(), e.getValue());
                    roles.put((String)e.getKey(), HttpSecurityRecorder.parseRoles((String)e.getValue()));
                }
                ((MtlsAuthenticationMechanism)mtls.get()).setRoleMappings(roles);
            }
            catch (Exception e) {
                log.warnf("Unable to read roles mappings from %s:%s", (Object)rolesPath, (Object)e.getMessage());
            }
        }
    }

    private static Set<String> parseRoles(String value) {
        HashSet<String> roles = new HashSet<String>();
        for (String s : value.split(",")) {
            roles.add(s.trim());
        }
        return Set.copyOf(roles);
    }

    static class HttpAuthenticationHandler
    extends AbstractAuthenticationHandler {
        volatile PathMatchingHttpSecurityPolicy pathMatchingPolicy;

        public HttpAuthenticationHandler(boolean proactiveAuthentication) {
            super(proactiveAuthentication);
        }

        @Override
        protected void setPathMatchingPolicy(RoutingContext event) {
            if (this.pathMatchingPolicy == null) {
                Instance pathMatchingPolicyInstance = CDI.current().select(PathMatchingHttpSecurityPolicy.class, new Annotation[0]);
                PathMatchingHttpSecurityPolicy pathMatchingHttpSecurityPolicy = this.pathMatchingPolicy = pathMatchingPolicyInstance.isResolvable() ? (PathMatchingHttpSecurityPolicy)pathMatchingPolicyInstance.get() : null;
            }
            if (this.pathMatchingPolicy != null) {
                event.put(AbstractPathMatchingHttpSecurityPolicy.class.getName(), (Object)this.pathMatchingPolicy);
            }
        }

        @Override
        protected boolean httpPermissionsEmpty() {
            return ((HttpConfiguration)CDI.current().select(HttpConfiguration.class, (Annotation[])new Annotation[0]).get()).auth.permissions.isEmpty();
        }
    }

    public static abstract class AbstractAuthenticationHandler
    implements Handler<RoutingContext> {
        volatile HttpAuthenticator authenticator;
        volatile Boolean patchMatchingPolicyEnabled = null;
        final boolean proactiveAuthentication;

        public AbstractAuthenticationHandler(boolean proactiveAuthentication) {
            this.proactiveAuthentication = proactiveAuthentication;
        }

        public void handle(final RoutingContext event) {
            if (this.authenticator == null) {
                this.authenticator = (HttpAuthenticator)CDI.current().select(HttpAuthenticator.class, new Annotation[0]).get();
            }
            event.put(HttpAuthenticator.class.getName(), (Object)this.authenticator);
            if (this.patchMatchingPolicyEnabled == null) {
                this.setPatchMatchingPolicyEnabled();
            }
            if (this.patchMatchingPolicyEnabled.booleanValue()) {
                this.setPathMatchingPolicy(event);
            }
            if (this.proactiveAuthentication) {
                event.put("io.quarkus.vertx.http.auth-failure-handler", (Object)new DefaultAuthFailureHandler(){

                    @Override
                    protected void proceed(Throwable throwable) {
                        if (!event.failed()) {
                            event.fail(throwable);
                        }
                    }
                });
            } else {
                event.put("io.quarkus.vertx.http.auth-failure-handler", (Object)new DefaultAuthFailureHandler(){

                    @Override
                    protected void proceed(Throwable throwable) {
                        event.end();
                    }
                });
            }
            if (this.proactiveAuthentication) {
                final Uni potentialUser = this.authenticator.attemptAuthentication(event).memoize().indefinitely();
                potentialUser.subscribe().withSubscriber((UniSubscriber)new UniSubscriber<SecurityIdentity>(){

                    public void onSubscribe(UniSubscription subscription) {
                    }

                    public void onItem(SecurityIdentity identity) {
                        if (event.response().ended()) {
                            return;
                        }
                        if (identity == null) {
                            final Uni anon = authenticator.getIdentityProviderManager().authenticate(HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)new AnonymousAuthenticationRequest(), event));
                            anon.subscribe().withSubscriber((UniSubscriber)new UniSubscriber<SecurityIdentity>(){

                                public void onSubscribe(UniSubscription subscription) {
                                }

                                public void onItem(SecurityIdentity item) {
                                    event.put("io.quarkus.vertx.http.deferred-identity", (Object)anon);
                                    event.setUser((User)new QuarkusHttpUser(item));
                                    event.next();
                                }

                                public void onFailure(Throwable failure) {
                                    BiConsumer handler = (BiConsumer)event.get("io.quarkus.vertx.http.auth-failure-handler");
                                    if (handler != null) {
                                        handler.accept(event, failure);
                                    }
                                }
                            });
                        } else {
                            event.setUser((User)new QuarkusHttpUser(identity));
                            event.put("io.quarkus.vertx.http.deferred-identity", (Object)potentialUser);
                            event.next();
                        }
                    }

                    public void onFailure(Throwable failure) {
                        BiConsumer handler = (BiConsumer)event.get("io.quarkus.vertx.http.auth-failure-handler");
                        if (handler != null) {
                            handler.accept(event, failure);
                        }
                    }
                });
            } else {
                Uni lazyUser = Uni.createFrom().nullItem().flatMap(n -> this.authenticator.attemptAuthentication(event)).memoize().indefinitely().flatMap((Function)new Function<SecurityIdentity, Uni<? extends SecurityIdentity>>(){

                    @Override
                    public Uni<? extends SecurityIdentity> apply(SecurityIdentity securityIdentity) {
                        if (securityIdentity == null) {
                            return authenticator.getIdentityProviderManager().authenticate(HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)new AnonymousAuthenticationRequest(), event));
                        }
                        return Uni.createFrom().item((Object)securityIdentity);
                    }
                }).onTermination().invoke((Functions.TriConsumer)new Functions.TriConsumer<SecurityIdentity, Throwable, Boolean>(){

                    public void accept(SecurityIdentity identity, Throwable throwable, Boolean aBoolean) {
                        BiConsumer handler;
                        if (identity != null) {
                            event.setUser((User)new QuarkusHttpUser(identity));
                        } else if (throwable != null && (handler = (BiConsumer)event.get("io.quarkus.vertx.http.auth-failure-handler")) != null) {
                            handler.accept(event, throwable);
                        }
                    }
                }).memoize().indefinitely();
                event.put("io.quarkus.vertx.http.deferred-identity", (Object)lazyUser);
                event.next();
            }
        }

        private synchronized void setPatchMatchingPolicyEnabled() {
            if (this.patchMatchingPolicyEnabled == null) {
                this.patchMatchingPolicyEnabled = !this.httpPermissionsEmpty();
            }
        }

        protected abstract void setPathMatchingPolicy(RoutingContext var1);

        protected abstract boolean httpPermissionsEmpty();
    }

    public static abstract class DefaultAuthFailureHandler
    implements BiConsumer<RoutingContext, Throwable> {
        protected DefaultAuthFailureHandler() {
        }

        @Override
        public void accept(final RoutingContext event, Throwable throwable) {
            if (event.response().ended()) {
                return;
            }
            if ((throwable = DefaultAuthFailureHandler.extractRootCause(throwable)) instanceof AuthenticationFailedException) {
                final AuthenticationFailedException authenticationFailedException = (AuthenticationFailedException)throwable;
                DefaultAuthFailureHandler.getAuthenticator(event).sendChallenge(event).subscribe().with((Consumer)new Consumer<Boolean>(){

                    @Override
                    public void accept(Boolean aBoolean) {
                        if (!event.response().ended()) {
                            this.proceed((Throwable)authenticationFailedException);
                        }
                    }
                }, (Consumer)new Consumer<Throwable>(){

                    @Override
                    public void accept(Throwable throwable) {
                        event.fail(throwable);
                    }
                });
            } else if (throwable instanceof AuthenticationCompletionException) {
                log.debug((Object)"Authentication has failed, returning HTTP status 401");
                event.response().setStatusCode(401);
                this.proceed(throwable);
            } else if (throwable instanceof AuthenticationRedirectException) {
                AuthenticationRedirectException redirectEx = (AuthenticationRedirectException)throwable;
                event.response().setStatusCode(redirectEx.getCode());
                event.response().headers().set(HttpHeaders.LOCATION, (CharSequence)redirectEx.getRedirectUri());
                event.response().headers().set(HttpHeaders.CACHE_CONTROL, (CharSequence)"no-store");
                event.response().headers().set("Pragma", "no-cache");
                this.proceed(throwable);
            } else {
                event.fail(throwable);
            }
        }

        protected abstract void proceed(Throwable var1);

        private static HttpAuthenticator getAuthenticator(RoutingContext event) {
            return (HttpAuthenticator)event.get(HttpAuthenticator.class.getName());
        }

        public static Throwable extractRootCause(Throwable throwable) {
            while (throwable instanceof CompletionException && throwable.getCause() != null || throwable instanceof CompositeException) {
                if (throwable instanceof CompositeException) {
                    throwable = (Throwable)((CompositeException)throwable).getCauses().get(0);
                    continue;
                }
                throwable = throwable.getCause();
            }
            return throwable;
        }
    }
}

