/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.IRBlockBody;
import org.jruby.runtime.MethodBlockBody;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.DataType;
import org.jruby.util.RubyStringBuilder;

@JRubyClass(name={"Proc"})
public class RubyProc
extends RubyObject
implements DataType {
    private Block block = Block.NULL_BLOCK;
    private final Block.Type type;
    private String file = null;
    private int line = -1;
    private boolean fromMethod;

    protected RubyProc(Ruby runtime2, RubyClass rubyClass, Block.Type type2) {
        super(runtime2, rubyClass);
        this.type = type2;
    }

    @Deprecated
    protected RubyProc(Ruby runtime2, RubyClass rubyClass, Block.Type type2, ISourcePosition sourcePosition) {
        this(runtime2, rubyClass, type2, sourcePosition.getFile(), sourcePosition.getLine());
    }

    protected RubyProc(Ruby runtime2, RubyClass rubyClass, Block.Type type2, String file2, int line) {
        this(runtime2, rubyClass, type2);
        this.file = file2;
        this.line = line;
    }

    public RubyProc(Ruby runtime2, RubyClass rubyClass, Block block, String file2, int line) {
        this(runtime2, rubyClass, block.type, file2, line);
        this.block = block;
    }

    public static RubyClass createProcClass(Ruby runtime2) {
        RubyClass procClass = runtime2.defineClass("Proc", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        procClass.setClassIndex(ClassIndex.PROC);
        procClass.setReifiedClass(RubyProc.class);
        procClass.defineAnnotatedMethods(RubyProc.class);
        return procClass;
    }

    public Block getBlock() {
        return this.block;
    }

    @Deprecated
    public static RubyProc newProc(Ruby runtime2, Block.Type type2) {
        throw runtime2.newRuntimeError("deprecated RubyProc.newProc with no block; do not use");
    }

    public static RubyProc newProc(Ruby runtime2, Block block, Block.Type type2) {
        if (type2 == Block.Type.NORMAL) {
            type2 = Block.Type.PROC;
        }
        RubyProc proc2 = new RubyProc(runtime2, runtime2.getProc(), type2);
        proc2.setup(block);
        return proc2;
    }

    @Deprecated
    public static RubyProc newProc(Ruby runtime2, Block block, Block.Type type2, ISourcePosition sourcePosition) {
        RubyProc proc2 = new RubyProc(runtime2, runtime2.getProc(), type2, sourcePosition);
        proc2.setup(block);
        return proc2;
    }

    public static RubyProc newProc(Ruby runtime2, Block block, Block.Type type2, String file2, int line) {
        RubyProc proc2 = new RubyProc(runtime2, runtime2.getProc(), type2, file2, line);
        proc2.setup(block);
        return proc2;
    }

    @JRubyMethod(name={"new"}, rest=true, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            throw context.runtime.newArgumentError("tried to create Proc object without a block");
        }
        if (block.isGiven() && block.getProcObject() != null && block.getProcObject().metaClass == recv2) {
            return block.getProcObject();
        }
        RubyProc obj = new RubyProc(context.runtime, (RubyClass)recv2, Block.Type.PROC);
        obj.setup(block);
        obj.callMethod(context, "initialize", args2, block);
        return obj;
    }

    private void setup(Block procBlock) {
        if (!procBlock.isGiven()) {
            throw this.getRuntime().newArgumentError("tried to create Proc object without a block");
        }
        if (this.isLambda()) {
            // empty if block
        }
        if (this.isThread()) {
            Binding oldBinding = procBlock.getBinding();
            Binding newBinding = new Binding(oldBinding.getSelf(), oldBinding.getFrame().duplicate(), oldBinding.getVisibility(), oldBinding.getDynamicScope(), oldBinding.getMethod(), oldBinding.getFile(), oldBinding.getLine());
            this.block = new Block(procBlock.getBody(), newBinding, this.type);
            this.block.escape();
            StaticScope oldScope = this.block.getBody().getStaticScope();
            StaticScope newScope = oldScope.duplicate();
            this.block.getBody().setStaticScope(newScope);
        } else {
            this.block = this.type != procBlock.type ? procBlock.cloneBlockAsType(this.type) : procBlock;
        }
        this.block.getBinding().setFile(this.block.getBody().getFile());
        this.block.getBinding().setLine(this.block.getBody().getLine());
        this.block.setProcObject(this);
        this.block.getBinding().getDummyScope(this.block.getBody().getStaticScope());
    }

    @Override
    @JRubyMethod(name={"clone"})
    public IRubyObject rbClone() {
        RubyProc proc2 = RubyProc.newProc(this.getRuntime(), this.block, this.type, this.file, this.line);
        if (this.isFrozen()) {
            proc2.setFrozen(true);
        }
        return proc2;
    }

    @Override
    @JRubyMethod(name={"dup"})
    public IRubyObject dup() {
        return RubyProc.newProc(this.getRuntime(), this.block, this.type, this.file, this.line);
    }

    @Override
    @JRubyMethod(name={"to_s"}, alias={"inspect"})
    public IRubyObject to_s() {
        Ruby runtime2 = this.getRuntime();
        RubyString string2 = runtime2.newString("#<");
        string2.setEncoding(RubyString.ASCII);
        string2.append(RubyStringBuilder.types(runtime2, (RubyModule)this.type()));
        string2.catString(":0x" + Integer.toString(System.identityHashCode(this.block), 16));
        boolean isSymbolProc = this.block.getBody() instanceof RubySymbol.SymbolProcBody;
        if (isSymbolProc) {
            string2.catString("(&:" + ((RubySymbol.SymbolProcBody)this.block.getBody()).getId() + ")");
        } else {
            this.file = this.block.getBody().getFile();
            if (this.file != null) {
                string2.catString(" " + this.file + ":" + (this.block.getBody().getLine() + 1));
            }
        }
        if (this.isLambda()) {
            string2.catString(" (lambda)");
        }
        string2.catString(">");
        return string2;
    }

    @JRubyMethod
    public IRubyObject ruby2_keywords(ThreadContext context) {
        this.checkFrozen();
        if (this.fromMethod) {
            context.runtime.getWarnings().warn(IRubyWarnings.ID.MISCELLANEOUS, "Skipping set of ruby2_keywords flag for proc (proc created from method)");
            return this;
        }
        BlockBody body = this.block.getBody();
        if (body.isRubyBlock()) {
            Signature signature = body.getSignature();
            if (signature.hasRest() && !signature.hasKwargs()) {
                ((IRBlockBody)body).getScope().setRuby2Keywords();
            } else {
                context.runtime.getWarnings().warn(IRubyWarnings.ID.MISCELLANEOUS, "Skipping set of ruby2_keywords flag for proc (proc accepts keywords or proc does not accept argument splat)");
            }
        } else {
            context.runtime.getWarnings().warn(IRubyWarnings.ID.MISCELLANEOUS, "Skipping set of ruby2_keywords flag for proc (proc not defined in Ruby)");
        }
        return this;
    }

    @JRubyMethod(name={"binding"})
    public IRubyObject binding() {
        return this.getRuntime().newBinding(this.block.getBinding());
    }

    @Override
    @JRubyMethod(name={"==", "eql?"})
    public IRubyObject op_equal(ThreadContext context, IRubyObject obj) {
        if (this.getMetaClass() != obj.getMetaClass()) {
            return context.fals;
        }
        RubyProc other = (RubyProc)obj;
        if (this.isFromMethod() != other.isFromMethod() && this.isLambda() != other.isLambda()) {
            return context.fals;
        }
        if (this.type != other.type) {
            return context.fals;
        }
        return context.runtime.newBoolean(this.getBlock().equals(other.block));
    }

    @Deprecated
    public static IRubyObject[] prepareArgs(ThreadContext context, Block.Type type2, BlockBody blockBody, IRubyObject[] args2) {
        if (type2 == Block.Type.LAMBDA) {
            return args2;
        }
        int arityValue = blockBody.getSignature().arityValue();
        if (args2.length == 1 && (arityValue < -1 || arityValue > 1)) {
            args2 = IRRuntimeHelpers.toAry(context, args2);
        }
        return args2;
    }

    private static IRubyObject[] checkArityForLambda(ThreadContext context, Block.Type type2, BlockBody blockBody, IRubyObject ... args2) {
        if (type2 == Block.Type.LAMBDA) {
            blockBody.getSignature().checkArity(context.runtime, args2);
        }
        return args2;
    }

    @JRubyMethod(name={"call", "[]", "yield", "==="}, rest=true, omit=true, keywords=true)
    public final IRubyObject call(ThreadContext context, IRubyObject[] args2, Block blockCallArg) {
        return this.block.call(context, args2, blockCallArg);
    }

    @JRubyMethod(name={"call", "[]", "yield", "==="}, omit=true, keywords=true)
    public final IRubyObject call(ThreadContext context, Block blockCallArg) {
        return this.block.call(context, RubyProc.checkArityForLambda(context, this.type, this.block.getBody(), NULL_ARRAY), blockCallArg);
    }

    @JRubyMethod(name={"call", "[]", "yield", "==="}, omit=true, keywords=true)
    public final IRubyObject call(ThreadContext context, IRubyObject arg0, Block blockCallArg) {
        return this.block.call(context, new IRubyObject[]{arg0}, blockCallArg);
    }

    @JRubyMethod(name={"call", "[]", "yield", "==="}, omit=true, keywords=true)
    public final IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block blockCallArg) {
        return this.block.call(context, RubyProc.checkArityForLambda(context, this.type, this.block.getBody(), arg0, arg1), blockCallArg);
    }

    @JRubyMethod(name={"call", "[]", "yield", "==="}, omit=true, keywords=true)
    public final IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block blockCallArg) {
        return this.block.call(context, RubyProc.checkArityForLambda(context, this.type, this.block.getBody(), arg0, arg1, arg2), blockCallArg);
    }

    public final IRubyObject call(ThreadContext context, IRubyObject arg2) {
        return this.block.call(context, arg2);
    }

    public final IRubyObject call(ThreadContext context, IRubyObject ... args2) {
        return this.block.call(context, args2);
    }

    public final IRubyObject call(ThreadContext context, IRubyObject[] args2, IRubyObject self2, RubyModule sourceModule, Block passedBlock) {
        Block newBlock;
        assert (args2 != null);
        if (self2 == null || sourceModule == null) {
            newBlock = this.block;
        } else {
            newBlock = this.block.cloneBlockAndFrame();
            if (self2 != null) {
                newBlock.getBinding().setSelf(self2);
            }
            if (sourceModule != null) {
                newBlock.getFrame().setKlazz(sourceModule);
            }
        }
        return newBlock.call(context, args2, passedBlock);
    }

    @JRubyMethod(name={"arity"})
    public RubyFixnum arity() {
        Signature signature = this.block.getSignature();
        if (this.block.type == Block.Type.LAMBDA) {
            return this.getRuntime().newFixnum(signature.arityValue());
        }
        return this.getRuntime().newFixnum(signature.hasRest() ? signature.arityValue() : signature.required() + signature.getRequiredKeywordForArityCount());
    }

    @JRubyMethod(name={"to_proc"})
    public RubyProc to_proc() {
        return this;
    }

    @JRubyMethod
    public IRubyObject source_location(ThreadContext context) {
        Binding binding2;
        Ruby runtime2 = context.runtime;
        if (this.file != null) {
            return runtime2.newArray((IRubyObject)runtime2.newString(this.file), (IRubyObject)runtime2.newFixnum(this.line + 1));
        }
        if (this.block != null && (binding2 = this.block.getBinding()).getFile() != null) {
            return runtime2.newArray((IRubyObject)runtime2.newString(binding2.getFile()), (IRubyObject)runtime2.newFixnum(binding2.getLine() + 1));
        }
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject parameters(ThreadContext context) {
        BlockBody body = this.getBlock().getBody();
        return Helpers.argumentDescriptorsToParameters(context.runtime, body.getArgumentDescriptors(), this.isLambda());
    }

    @JRubyMethod(name={"lambda?"})
    public IRubyObject lambda_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.isLambda());
    }

    private boolean isLambda() {
        return this.type.equals((Object)Block.Type.LAMBDA);
    }

    private boolean isFromMethod() {
        return this.getBlock().getBody() instanceof MethodBlockBody;
    }

    private boolean isThread() {
        return this.type.equals((Object)Block.Type.THREAD);
    }

    @Deprecated
    public final IRubyObject call19(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.call(context, args2, block);
    }

    @Deprecated
    public IRubyObject to_s19() {
        return this.to_s();
    }

    @Deprecated
    public final IRubyObject call(ThreadContext context, IRubyObject[] args2, IRubyObject self2, Block passedBlock) {
        return this.block.call(context, args2, passedBlock);
    }

    public void setFromMethod() {
        this.fromMethod = true;
    }
}

