/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.io.InputStream;
import org.apache.derby.iapi.types.PositionedStream;
import org.apache.derby.shared.common.sanity.SanityManager;

public class CharacterStreamDescriptor {
    public static final long BEFORE_FIRST = 0L;
    private final long dataOffset;
    private final long curBytePos;
    private final long curCharPos;
    private final long byteLength;
    private final long charLength;
    private final long maxCharLength;
    private final boolean bufferable;
    private final boolean positionAware;
    private final InputStream stream;

    private CharacterStreamDescriptor(Builder b) {
        this.bufferable = b.bufferable;
        this.positionAware = b.positionAware;
        this.dataOffset = b.dataOffset;
        this.curBytePos = b.curBytePos;
        this.curCharPos = b.curCharPos;
        this.byteLength = b.byteLength;
        this.charLength = b.charLength;
        this.maxCharLength = b.maxCharLength;
        this.stream = b.stream;
    }

    public boolean isBufferable() {
        return this.bufferable;
    }

    public boolean isPositionAware() {
        return this.positionAware;
    }

    public long getByteLength() {
        return this.byteLength;
    }

    public long getCharLength() {
        return this.charLength;
    }

    public long getCurBytePos() {
        return this.curBytePos;
    }

    public long getCurCharPos() {
        return this.curCharPos;
    }

    public long getDataOffset() {
        return this.dataOffset;
    }

    public long getMaxCharLength() {
        return this.maxCharLength;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public PositionedStream getPositionedStream() {
        if (!this.positionAware) {
            throw new IllegalStateException("stream is not position aware: " + this.stream.getClass().getName());
        }
        return (PositionedStream)((Object)this.stream);
    }

    public String toString() {
        return "CharacterStreamDescriptor-" + this.hashCode() + "#bufferable=" + this.bufferable + ":positionAware=" + this.positionAware + ":byteLength=" + this.byteLength + ":charLength=" + this.charLength + ":curBytePos=" + this.curBytePos + ":curCharPos=" + this.curCharPos + ":dataOffset=" + this.dataOffset + ":stream=" + this.stream.getClass();
    }

    public static class Builder {
        private static final long DEFAULT_MAX_CHAR_LENGTH = Long.MAX_VALUE;
        private boolean bufferable = false;
        private boolean positionAware = false;
        private long curBytePos = 0L;
        private long curCharPos = 1L;
        private long byteLength = 0L;
        private long charLength = 0L;
        private long dataOffset = 0L;
        private long maxCharLength = Long.MAX_VALUE;
        private InputStream stream;

        public Builder bufferable(boolean bufferable) {
            this.bufferable = bufferable;
            return this;
        }

        public Builder positionAware(boolean positionAware) {
            this.positionAware = positionAware;
            return this;
        }

        public Builder curBytePos(long pos) {
            this.curBytePos = pos;
            return this;
        }

        public Builder curCharPos(long pos) {
            this.curCharPos = pos;
            return this;
        }

        public Builder byteLength(long length) {
            this.byteLength = length;
            return this;
        }

        public Builder copyState(CharacterStreamDescriptor csd) {
            this.bufferable = csd.bufferable;
            this.byteLength = csd.byteLength;
            this.charLength = csd.charLength;
            this.curBytePos = csd.curBytePos;
            this.curCharPos = csd.curCharPos;
            this.dataOffset = csd.dataOffset;
            this.maxCharLength = csd.maxCharLength;
            this.positionAware = csd.positionAware;
            this.stream = csd.stream;
            return this;
        }

        public Builder charLength(long length) {
            this.charLength = length;
            return this;
        }

        public Builder dataOffset(long offset) {
            this.dataOffset = offset;
            return this;
        }

        public Builder maxCharLength(long length) {
            this.maxCharLength = length;
            return this;
        }

        public Builder stream(InputStream stream) {
            SanityManager.ASSERT((stream != null ? 1 : 0) != 0);
            this.stream = stream;
            return this;
        }

        public CharacterStreamDescriptor build() {
            SanityManager.ASSERT((this.curBytePos >= 0L ? 1 : 0) != 0, (String)"Negative curBytePos");
            SanityManager.ASSERT((this.curCharPos >= 1L || this.curCharPos == 0L ? 1 : 0) != 0, (String)("Invalid curCharPos (BEFORE_FIRST=0), " + this.toString()));
            SanityManager.ASSERT((this.byteLength >= 0L ? 1 : 0) != 0, (String)"Negative byteLength");
            SanityManager.ASSERT((this.charLength >= 0L ? 1 : 0) != 0, (String)"Negative charLength");
            SanityManager.ASSERT((this.dataOffset >= 0L ? 1 : 0) != 0, (String)"Negative dataOffset");
            SanityManager.ASSERT((this.maxCharLength >= 0L ? 1 : 0) != 0, (String)"Negative max length");
            if (this.curBytePos != 0L && this.curCharPos == 0L || this.curBytePos == 0L && this.curCharPos > 1L) {
                SanityManager.THROWASSERT((String)("Invalid byte/char pos: " + this.curBytePos + "/" + this.curCharPos));
            }
            SanityManager.ASSERT((this.curBytePos >= this.curCharPos - 1L ? 1 : 0) != 0);
            if (this.curBytePos < this.dataOffset) {
                SanityManager.ASSERT((this.curCharPos == 0L ? 1 : 0) != 0, (String)("curCharPos in header, " + this.toString()));
            }
            if (this.byteLength > 0L && this.charLength > 0L) {
                SanityManager.ASSERT((this.byteLength - this.dataOffset >= this.charLength ? 1 : 0) != 0, (String)("Less than one byte per char, " + this.toString()));
            }
            SanityManager.ASSERT((this.stream != null ? 1 : 0) != 0, (String)"Stream cannot be null");
            if (this.positionAware) {
                SanityManager.ASSERT((boolean)(this.stream instanceof PositionedStream), (String)("Stream not a positioned stream, " + this.toString()));
            }
            return new CharacterStreamDescriptor(this);
        }

        public String toString() {
            String str = "CharacterStreamBuiler@" + this.hashCode() + ":bufferable=" + this.bufferable + ", isPositionAware=" + this.positionAware + ", curBytePos=" + this.curBytePos + ", curCharPos=" + this.curCharPos + ", dataOffset=" + this.dataOffset + ", byteLength=" + this.byteLength + ", charLength=" + this.charLength + ", maxCharLength=" + this.maxCharLength + ", stream=" + this.stream.getClass();
            return str;
        }
    }
}

