/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceOrHostAddressConstKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DEVICEADDRESS;
    public static final int HOSTADDRESS;

    public VkDeviceOrHostAddressConstKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDeviceOrHostAddressConstKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceAddress")
    public long deviceAddress() {
        return VkDeviceOrHostAddressConstKHR.ndeviceAddress(this.address());
    }

    @NativeType(value="void const *")
    public long hostAddress() {
        return VkDeviceOrHostAddressConstKHR.nhostAddress(this.address());
    }

    public VkDeviceOrHostAddressConstKHR deviceAddress(@NativeType(value="VkDeviceAddress") long value) {
        VkDeviceOrHostAddressConstKHR.ndeviceAddress(this.address(), value);
        return this;
    }

    public VkDeviceOrHostAddressConstKHR hostAddress(@NativeType(value="void const *") long value) {
        VkDeviceOrHostAddressConstKHR.nhostAddress(this.address(), value);
        return this;
    }

    public VkDeviceOrHostAddressConstKHR set(VkDeviceOrHostAddressConstKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDeviceOrHostAddressConstKHR malloc() {
        return (VkDeviceOrHostAddressConstKHR)VkDeviceOrHostAddressConstKHR.wrap(VkDeviceOrHostAddressConstKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkDeviceOrHostAddressConstKHR calloc() {
        return (VkDeviceOrHostAddressConstKHR)VkDeviceOrHostAddressConstKHR.wrap(VkDeviceOrHostAddressConstKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkDeviceOrHostAddressConstKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkDeviceOrHostAddressConstKHR)VkDeviceOrHostAddressConstKHR.wrap(VkDeviceOrHostAddressConstKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkDeviceOrHostAddressConstKHR create(long address) {
        return (VkDeviceOrHostAddressConstKHR)VkDeviceOrHostAddressConstKHR.wrap(VkDeviceOrHostAddressConstKHR.class, (long)address);
    }

    @Nullable
    public static VkDeviceOrHostAddressConstKHR createSafe(long address) {
        return address == 0L ? null : (VkDeviceOrHostAddressConstKHR)VkDeviceOrHostAddressConstKHR.wrap(VkDeviceOrHostAddressConstKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkDeviceOrHostAddressConstKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkDeviceOrHostAddressConstKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkDeviceOrHostAddressConstKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceOrHostAddressConstKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkDeviceOrHostAddressConstKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkDeviceOrHostAddressConstKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkDeviceOrHostAddressConstKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkDeviceOrHostAddressConstKHR malloc(MemoryStack stack) {
        return (VkDeviceOrHostAddressConstKHR)VkDeviceOrHostAddressConstKHR.wrap(VkDeviceOrHostAddressConstKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceOrHostAddressConstKHR calloc(MemoryStack stack) {
        return (VkDeviceOrHostAddressConstKHR)VkDeviceOrHostAddressConstKHR.wrap(VkDeviceOrHostAddressConstKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkDeviceOrHostAddressConstKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkDeviceOrHostAddressConstKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long ndeviceAddress(long struct) {
        return UNSAFE.getLong(null, struct + (long)DEVICEADDRESS);
    }

    public static long nhostAddress(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)HOSTADDRESS));
    }

    public static void ndeviceAddress(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DEVICEADDRESS, value);
    }

    public static void nhostAddress(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)HOSTADDRESS), (long)value);
    }

    static {
        Struct.Layout layout = VkDeviceOrHostAddressConstKHR.__union((Struct.Member[])new Struct.Member[]{VkDeviceOrHostAddressConstKHR.__member((int)8), VkDeviceOrHostAddressConstKHR.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DEVICEADDRESS = layout.offsetof(0);
        HOSTADDRESS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceOrHostAddressConstKHR, Buffer>
    implements NativeResource {
        private static final VkDeviceOrHostAddressConstKHR ELEMENT_FACTORY = VkDeviceOrHostAddressConstKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDeviceOrHostAddressConstKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceAddress")
        public long deviceAddress() {
            return VkDeviceOrHostAddressConstKHR.ndeviceAddress(this.address());
        }

        @NativeType(value="void const *")
        public long hostAddress() {
            return VkDeviceOrHostAddressConstKHR.nhostAddress(this.address());
        }

        public Buffer deviceAddress(@NativeType(value="VkDeviceAddress") long value) {
            VkDeviceOrHostAddressConstKHR.ndeviceAddress(this.address(), value);
            return this;
        }

        public Buffer hostAddress(@NativeType(value="void const *") long value) {
            VkDeviceOrHostAddressConstKHR.nhostAddress(this.address(), value);
            return this;
        }
    }
}

