/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.cache.lru;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.cache.lru.LRUMediaCacheEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class InputStreamCacheWrapper
extends InputStream {
    private final Logger logger = LoggerFactory.getLogger(InputStreamCacheWrapper.class);
    private LRUMediaCacheEntry<?> cacheEntry;
    private int offset = 0;
    private int markedOffset = 0;

    public InputStreamCacheWrapper(LRUMediaCacheEntry<?> cacheEntry) {
        this.cacheEntry = cacheEntry;
    }

    @Override
    public int available() throws IOException {
        return this.cacheEntry.availableFrom(this.offset);
    }

    @Override
    public int read() throws IOException {
        byte[] bytesRead = this.cacheEntry.read(this.offset, 1);
        if (bytesRead.length == 0) {
            return -1;
        }
        ++this.offset;
        return bytesRead[0] & 0xFF;
    }

    @Override
    public int read(byte @Nullable [] b, int off, int len) throws IOException {
        if (b == null) {
            throw new IOException("Array to write is null");
        }
        Objects.checkFromIndexSize(off, len, b.length);
        if (len == 0) {
            return 0;
        }
        byte[] bytesRead = this.cacheEntry.read(this.offset, len);
        this.offset += bytesRead.length;
        if (bytesRead.length == 0) {
            return -1;
        }
        int i = 0;
        while (i < len && i < bytesRead.length) {
            b[off + i] = bytesRead[i];
            ++i;
        }
        return i;
    }

    @Override
    public long skip(long n) throws IOException {
        this.offset = (int)((long)this.offset + n);
        return n;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.cacheEntry.closeStreamClient();
        }
    }

    public long length() {
        Long totalSize = this.cacheEntry.getTotalSize();
        if (totalSize > 0L) {
            return totalSize;
        }
        this.logger.debug("Cannot get the length of the stream");
        return -1L;
    }

    public InputStream getClonedStream() throws IOException {
        return this.cacheEntry.getInputStream();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.markedOffset = this.offset;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.offset = this.markedOffset;
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

