"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TEXT2VIZ_API = exports.NOTEBOOK_PREFIX = exports.NOTEBOOK_API = exports.DSL_SEARCH = exports.DSL_BASE = exports.DEFAULT_USER_NAME = exports.ASSISTANT_API = exports.API_BASE = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const API_BASE = exports.API_BASE = '/api/assistant';
const DSL_BASE = exports.DSL_BASE = '/api/dsl';
const DSL_SEARCH = exports.DSL_SEARCH = '/search';
const NOTEBOOK_PREFIX = exports.NOTEBOOK_PREFIX = '/api/observability/notebooks';
const ASSISTANT_API = exports.ASSISTANT_API = {
  SEND_MESSAGE: `${API_BASE}/send_message`,
  CONVERSATION: `${API_BASE}/conversation`,
  CONVERSATIONS: `${API_BASE}/conversations`,
  FEEDBACK: `${API_BASE}/feedback`,
  ABORT_AGENT_EXECUTION: `${API_BASE}/abort`,
  REGENERATE: `${API_BASE}/regenerate`,
  TRACE: `${API_BASE}/trace`,
  ACCOUNT: `${API_BASE}/account`
};
const TEXT2VIZ_API = exports.TEXT2VIZ_API = {
  TEXT2PPL: `${API_BASE}/text2ppl`,
  TEXT2VEGA: `${API_BASE}/text2vega`
};
const NOTEBOOK_API = exports.NOTEBOOK_API = {
  CREATE_NOTEBOOK: `${NOTEBOOK_PREFIX}/note`,
  SET_PARAGRAPH: `${NOTEBOOK_PREFIX}/set_paragraphs/`
};
const DEFAULT_USER_NAME = exports.DEFAULT_USER_NAME = 'User';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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