"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SQL_TRANSLATE_ROUTE = exports.SQL_QUERY_ROUTE = exports.SPARK_SQL_QUERY_ROUTE = exports.PPL_TRANSLATE_ROUTE = exports.PPL_QUERY_ROUTE = exports.FORMAT_TEXT = exports.FORMAT_JSON = exports.FORMAT_CSV = exports.DEFAULT_HEADERS = exports.DATASOURCES_GET_QUERY = exports.CLUSTER = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const SQL_TRANSLATE_ROUTE = exports.SQL_TRANSLATE_ROUTE = `/_plugins/_sql/_explain`;
const PPL_TRANSLATE_ROUTE = exports.PPL_TRANSLATE_ROUTE = `/_plugins/_ppl/_explain`;
const SQL_QUERY_ROUTE = exports.SQL_QUERY_ROUTE = `/_plugins/_sql`;
const PPL_QUERY_ROUTE = exports.PPL_QUERY_ROUTE = `/_plugins/_ppl`;
const FORMAT_CSV = exports.FORMAT_CSV = `format=csv`;
const FORMAT_JSON = exports.FORMAT_JSON = `format=json`;
const FORMAT_TEXT = exports.FORMAT_TEXT = `format=raw`;
const SPARK_SQL_QUERY_ROUTE = exports.SPARK_SQL_QUERY_ROUTE = `/_plugins/_async_query`;
const DATASOURCES_GET_QUERY = exports.DATASOURCES_GET_QUERY = `/_plugins/_query/_datasources`;
const DEFAULT_HEADERS = exports.DEFAULT_HEADERS = {
  'Content-Type': 'application/json',
  Accept: 'application/json',
  'User-Agent': 'OpenSearch-Dashboards'
};
const CLUSTER = exports.CLUSTER = {
  ADMIN: 'admin',
  SQL: 'opensearch-sql',
  DATA: 'data'
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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