"use strict";

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

module.exports = {
  rootDir: '../',
  setupFiles: ['<rootDir>/test/polyfills.ts', '<rootDir>/test/setupTests.ts'],
  setupFilesAfterEnv: ['<rootDir>/test/setup.jest.ts'],
  roots: ['<rootDir>'],
  coverageDirectory: './coverage',
  moduleNameMapper: {
    '\\.(css|less|scss)$': '<rootDir>/test/mocks/styleMock.ts',
    '^ui/(.*)': '<rootDir>/../../src/legacy/ui/public/$1/'
  },
  coverageReporters: ['lcov', 'text', 'cobertura'],
  testMatch: ['**/*.test.js', '**/*.test.jsx', '**/*.test.ts', '**/*.test.tsx'],
  collectCoverageFrom: ['**/*.ts', '**/*.tsx', '**/*.js', '**/*.jsx', '!**/models/**', '!**/node_modules/**', '!**/index.ts', '!<rootDir>/index.js', '!<rootDir>/public/app.js', '!<rootDir>/public/temporary/**', '!<rootDir>/babel.config.js', '!<rootDir>/test/**', '!<rootDir>/server/**', '!<rootDir>/coverage/**', '!<rootDir>/scripts/**', '!<rootDir>/build/**', '!<rootDir>/cypress/**', '!**/vendor/**'],
  clearMocks: true,
  testPathIgnorePatterns: ['<rootDir>/build/', '<rootDir>/node_modules/'],
  modulePathIgnorePatterns: ['securityAnalyticsDashboards'],
  testEnvironment: 'jsdom',
  snapshotSerializers: ['enzyme-to-json/serializer']
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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