"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDataSourceConnectionsRoutes = registerDataSourceConnectionsRoutes;
var _configSchema = require("@osd/config-schema");
var _common = require("../../../common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function registerDataSourceConnectionsRoutes(router, defaultClient) {
  router.get({
    path: _common.API.DATA_SOURCE.CONNECTIONS,
    validate: {
      params: _configSchema.schema.object({}, {
        unknowns: 'allow'
      })
    }
  }, async (context, request, response) => {
    const fields = ['id', 'title', 'auth.type'];
    const resp = await context.core.savedObjects.client.find({
      type: 'data-source',
      fields,
      perPage: 10000
    });
    return response.ok({
      body: {
        savedObjects: resp.saved_objects
      }
    });
  });
  router.get({
    path: `${_common.API.DATA_SOURCE.CONNECTIONS}/{dataSourceId}`,
    validate: {
      params: _configSchema.schema.object({
        dataSourceId: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    const resp = await context.core.savedObjects.client.get('data-source', request.params.dataSourceId);
    return response.ok({
      body: resp
    });
  });
  router.get({
    path: `${_common.API.DATA_SOURCE.EXTERNAL}`,
    validate: {
      query: _configSchema.schema.object({
        id: _configSchema.schema.string(),
        name: _configSchema.schema.nullable(_configSchema.schema.string())
      })
    }
  }, async (context, request, response) => {
    const client = request.query.id ? context.dataSource.opensearch.legacy.getClient(request.query.id).callAPI : defaultClient.asScoped(request).callAsCurrentUser;
    const resp = request.query.name ? await client('enhancements.getDataConnectionById', {
      dataconnection: request.query.name
    }) : await client('enhancements.getDataConnections');
    return response.ok({
      body: resp
    });
  });
  router.get({
    path: `${_common.API.DATA_SOURCE.ASYNC_JOBS}`,
    validate: {
      query: _configSchema.schema.object({
        id: _configSchema.schema.string(),
        queryId: _configSchema.schema.nullable(_configSchema.schema.string())
      })
    }
  }, async (context, request, response) => {
    const client = request.query.id ? context.dataSource.opensearch.legacy.getClient(request.query.id).callAPI : defaultClient.asScoped(request).callAsCurrentUser;
    const resp = await client('enhancements.getJobStatus', {
      queryId: request.query.queryId
    });
    return response.ok({
      body: resp
    });
  });
  router.post({
    path: `${_common.API.DATA_SOURCE.ASYNC_JOBS}`,
    validate: {
      query: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.object({
        query: _configSchema.schema.string(),
        datasource: _configSchema.schema.string(),
        lang: _configSchema.schema.string(),
        sessionId: _configSchema.schema.nullable(_configSchema.schema.string())
      })
    }
  }, async (context, request, response) => {
    const client = request.query.id ? context.dataSource.opensearch.legacy.getClient(request.query.id).callAPI : defaultClient.asScoped(request).callAsCurrentUser;
    const resp = await client('enhancements.runDirectQuery', {
      body: request.body
    });
    return response.ok({
      body: resp
    });
  });
}