/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;

public class PhaseRecorder {
    private String lastLifecyclePhase;
    private final MavenProject project;

    public PhaseRecorder(MavenProject project2) {
        this.project = project2;
    }

    public void observeExecution(MojoExecution mojoExecution) {
        String lifecyclePhase = mojoExecution.getLifecyclePhase();
        if (lifecyclePhase != null) {
            if (this.lastLifecyclePhase == null) {
                this.lastLifecyclePhase = lifecyclePhase;
            } else if (!lifecyclePhase.equals(this.lastLifecyclePhase)) {
                this.project.addLifecyclePhase(this.lastLifecyclePhase);
                this.lastLifecyclePhase = lifecyclePhase;
            }
        }
        if (this.lastLifecyclePhase != null) {
            this.project.addLifecyclePhase(this.lastLifecyclePhase);
        }
    }

    public boolean isDifferentPhase(MojoExecution nextMojoExecution) {
        String lifecyclePhase = nextMojoExecution.getLifecyclePhase();
        if (lifecyclePhase == null) {
            return this.lastLifecyclePhase != null;
        }
        return !lifecyclePhase.equals(this.lastLifecyclePhase);
    }
}

