/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.action;

import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.action.Action;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandler;
import org.apache.ws.security.message.WSSecSignature;
import org.w3c.dom.Document;

public class SignatureAction
implements Action {
    public void execute(WSHandler handler, int actionToDo, Document doc, RequestData reqData) throws WSSecurityException {
        String password = handler.getPassword(reqData.getUsername(), actionToDo, "passwordCallbackClass", "passwordCallbackRef", reqData).getPassword();
        WSSecSignature wsSign = new WSSecSignature();
        wsSign.setWsConfig(reqData.getWssConfig());
        if (reqData.getSigKeyId() != 0) {
            wsSign.setKeyIdentifierType(reqData.getSigKeyId());
        }
        if (reqData.getSigAlgorithm() != null) {
            wsSign.setSignatureAlgorithm(reqData.getSigAlgorithm());
        }
        wsSign.setUserInfo(reqData.getUsername(), password);
        if (reqData.getSignatureParts().size() > 0) {
            wsSign.setParts(reqData.getSignatureParts());
        }
        try {
            wsSign.build(doc, reqData.getSigCrypto(), reqData.getSecHeader());
            reqData.getSignatureValues().add(wsSign.getSignatureValue());
        }
        catch (WSSecurityException e) {
            throw new WSSecurityException("WSHandler: Signature: error during message processing" + e);
        }
    }
}

