/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.update;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.URI;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.crypto.TrustedUpdate;
import net.i2p.router.RouterContext;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.update.UpdateRunner;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.update.UpdateMethod;
import net.i2p.update.UpdateType;
import net.i2p.util.PartialEepGet;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;

class DevSU3UpdateChecker
extends UpdateRunner {
    public DevSU3UpdateChecker(RouterContext ctx, ConsoleUpdateManager mgr, List<URI> uris) {
        super(ctx, mgr, UpdateType.ROUTER_DEV_SU3, uris, "2.6.1-0");
        if (!uris.isEmpty()) {
            this._currentURI = uris.get(0);
        }
    }

    @Override
    protected void update() {
        this._isPartial = true;
        String proxyHost = this._context.getProperty("router.updateProxyHost", "127.0.0.1");
        int proxyPort = ConfigUpdateHandler.proxyPort(this._context);
        if (proxyPort == 4444 && proxyHost.equals("127.0.0.1") && this._context.portMapper().getPort("HTTP") < 0) {
            String msg = this._t("HTTP client proxy tunnel must be running");
            if (this._log.shouldWarn()) {
                this._log.warn(msg);
            }
            this.updateStatus("<b>" + msg + "</b>");
            this._mgr.notifyCheckComplete(this, false, false);
            return;
        }
        this._baos.reset();
        try {
            this._get = new PartialEepGet((I2PAppContext)this._context, proxyHost, proxyPort, this._baos, this._currentURI.toString(), TrustedUpdate.HEADER_BYTES);
            this._get.addStatusListener(this);
            this._get.fetch(55000L);
        }
        catch (Throwable t) {
            this._log.error("Error fetching the update", t);
        }
    }

    @Override
    public void bytesTransferred(long alreadyTransferred, int currentWrite, long bytesTransferred, long bytesRemaining, String url) {
    }

    @Override
    public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
        boolean newer;
        String newVersion = TrustedUpdate.getVersionString(new ByteArrayInputStream(this._baos.toByteArray()));
        boolean bl = newer = VersionComparator.comp(newVersion, "2.6.1-0") > 0;
        if (newer) {
            if (SystemVersion.isJava7()) {
                this._mgr.notifyVersionAvailable(this, this._currentURI, UpdateType.ROUTER_DEV_SU3, "", UpdateMethod.HTTP, this._urls, newVersion, "2.6.1-0");
            } else {
                String ourJava = System.getProperty("java.version");
                String msg = this._mgr._t("Requires Java version {0} but installed Java version is {1}", "1.7", ourJava);
                this._log.logAlways(30, "Cannot update to version " + newVersion + ": " + msg);
                this._mgr.notifyVersionConstraint(this, this._currentURI, UpdateType.ROUTER_DEV_SU3, "", newVersion, msg);
            }
        } else if (this._log.shouldWarn()) {
            this._log.warn("Found old version \"" + newVersion + "\" at " + url);
        }
        this._mgr.notifyCheckComplete(this, newer, true);
    }

    @Override
    public void transferFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt) {
        File f = new File(this._updateFile);
        f.delete();
        this._mgr.notifyCheckComplete(this, false, false);
    }
}

