/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.socks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.i2ptunnel.socks.SOCKS4aServer;
import net.i2p.i2ptunnel.socks.SOCKS5Server;
import net.i2p.i2ptunnel.socks.SOCKSServer;
import net.i2p.socks.SOCKSException;

class SOCKSServerFactory {
    private static final String ERR_REQUEST_DENIED = "HTTP/1.1 403 Access Denied - This is a SOCKS proxy, not a HTTP proxy\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\n\r\n<html><body><H1>I2P SOCKS PROXY ERROR: REQUEST DENIED</H1>Your browser is misconfigured. This is a SOCKS proxy, not a HTTP proxy</body></html>";

    SOCKSServerFactory() {
    }

    public static SOCKSServer createSOCKSServer(I2PAppContext ctx, Socket s, Properties props) throws SOCKSException {
        SOCKSServer serv;
        try {
            DataInputStream in = new DataInputStream(s.getInputStream());
            byte socksVer = in.readByte();
            switch (socksVer) {
                case 4: {
                    if (Boolean.parseBoolean(props.getProperty("proxyAuth")) && props.containsKey("proxyUsername") && props.containsKey("proxyPassword")) {
                        throw new SOCKSException("SOCKS 4/4a not supported when authorization is required");
                    }
                    serv = new SOCKS4aServer(ctx, s, props);
                    break;
                }
                case 5: {
                    serv = new SOCKS5Server(ctx, s, props);
                    break;
                }
                case 67: 
                case 71: 
                case 72: 
                case 80: {
                    DataOutputStream out = new DataOutputStream(s.getOutputStream());
                    out.write(DataHelper.getASCII(ERR_REQUEST_DENIED));
                    throw new SOCKSException("HTTP request to socks");
                }
                default: {
                    throw new SOCKSException("SOCKS protocol version not supported (" + Integer.toHexString(socksVer) + ")");
                }
            }
        }
        catch (IOException e) {
            throw new SOCKSException("Connection error", e);
        }
        return serv;
    }
}

