/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli.commands;

import com.fasterxml.jackson.core.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.keycloak.client.cli.common.AttributeOperation;
import org.keycloak.client.cli.config.ConfigData;
import org.keycloak.client.cli.util.ConfigUtil;
import org.keycloak.client.cli.util.HttpUtil;
import org.keycloak.client.cli.util.IoUtil;
import org.keycloak.client.cli.util.OsUtil;
import org.keycloak.client.cli.util.ParseUtil;
import org.keycloak.client.registration.cli.CmdStdinContext;
import org.keycloak.client.registration.cli.EndpointType;
import org.keycloak.client.registration.cli.EndpointTypeConverter;
import org.keycloak.client.registration.cli.KcRegMain;
import org.keycloak.client.registration.cli.ReflectionUtil;
import org.keycloak.client.registration.cli.commands.AbstractAuthOptionsCmd;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.util.JsonSerialization;
import picocli.CommandLine;

@CommandLine.Command(name="update", description={"CLIENT_ID [ARGUMENTS]"})
public class UpdateCmd
extends AbstractAuthOptionsCmd {
    @CommandLine.Option(names={"-e", "--endpoint"}, description={"Endpoint type to use - one of: 'default', 'oidc'"}, converter={EndpointTypeConverter.class})
    private EndpointType regType = null;
    @CommandLine.Option(names={"-f", "--file"}, description={"Use the file or standard input if '-' is specified"})
    private String file = null;
    @CommandLine.Option(names={"-m", "--merge"}, description={"Merge new values with existing configuration on the server"})
    private boolean mergeMode = false;
    @CommandLine.Option(names={"-o", "--output"}, description={"After update output the new client configuration"})
    private boolean outputClient = false;
    @CommandLine.Option(names={"-c", "--compressed"}, description={"Don't pretty print the output"})
    private boolean compressed = false;
    @CommandLine.Parameters(arity="0..1")
    String clientId;
    @CommandLine.ArgGroup(exclusive=true, multiplicity="0..*")
    List<AttributeOperations> rawAttributeOperations = new ArrayList<AttributeOperations>();
    List<AttributeOperation> attrs = new LinkedList<AttributeOperation>();

    @Override
    protected void processOptions() {
        super.processOptions();
        for (AttributeOperations entry : this.rawAttributeOperations) {
            if (entry.delete != null) {
                this.attrs.add(new AttributeOperation(AttributeOperation.Type.DELETE, entry.delete));
                continue;
            }
            String[] keyVal = ParseUtil.parseKeyVal(entry.set);
            this.attrs.add(new AttributeOperation(AttributeOperation.Type.SET, keyVal[0], keyVal[1]));
        }
    }

    @Override
    protected void process() {
        InputStream response;
        if (this.clientId == null) {
            throw new IllegalArgumentException("CLIENT_ID not specified");
        }
        if (this.clientId.startsWith("-")) {
            IoUtil.warnfErr("You're using what looks like an OPTION as CLIENT: %s", this.clientId);
        }
        if (this.file == null && this.attrs.size() == 0) {
            throw new IllegalArgumentException("No file nor attribute values specified");
        }
        if (this.file == null && this.attrs.size() > 0) {
            this.mergeMode = true;
        }
        CmdStdinContext ctx = new CmdStdinContext();
        if (this.file != null) {
            ctx = CmdStdinContext.parseFileOrStdin(this.file, this.regType);
            this.regType = ctx.getEndpointType();
        }
        if (this.regType == null) {
            this.regType = EndpointType.DEFAULT;
            ctx.setEndpointType(this.regType);
        } else if (this.regType != EndpointType.DEFAULT && this.regType != EndpointType.OIDC) {
            throw new RuntimeException("Update not supported for endpoint type: " + this.regType.getEndpoint());
        }
        ConfigData config = ConfigUtil.loadConfig();
        config = this.copyWithServerInfo(config);
        String server = config.getServerUrl();
        String realm = config.getRealm();
        if (this.externalToken == null) {
            boolean processed = false;
            for (AttributeOperation op : this.attrs) {
                if (!"registrationAccessToken".equals(op.getKey().toString())) continue;
                processed = true;
                if (op.getType() != AttributeOperation.Type.SET) break;
                this.externalToken = op.getValue();
                break;
            }
            if (!processed) {
                this.externalToken = ctx.getRegistrationAccessToken();
            }
        }
        if (this.externalToken == null) {
            this.externalToken = ConfigUtil.getRegistrationToken(config.sessionRealmConfigData(), this.clientId);
        }
        this.setupTruststore(config);
        String auth = this.externalToken;
        if (auth == null) {
            config = this.ensureAuthInfo(config);
            if (ConfigUtil.credentialsAvailable(config = this.copyWithServerInfo(config))) {
                auth = this.ensureToken(config);
            }
        }
        String string = auth = auth != null ? "Bearer " + auth : null;
        if (this.mergeMode) {
            response = HttpUtil.doGet(server + "/realms/" + realm + "/clients-registrations/" + this.regType.getEndpoint() + "/" + HttpUtil.urlencode(this.clientId), "application/json", auth);
            String json = IoUtil.readFully(response);
            CmdStdinContext ctxremote = new CmdStdinContext();
            ctxremote.setContent(json);
            ctxremote.setEndpointType(this.regType);
            try {
                if (this.regType == EndpointType.DEFAULT) {
                    ctxremote.setClient(JsonSerialization.readValue(json, ClientRepresentation.class));
                    this.externalToken = ctxremote.getClient().getRegistrationAccessToken();
                } else if (this.regType == EndpointType.OIDC) {
                    ctxremote.setOidcClient(JsonSerialization.readValue(json, OIDCClientRepresentation.class));
                    this.externalToken = ctxremote.getOidcClient().getRegistrationAccessToken();
                }
            }
            catch (JsonParseException e) {
                throw new RuntimeException("Not a valid JSON document. " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new RuntimeException("Not a valid JSON document", e);
            }
            if (this.externalToken != null) {
                auth = "Bearer " + this.externalToken;
                String newToken = this.externalToken;
                String clientToUpdate = this.clientId;
                ConfigUtil.saveMergeConfig(cfg -> ConfigUtil.setRegistrationToken(cfg.ensureRealmConfigData(server, realm), clientToUpdate, newToken));
            }
            if (ctx.getClient() != null) {
                ReflectionUtil.merge(ctx.getClient(), ctxremote.getClient());
            } else if (ctx.getOidcClient() != null) {
                ReflectionUtil.merge(ctx.getOidcClient(), ctxremote.getOidcClient());
            }
            ctx = ctxremote;
        }
        if (this.attrs.size() > 0) {
            ctx = CmdStdinContext.mergeAttributes(ctx, this.attrs);
        }
        response = HttpUtil.doPut(server + "/realms/" + realm + "/clients-registrations/" + this.regType.getEndpoint() + "/" + HttpUtil.urlencode(this.clientId), "application/json", "application/json", ctx.getContent(), auth);
        try {
            Object clirep;
            if (this.regType == EndpointType.DEFAULT) {
                clirep = JsonSerialization.readValue(response, ClientRepresentation.class);
                this.outputResult(clirep);
                this.externalToken = ((ClientRepresentation)clirep).getRegistrationAccessToken();
            } else if (this.regType == EndpointType.OIDC) {
                clirep = JsonSerialization.readValue(response, OIDCClientRepresentation.class);
                this.outputResult(clirep);
                this.externalToken = ((OIDCClientRepresentation)clirep).getRegistrationAccessToken();
            }
            String newToken = this.externalToken;
            String clientToUpdate = this.clientId;
            ConfigUtil.saveMergeConfig(cfg -> ConfigUtil.setRegistrationToken(cfg.ensureRealmConfigData(server, realm), clientToUpdate, newToken));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to process HTTP response", e);
        }
    }

    private void outputResult(Object result) throws IOException {
        if (this.outputClient) {
            if (this.compressed) {
                IoUtil.printOut(JsonSerialization.writeValueAsString(result));
            } else {
                IoUtil.printOut(JsonSerialization.writeValueAsPrettyString(result));
            }
        }
    }

    @Override
    protected boolean nothingToDo() {
        return super.nothingToDo() && this.regType == null && this.file == null && this.rawAttributeOperations.isEmpty() && this.clientId == null;
    }

    @Override
    protected String help() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Usage: " + KcRegMain.CMD + " update CLIENT [ARGUMENTS]");
        out.println();
        out.println("Command to update an existing client configuration. If registration access token is specified it is used.");
        out.println("Otherwise, if 'registrationAccessToken' attribute is set, that is used. Otherwise, if registration access");
        out.println("token is available in configuration file, we use that. Finally, if it's not available anywhere, the current ");
        out.println("active session is used.");
        this.globalOptions(out);
        out.println("  Command specific options:");
        out.println("    CLIENT                ClientId of the client to update");
        out.println("    -t, --token TOKEN     Use the specified Registration Access Token for authorization");
        out.println("    -s, --set KEY=VALUE   Set specific attribute to a specified value");
        out.println("              KEY+=VALUE  Add item to an array");
        out.println("    -d, --delete NAME     Delete the specific attribute, or array item");
        out.println("    -e, --endpoint TYPE   Endpoint type to use - one of: 'default', 'oidc'");
        out.println("    -f, --file FILENAME   Use the file or standard input if '-' is specified");
        out.println("    -m, --merge           Merge new values with existing configuration on the server");
        out.println("                          Merge is automatically enabled unless --file is specified");
        out.println("    -o, --output          After update output the new client configuration");
        out.println("    -c, --compressed      Don't pretty print the output");
        out.println();
        out.println();
        out.println("Nested attributes are supported by using '.' to separate components of a KEY. Optionally, the KEY components ");
        out.println("can be quoted with double quotes - e.g. my_client.attributes.\"external.user.id\". If VALUE starts with [ and ");
        out.println("ends with ] the attribute will be set as a JSON array. If VALUE starts with { and ends with } the attribute ");
        out.println("will be set as a JSON object. If KEY ends with an array index - e.g. clients[3]=VALUE - then the specified item");
        out.println("of the array is updated. If KEY+=VALUE syntax is used, then KEY is assumed to be an array, and another item is");
        out.println("added to it.");
        out.println();
        out.println("Attributes can also be deleted. If KEY ends with an array index, then the targeted item of an array is removed");
        out.println("and the following items are shifted.");
        out.println();
        out.println("Merged mode fetches current configuration from the server, applies attribute changes to it, and sends it");
        out.println("back to the server, overwriting existing configuration there. If available, Registration Access Token is used ");
        out.println("for authorization when doing changes. Otherwise current session's authorization is used in which case user needs");
        out.println("manage-clients permission for update to work.");
        out.println();
        out.println();
        out.println("Examples:");
        out.println();
        out.println("Update a client by fetching current configuration from server, and applying specified changes.");
        out.println("  " + OsUtil.PROMPT + " " + KcRegMain.CMD + " update my_client -s enabled=true -s 'redirectUris=[\"http://localhost:8080/myapp/*\"]'");
        out.println();
        out.println("Update a client by overwriting existing configuration on the server with a new one:");
        out.println("  " + OsUtil.PROMPT + " " + KcRegMain.CMD + " update my_client -f new_my_client.json");
        out.println();
        out.println("Update a client by overwriting existing configuration using local file as a template:");
        out.println("  " + OsUtil.PROMPT + " " + KcRegMain.CMD + " update my_client -f new_my_client.json -s enabled=true");
        out.println();
        out.println("Update client by fetching current configuration from server and merging with specified changes:");
        out.println("  " + OsUtil.PROMPT + " " + KcRegMain.CMD + " update my_client -f new_my_client.json -s enabled=true --merge");
        out.println();
        out.println("Update a client using 'oidc' endpoint:");
        out.println("  " + OsUtil.PROMPT + " " + KcRegMain.CMD + " update my_client -e oidc -s 'redirect_uris=[\"http://localhost:8080/myapp/*\"]'");
        out.println();
        out.println();
        out.println("Use '" + KcRegMain.CMD + " help' for general information and a list of commands");
        return sb.toString();
    }

    static class AttributeOperations {
        @CommandLine.Option(names={"-s", "--set"}, required=true)
        String set;
        @CommandLine.Option(names={"-d", "--delete"}, required=true)
        String delete;

        AttributeOperations() {
        }
    }
}

