/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oid4vc.model.OID4VCClient;
import org.keycloak.protocol.oid4vc.model.SupportedCredentialConfiguration;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.clientregistration.AbstractClientRegistrationProvider;
import org.keycloak.services.clientregistration.DefaultClientRegistrationContext;

public class OID4VCClientRegistrationProvider
extends AbstractClientRegistrationProvider {
    private static final Logger LOGGER = Logger.getLogger(OID4VCClientRegistrationProvider.class);
    private static final String VC_KEY = "vc";

    public OID4VCClientRegistrationProvider(KeycloakSession session) {
        super(session);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createOID4VCClient(OID4VCClient client) {
        ClientRepresentation clientRepresentation = OID4VCClientRegistrationProvider.toClientRepresentation(client);
        OID4VCClientRegistrationProvider.validate(clientRepresentation);
        ClientRepresentation cr = this.create(new DefaultClientRegistrationContext(this.session, clientRepresentation, this));
        URI uri = this.session.getContext().getUri().getAbsolutePathBuilder().path(cr.getClientId()).build(new Object[0]);
        return Response.created((URI)uri).entity((Object)cr).build();
    }

    @PUT
    @Path(value="{clientId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateOID4VCClient(@PathParam(value="clientId") String clientDid, OID4VCClient client) {
        client.setClientDid(clientDid);
        ClientRepresentation clientRepresentation = OID4VCClientRegistrationProvider.toClientRepresentation(client);
        OID4VCClientRegistrationProvider.validate(clientRepresentation);
        clientRepresentation = this.update(clientDid, new DefaultClientRegistrationContext(this.session, clientRepresentation, this));
        return Response.ok((Object)clientRepresentation).build();
    }

    @DELETE
    @Path(value="{clientId}")
    public Response deleteOID4VCClient(@PathParam(value="clientId") String clientDid) {
        this.delete(clientDid);
        return Response.noContent().build();
    }

    public static void validate(ClientRepresentation client) {
        String did = client.getClientId();
        if (did == null) {
            throw new ErrorResponseException("no_did", "A client did needs to be configured for OID4VC clients", Response.Status.BAD_REQUEST);
        }
        if (!did.startsWith("did:")) {
            throw new ErrorResponseException("invalid_did", "The client id is not a did.", Response.Status.BAD_REQUEST);
        }
    }

    protected static ClientRepresentation toClientRepresentation(OID4VCClient oid4VCClient) {
        ClientRepresentation clientRepresentation = new ClientRepresentation();
        clientRepresentation.setProtocol("oid4vc");
        clientRepresentation.setId(Optional.ofNullable(oid4VCClient.getId()).orElse(UUID.randomUUID().toString()));
        clientRepresentation.setClientId(oid4VCClient.getClientDid());
        Optional.ofNullable(oid4VCClient.getDescription()).ifPresent(arg_0 -> ((ClientRepresentation)clientRepresentation).setDescription(arg_0));
        Optional.ofNullable(oid4VCClient.getName()).ifPresent(arg_0 -> ((ClientRepresentation)clientRepresentation).setName(arg_0));
        Map<String, String> clientAttributes = oid4VCClient.getSupportedVCTypes().stream().map(SupportedCredentialConfiguration::toDotNotation).flatMap(dotNotated -> dotNotated.entrySet().stream()).collect(Collectors.toMap(entry -> "vc." + (String)entry.getKey(), Map.Entry::getValue, (e1, e2) -> e1));
        if (!clientAttributes.isEmpty()) {
            clientRepresentation.setAttributes(clientAttributes);
        }
        LOGGER.debugf("Generated client representation {}.", (Object)clientRepresentation);
        return clientRepresentation;
    }

    public static OID4VCClient fromClientAttributes(String clientId, Map<String, String> clientAttributes) {
        OID4VCClient oid4VCClient = new OID4VCClient().setClientDid(clientId);
        HashSet supportedCredentialIds = new HashSet();
        HashMap attributes = new HashMap();
        clientAttributes.entrySet().forEach(entry -> {
            if (!((String)entry.getKey()).startsWith(VC_KEY)) {
                return;
            }
            String key = ((String)entry.getKey()).substring("vc.".length());
            supportedCredentialIds.add(key.split("\\.")[0]);
            attributes.put(key, (String)entry.getValue());
        });
        List<SupportedCredentialConfiguration> supportedCredentialConfigurations = supportedCredentialIds.stream().map(id -> SupportedCredentialConfiguration.fromDotNotation(id, attributes)).toList();
        return oid4VCClient.setSupportedVCTypes(supportedCredentialConfigurations);
    }
}

