/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.builditem;

import io.quarkus.builder.item.SimpleBuildItem;

public final class CompiledJavaVersionBuildItem
extends SimpleBuildItem {
    private final JavaVersion javaVersion;

    private CompiledJavaVersionBuildItem(JavaVersion javaVersion) {
        this.javaVersion = javaVersion;
    }

    public static CompiledJavaVersionBuildItem unknown() {
        return new CompiledJavaVersionBuildItem(new JavaVersion.Unknown());
    }

    public static CompiledJavaVersionBuildItem fromMajorJavaVersion(int majorJavaVersion) {
        return new CompiledJavaVersionBuildItem(new JavaVersion.Known(majorJavaVersion));
    }

    public JavaVersion getJavaVersion() {
        return this.javaVersion;
    }

    public static interface JavaVersion {
        public Status isExactlyJava11();

        public Status isJava11OrHigher();

        public Status isJava17OrHigher();

        public Status isJava21OrHigher();

        public Status isJava19OrHigher();

        public static final class Known
        implements JavaVersion {
            private static final int JAVA_11_MAJOR = 55;
            private static final int JAVA_17_MAJOR = 61;
            private static final int JAVA_19_MAJOR = 63;
            private static final int JAVA_21_MAJOR = 65;
            private final int determinedMajor;

            Known(int determinedMajor) {
                this.determinedMajor = determinedMajor;
            }

            @Override
            public Status isExactlyJava11() {
                return this.equalStatus(55);
            }

            @Override
            public Status isJava11OrHigher() {
                return this.higherOrEqualStatus(55);
            }

            @Override
            public Status isJava17OrHigher() {
                return this.higherOrEqualStatus(61);
            }

            @Override
            public Status isJava19OrHigher() {
                return this.higherOrEqualStatus(63);
            }

            @Override
            public Status isJava21OrHigher() {
                return this.higherOrEqualStatus(65);
            }

            private Status higherOrEqualStatus(int javaMajor) {
                return this.determinedMajor >= javaMajor ? Status.TRUE : Status.FALSE;
            }

            private Status equalStatus(int javaMajor) {
                return this.determinedMajor == javaMajor ? Status.TRUE : Status.FALSE;
            }
        }

        public static final class Unknown
        implements JavaVersion {
            Unknown() {
            }

            @Override
            public Status isExactlyJava11() {
                return Status.UNKNOWN;
            }

            @Override
            public Status isJava11OrHigher() {
                return Status.UNKNOWN;
            }

            @Override
            public Status isJava17OrHigher() {
                return Status.UNKNOWN;
            }

            @Override
            public Status isJava21OrHigher() {
                return Status.UNKNOWN;
            }

            @Override
            public Status isJava19OrHigher() {
                return Status.UNKNOWN;
            }
        }

        public static enum Status {
            TRUE,
            FALSE,
            UNKNOWN;

        }
    }
}

