/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.keycloak.common.util.reflections.Types;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputUpdater;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.CredentialProviderFactory;
import org.keycloak.credential.UserCredentialStore;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.SubjectCredentialManager;
import org.keycloak.models.UserModel;
import org.keycloak.storage.AbstractStorageManager;
import org.keycloak.storage.DatastoreProvider;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.StoreManagers;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderFactory;
import org.keycloak.storage.UserStorageProviderModel;

public class UserCredentialManager
extends AbstractStorageManager<UserStorageProvider, UserStorageProviderModel>
implements SubjectCredentialManager {
    private final UserModel user;
    private final KeycloakSession session;
    private final RealmModel realm;

    public UserCredentialManager(KeycloakSession session, RealmModel realm, UserModel user) {
        super(session, UserStorageProviderFactory.class, UserStorageProvider.class, UserStorageProviderModel::new, "user");
        this.user = user;
        this.session = session;
        this.realm = realm;
    }

    public boolean isValid(List<CredentialInput> inputs) {
        String providerId;
        if (!this.isValid(this.user)) {
            return false;
        }
        LinkedList<CredentialInput> toValidate = new LinkedList<CredentialInput>(inputs);
        String string = providerId = StorageId.isLocalStorage((String)this.user.getId()) ? this.user.getFederationLink() : StorageId.providerId((String)this.user.getId());
        if (providerId != null) {
            UserStorageProviderModel model = (UserStorageProviderModel)((Object)this.getStorageProviderModel(this.realm, providerId));
            if (model == null || !model.isEnabled()) {
                return false;
            }
            CredentialInputValidator validator2 = this.getStorageProviderInstance(model, CredentialInputValidator.class);
            if (validator2 != null) {
                this.validate(this.realm, this.user, toValidate, validator2);
            }
        }
        UserCredentialManager.getCredentialProviders(this.session, CredentialInputValidator.class).forEach(validator -> this.validate(this.realm, this.user, (List<CredentialInput>)toValidate, (CredentialInputValidator)validator));
        return toValidate.isEmpty();
    }

    public boolean updateCredential(CredentialInput input) {
        String providerId;
        String string = providerId = StorageId.isLocalStorage((String)this.user.getId()) ? this.user.getFederationLink() : StorageId.providerId((String)this.user.getId());
        if (!StorageId.isLocalStorage((String)this.user.getId())) {
            this.throwExceptionIfInvalidUser(this.user);
        }
        if (providerId != null) {
            UserStorageProviderModel model = (UserStorageProviderModel)((Object)this.getStorageProviderModel(this.realm, providerId));
            if (model == null || !model.isEnabled()) {
                return false;
            }
            CredentialInputUpdater updater2 = this.getStorageProviderInstance(model, CredentialInputUpdater.class);
            if (updater2 != null && updater2.supportsCredentialType(input.getType()) && updater2.updateCredential(this.realm, this.user, input)) {
                return true;
            }
        }
        return UserCredentialManager.getCredentialProviders(this.session, CredentialInputUpdater.class).filter(updater -> updater.supportsCredentialType(input.getType())).anyMatch(updater -> updater.updateCredential(this.realm, this.user, input));
    }

    public void updateStoredCredential(CredentialModel cred) {
        this.throwExceptionIfInvalidUser(this.user);
        this.getStoreForUser(this.user).updateCredential(this.realm, this.user, cred);
    }

    public CredentialModel createStoredCredential(CredentialModel cred) {
        this.throwExceptionIfInvalidUser(this.user);
        return this.getStoreForUser(this.user).createCredential(this.realm, this.user, cred);
    }

    public boolean removeStoredCredentialById(String id) {
        this.throwExceptionIfInvalidUser(this.user);
        return this.getStoreForUser(this.user).removeStoredCredential(this.realm, this.user, id);
    }

    public CredentialModel getStoredCredentialById(String id) {
        return this.getStoreForUser(this.user).getStoredCredentialById(this.realm, this.user, id);
    }

    public Stream<CredentialModel> getStoredCredentialsStream() {
        return this.getStoreForUser(this.user).getStoredCredentialsStream(this.realm, this.user);
    }

    public Stream<CredentialModel> getStoredCredentialsByTypeStream(String type) {
        return this.getStoreForUser(this.user).getStoredCredentialsByTypeStream(this.realm, this.user, type);
    }

    public CredentialModel getStoredCredentialByNameAndType(String name, String type) {
        return this.getStoreForUser(this.user).getStoredCredentialByNameAndType(this.realm, this.user, name, type);
    }

    public boolean moveStoredCredentialTo(String id, String newPreviousCredentialId) {
        this.throwExceptionIfInvalidUser(this.user);
        return this.getStoreForUser(this.user).moveCredentialTo(this.realm, this.user, id, newPreviousCredentialId);
    }

    public void updateCredentialLabel(String credentialId, String userLabel) {
        this.throwExceptionIfInvalidUser(this.user);
        CredentialModel credential = this.getStoredCredentialById(credentialId);
        credential.setUserLabel(userLabel);
        this.updateStoredCredential(credential);
    }

    public void disableCredentialType(String credentialType) {
        String providerId;
        String string = providerId = StorageId.isLocalStorage((String)this.user.getId()) ? this.user.getFederationLink() : StorageId.providerId((String)this.user.getId());
        if (!StorageId.isLocalStorage((String)this.user.getId())) {
            this.throwExceptionIfInvalidUser(this.user);
        }
        if (providerId != null) {
            UserStorageProviderModel model = (UserStorageProviderModel)((Object)this.getStorageProviderModel(this.realm, providerId));
            if (model == null || !model.isEnabled()) {
                return;
            }
            CredentialInputUpdater updater2 = this.getStorageProviderInstance(model, CredentialInputUpdater.class);
            if (updater2.supportsCredentialType(credentialType)) {
                updater2.disableCredentialType(this.realm, this.user, credentialType);
            }
        }
        UserCredentialManager.getCredentialProviders(this.session, CredentialInputUpdater.class).filter(updater -> updater.supportsCredentialType(credentialType)).forEach(updater -> updater.disableCredentialType(this.realm, this.user, credentialType));
    }

    public Stream<String> getDisableableCredentialTypesStream() {
        String providerId;
        Stream types = Stream.empty();
        String string = providerId = StorageId.isLocalStorage((UserModel)this.user) ? this.user.getFederationLink() : StorageId.resolveProviderId((UserModel)this.user);
        if (providerId != null) {
            UserStorageProviderModel model = (UserStorageProviderModel)((Object)this.getStorageProviderModel(this.realm, providerId));
            if (model == null || !model.isEnabled()) {
                return types;
            }
            CredentialInputUpdater updater2 = this.getStorageProviderInstance(model, CredentialInputUpdater.class);
            if (updater2 != null) {
                types = updater2.getDisableableCredentialTypesStream(this.realm, this.user);
            }
        }
        return Stream.concat(types, UserCredentialManager.getCredentialProviders(this.session, CredentialInputUpdater.class).flatMap(updater -> updater.getDisableableCredentialTypesStream(this.realm, this.user))).distinct();
    }

    public boolean isConfiguredFor(String type) {
        UserStorageCredentialConfigured userStorageConfigured = this.isConfiguredThroughUserStorage(this.realm, this.user, type);
        switch (userStorageConfigured) {
            case CONFIGURED: {
                return true;
            }
            case USER_STORAGE_DISABLED: {
                return false;
            }
        }
        return this.isConfiguredLocally(type);
    }

    public boolean isConfiguredLocally(String type) {
        return UserCredentialManager.getCredentialProviders(this.session, CredentialInputValidator.class).anyMatch(validator -> validator.supportsCredentialType(type) && validator.isConfiguredFor(this.realm, this.user, type));
    }

    public Stream<String> getConfiguredUserStorageCredentialTypesStream() {
        return UserCredentialManager.getCredentialProviders(this.session, CredentialProvider.class).map(CredentialProvider::getType).filter(credentialType -> UserStorageCredentialConfigured.CONFIGURED == this.isConfiguredThroughUserStorage(this.realm, this.user, (String)credentialType));
    }

    public CredentialModel createCredentialThroughProvider(CredentialModel model) {
        this.throwExceptionIfInvalidUser(this.user);
        return this.session.getKeycloakSessionFactory().getProviderFactoriesStream(CredentialProvider.class).map(f -> (CredentialProvider)this.session.getProvider(CredentialProvider.class, f.getId())).filter(provider -> Objects.equals(provider.getType(), model.getType())).map(cp -> cp.createCredential(this.realm, this.user, cp.getCredentialFromModel(model))).findFirst().orElse(null);
    }

    private UserStorageCredentialConfigured isConfiguredThroughUserStorage(RealmModel realm, UserModel user, String type) {
        String providerId;
        String string = providerId = StorageId.isLocalStorage((UserModel)user) ? user.getFederationLink() : StorageId.resolveProviderId((UserModel)user);
        if (providerId != null) {
            UserStorageProviderModel model = (UserStorageProviderModel)((Object)this.getStorageProviderModel(realm, providerId));
            if (model == null || !model.isEnabled()) {
                return UserStorageCredentialConfigured.USER_STORAGE_DISABLED;
            }
            CredentialInputValidator validator = this.getStorageProviderInstance(model, CredentialInputValidator.class);
            if (validator != null && validator.supportsCredentialType(type) && validator.isConfiguredFor(realm, user, type)) {
                return UserStorageCredentialConfigured.CONFIGURED;
            }
        }
        return UserStorageCredentialConfigured.NOT_CONFIGURED;
    }

    private boolean isValid(UserModel user) {
        Objects.requireNonNull(user);
        return user.getServiceAccountClientLink() == null;
    }

    private void validate(RealmModel realm, UserModel user, List<CredentialInput> toValidate, CredentialInputValidator validator) {
        toValidate.removeIf(input -> validator.supportsCredentialType(input.getType()) && validator.isValid(realm, user, input));
    }

    private static <T> Stream<T> getCredentialProviders(KeycloakSession session, Class<T> type) {
        return session.getKeycloakSessionFactory().getProviderFactoriesStream(CredentialProvider.class).filter(f -> Types.supports((Class)type, (Object)f, CredentialProviderFactory.class)).map(f -> session.getProvider(CredentialProvider.class, f.getId()));
    }

    private void throwExceptionIfInvalidUser(UserModel user) {
        if (!this.isValid(user)) {
            throw new RuntimeException("You can not manage credentials for this user");
        }
    }

    private UserCredentialStore getStoreForUser(UserModel user) {
        StoreManagers p = (StoreManagers)this.session.getProvider(DatastoreProvider.class);
        if (StorageId.isLocalStorage((String)user.getId())) {
            return (UserCredentialStore)p.userLocalStorage();
        }
        return (UserCredentialStore)p.userFederatedStorage();
    }

    private static enum UserStorageCredentialConfigured {
        CONFIGURED,
        USER_STORAGE_DISABLED,
        NOT_CONFIGURED;

    }
}

