/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.helpers.queues.Queues;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.operators.multi.processors.UnicastProcessor;
import io.smallrye.mutiny.subscription.BackPressureFailure;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.time.Duration;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class MultiWindowOnDurationOp<T>
extends AbstractMultiOperator<T, Multi<T>> {
    private final Duration duration;
    private final ScheduledExecutorService executor;

    public MultiWindowOnDurationOp(Multi<T> upstream, Duration duration, ScheduledExecutorService executor) {
        super(upstream);
        this.duration = ParameterValidation.validate(duration, "duration");
        this.executor = ParameterValidation.nonNull(executor, "executor");
    }

    @Override
    public void subscribe(MultiSubscriber<? super Multi<T>> actual) {
        this.upstream.subscribe().withSubscriber(new WindowTimeoutSubscriber(actual, this.duration, this.executor));
    }

    private static class TaskHolder {
        private final AtomicReference<Future<?>> container = new AtomicReference();
        static final Future<?> NONE = new CompletableFuture();

        private TaskHolder() {
        }

        boolean replace(Future<?> task) {
            Future<?> current;
            do {
                if ((current = this.container.get()) != NONE) continue;
                if (task != null) {
                    task.cancel(false);
                }
                return false;
            } while (!this.container.compareAndSet(current, task));
            return true;
        }

        void cancel() {
            Future<?> task = this.container.getAndSet(NONE);
            if (task != null && task != NONE) {
                task.cancel(false);
            }
        }
    }

    static final class WindowTimeoutSubscriber<T>
    extends MultiOperatorProcessor<T, Multi<T>> {
        private final Duration duration;
        private final ScheduledExecutorService scheduler;
        private final Queue<Object> queue;
        private Throwable failure;
        private UnicastProcessor<T> current;
        private final AtomicLong requested = new AtomicLong();
        private final AtomicInteger wip = new AtomicInteger();
        private final TaskHolder timer = new TaskHolder();
        volatile boolean done;
        volatile boolean terminated;

        WindowTimeoutSubscriber(MultiSubscriber<? super Multi<T>> downstream, Duration duration, ScheduledExecutorService scheduler) {
            super(downstream);
            this.queue = Queues.createMpscQueue();
            this.duration = duration;
            this.scheduler = scheduler;
        }

        @Override
        public void onSubscribe(Flow.Subscription s) {
            if (this.compareAndSetUpstreamSubscription(null, s)) {
                this.downstream.onSubscribe(this);
                if (this.isCancelled()) {
                    return;
                }
                UnicastProcessor w = UnicastProcessor.create();
                this.current = w;
                long r = this.requested.get();
                if (r != 0L) {
                    this.downstream.onNext(w);
                    if (r != Long.MAX_VALUE) {
                        this.requested.decrementAndGet();
                    }
                } else {
                    this.downstream.onFailure(new BackPressureFailure("no requests"));
                    return;
                }
                if (this.timer.replace(this.newPeriod())) {
                    s.request(Long.MAX_VALUE);
                }
            }
        }

        Future<?> newPeriod() {
            try {
                return this.scheduler.scheduleAtFixedRate(new Tick(this), this.duration.toMillis(), this.duration.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (Throwable e) {
                this.downstream.onFailure(e);
                return TaskHolder.NONE;
            }
        }

        @Override
        public void onItem(T item) {
            if (this.terminated) {
                return;
            }
            if (this.wip.compareAndSet(0, 1)) {
                UnicastProcessor<T> w = this.current;
                w.onNext(item);
                if (this.wip.decrementAndGet() == 0) {
                    return;
                }
            } else {
                this.queue.offer(item);
                if (!this.canStartWork()) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onFailure(Throwable t) {
            Flow.Subscription subscription = this.getAndSetUpstreamSubscription(Subscriptions.CANCELLED);
            if (subscription != Subscriptions.CANCELLED) {
                this.done = true;
                this.failure = t;
                if (this.canStartWork()) {
                    this.drainLoop();
                }
                this.downstream.onFailure(t);
                this.timer.cancel();
            } else {
                Infrastructure.handleDroppedException(t);
            }
        }

        @Override
        public void onCompletion() {
            Flow.Subscription subscription = this.getAndSetUpstreamSubscription(Subscriptions.CANCELLED);
            if (subscription != Subscriptions.CANCELLED) {
                this.done = true;
                if (this.canStartWork()) {
                    this.drainLoop();
                }
                this.downstream.onCompletion();
                this.timer.cancel();
            }
        }

        @Override
        public void request(long n) {
            if (n > 0L) {
                Subscriptions.add(this.requested, n);
            }
        }

        void drainLoop() {
            Queue<Object> q = this.queue;
            MultiSubscriber actual = this.downstream;
            UnicastProcessor<Object> processor = this.current;
            int missed = 1;
            while (true) {
                if (this.terminated) {
                    super.cancel();
                    q.clear();
                    this.timer.cancel();
                    return;
                }
                boolean d = this.done;
                Object o = q.poll();
                boolean empty = o == null;
                boolean isTick = o instanceof Tick;
                if (d && (empty || isTick)) {
                    this.current = null;
                    q.clear();
                    Throwable err = this.failure;
                    if (err != null) {
                        processor.onError(err);
                    } else {
                        processor.onComplete();
                    }
                    this.timer.cancel();
                    return;
                }
                if (!empty) {
                    if (isTick) {
                        processor.onComplete();
                        processor = UnicastProcessor.create();
                        this.current = processor;
                        long requests = this.requested.get();
                        if (requests != 0L) {
                            actual.onItem(processor);
                            if (requests == Long.MAX_VALUE) continue;
                            this.requested.decrementAndGet();
                            continue;
                        }
                        this.current = null;
                        this.queue.clear();
                        actual.onError(new BackPressureFailure("no requests"));
                        this.timer.cancel();
                        return;
                    }
                    processor.onNext(o);
                    continue;
                }
                if ((missed = this.wip.addAndGet(-missed)) == 0) break;
            }
        }

        boolean canStartWork() {
            return this.wip.getAndIncrement() == 0;
        }

        static final class Tick
        implements Runnable {
            private final WindowTimeoutSubscriber<?> parent;

            Tick(WindowTimeoutSubscriber<?> parent) {
                this.parent = parent;
            }

            @Override
            public void run() {
                WindowTimeoutSubscriber<?> p = this.parent;
                if (!p.isCancelled()) {
                    p.queue.offer(this);
                } else {
                    p.terminated = true;
                    p.timer.cancel();
                }
                if (p.canStartWork()) {
                    p.drainLoop();
                }
            }
        }
    }
}

