/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import java.util.Optional;
import org.keycloak.config.ProxyOptions;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;

final class ProxyPropertyMappers {
    private ProxyPropertyMappers() {
    }

    public static PropertyMapper<?>[] getProxyPropertyMappers() {
        return new PropertyMapper[]{PropertyMapper.fromOption(ProxyOptions.PROXY_HEADERS).to("quarkus.http.proxy.proxy-address-forwarding").transformer((v, c) -> ProxyPropertyMappers.proxyEnabled(null, v, c)).paramLabel("headers").build(), PropertyMapper.fromOption(ProxyOptions.PROXY).paramLabel("mode").build(), PropertyMapper.fromOption(ProxyOptions.PROXY_FORWARDED_HOST).to("quarkus.http.proxy.enable-forwarded-host").mapFrom("proxy-headers").transformer((v, c) -> ProxyPropertyMappers.proxyEnabled(null, v, c)).build(), PropertyMapper.fromOption(ProxyOptions.PROXY_FORWARDED_HEADER_ENABLED).to("quarkus.http.proxy.allow-forwarded").mapFrom("proxy-headers").transformer((v, c) -> ProxyPropertyMappers.proxyEnabled(ProxyOptions.Headers.forwarded, v, c)).build(), PropertyMapper.fromOption(ProxyOptions.PROXY_X_FORWARDED_HEADER_ENABLED).to("quarkus.http.proxy.allow-x-forwarded").mapFrom("proxy-headers").transformer((v, c) -> ProxyPropertyMappers.proxyEnabled(ProxyOptions.Headers.xforwarded, v, c)).build()};
    }

    private static Optional<String> proxyEnabled(ProxyOptions.Headers testHeader, Optional<String> value, ConfigSourceInterceptorContext context) {
        boolean enabled;
        if (value.isPresent()) {
            enabled = testHeader != null ? ProxyOptions.Headers.valueOf((String)value.get()).equals((Object)testHeader) : true;
        } else {
            String proxyKey = "kc." + ProxyOptions.PROXY.getKey();
            ConfigValue proxyOptionConfigValue = context.proceed(proxyKey);
            ProxyOptions.Mode proxyMode = proxyOptionConfigValue == null ? (ProxyOptions.Mode)PropertyMappers.getMapper(proxyKey).getDefaultValue().orElseThrow() : ProxyOptions.Mode.valueOf((String)proxyOptionConfigValue.getValue());
            enabled = proxyMode.isProxyHeadersEnabled();
        }
        return Optional.of(String.valueOf(enabled));
    }
}

