---
id: Button
section: components
cssPrefix: pf-v5-c-button
---import './Button.css'

## Examples

### Variations

```html
<button class="pf-v5-c-button pf-m-primary" type="button">Primary</button>

<button class="pf-v5-c-button pf-m-secondary" type="button">Secondary</button>

<button
  class="pf-v5-c-button pf-m-secondary pf-m-danger"
  type="button"
>Secondary danger</button>

<button class="pf-v5-c-button pf-m-tertiary" type="button">Tertiary</button>

<button class="pf-v5-c-button pf-m-danger" type="button">Danger</button>

<button class="pf-v5-c-button pf-m-warning" type="button">Warning</button>

<br />
<br />
<button class="pf-v5-c-button pf-m-link" type="button">
  <span class="pf-v5-c-button__icon pf-m-start">
    <i class="fas fa-plus-circle" aria-hidden="true"></i>
  </span>
  Link
</button>

<button class="pf-v5-c-button pf-m-link" type="button">
  Link
  <span class="pf-v5-c-button__icon pf-m-end">
    <i class="fas fa-plus-circle" aria-hidden="true"></i>
  </span>
</button>

<button class="pf-v5-c-button pf-m-link pf-m-danger" type="button">
  <span class="pf-v5-c-button__icon pf-m-start">
    <i class="fas fa-plus-circle" aria-hidden="true"></i>
  </span>
  Link danger
</button>

<button class="pf-v5-c-button pf-m-inline pf-m-link" type="button">Inline link</button>
<br />
<br />
<span>Default plain button:</span>
<button class="pf-v5-c-button pf-m-plain" type="button" aria-label="Remove">
  <i class="fas fa-times" aria-hidden="true"></i>
</button>
<br />
<span>No padding plain button:</span>
<button
  class="pf-v5-c-button pf-m-plain pf-m-no-padding"
  type="button"
  aria-label="Remove"
>
  <i class="fas fa-times" aria-hidden="true"></i>
</button>
<br />
<br />
<button class="pf-v5-c-button pf-m-control" type="button">Control</button>

<button
  class="pf-v5-c-button pf-m-control"
  type="button"
  aria-label="Copy input"
>
  <i class="fas fa-copy" aria-hidden="true"></i>
</button>

```

### Small buttons

```html
<button class="pf-v5-c-button pf-m-primary pf-m-small" type="button">Primary</button>

<button class="pf-v5-c-button pf-m-secondary pf-m-small" type="button">Secondary</button>

<button
  class="pf-v5-c-button pf-m-secondary pf-m-danger pf-m-small"
  type="button"
>Secondary danger</button>

<button class="pf-v5-c-button pf-m-tertiary pf-m-small" type="button">Tertiary</button>

<button class="pf-v5-c-button pf-m-danger pf-m-small" type="button">Danger</button>

<button class="pf-v5-c-button pf-m-warning pf-m-small" type="button">Warning</button>

<button class="pf-v5-c-button pf-m-link pf-m-small" type="button">
  Link
  <span class="pf-v5-c-button__icon pf-m-end">
    <i class="fas fa-plus-circle" aria-hidden="true"></i>
  </span>
</button>

<button class="pf-v5-c-button pf-m-link pf-m-danger pf-m-small" type="button">
  Link danger
  <span class="pf-v5-c-button__icon pf-m-end">
    <i class="fas fa-plus-circle" aria-hidden="true"></i>
  </span>
</button>

<button
  class="pf-v5-c-button pf-m-inline pf-m-link pf-m-small"
  type="button"
>Inline link</button>

<button class="pf-v5-c-button pf-m-control pf-m-small" type="button">Control</button>

```

### Disabled

```html
<button
  class="pf-v5-c-button pf-m-primary"
  type="button"
  disabled
>Primary disabled</button>

<button
  class="pf-v5-c-button pf-m-secondary"
  type="button"
  disabled
>Secondary disabled</button>

<button
  class="pf-v5-c-button pf-m-secondary pf-m-danger"
  type="button"
  disabled
>Secondary danger disabled</button>

<button
  class="pf-v5-c-button pf-m-tertiary"
  type="button"
  disabled
>Tertiary disabled</button>

<button
  class="pf-v5-c-button pf-m-danger"
  type="button"
  disabled
>Danger disabled</button>

<button
  class="pf-v5-c-button pf-m-warning"
  type="button"
  disabled
>Warning disabled</button>

<button class="pf-v5-c-button pf-m-link" type="button" disabled>
  <span class="pf-v5-c-button__icon pf-m-start">
    <i class="fas fa-plus-circle" aria-hidden="true"></i>
  </span>
  Link disabled
</button>

<button class="pf-v5-c-button pf-m-link pf-m-danger" type="button" disabled>
  <span class="pf-v5-c-button__icon pf-m-start">
    <i class="fas fa-plus-circle" aria-hidden="true"></i>
  </span>
  Link danger disabled
</button>

<button
  class="pf-v5-c-button pf-m-link pf-m-inline"
  type="button"
  disabled
>Inline link disabled</button>

<button
  class="pf-v5-c-button pf-m-plain"
  type="button"
  aria-label="Remove"
  disabled
>
  <i class="fas fa-times" aria-hidden="true"></i>
</button>

<button
  class="pf-v5-c-button pf-m-control"
  type="button"
  disabled
>Control disabled</button>

```

### Aria-disabled

```html
<button
  class="pf-v5-c-button pf-m-primary pf-m-aria-disabled"
  type="button"
  aria-disabled="true"
>Primary disabled</button>

<button
  class="pf-v5-c-button pf-m-secondary pf-m-aria-disabled"
  type="button"
  aria-disabled="true"
>Secondary disabled</button>

<button
  class="pf-v5-c-button pf-m-secondary pf-m-danger pf-m-aria-disabled"
  type="button"
  aria-disabled="true"
>Secondary danger disabled</button>

<button
  class="pf-v5-c-button pf-m-tertiary pf-m-aria-disabled"
  type="button"
  aria-disabled="true"
>Tertiary disabled</button>

<button
  class="pf-v5-c-button pf-m-danger pf-m-aria-disabled"
  type="button"
  aria-disabled="true"
>Danger disabled</button>

<button
  class="pf-v5-c-button pf-m-warning pf-m-aria-disabled"
  type="button"
  aria-disabled="true"
>Warning disabled</button>

<button
  class="pf-v5-c-button pf-m-link pf-m-aria-disabled"
  type="button"
  aria-disabled="true"
>
  <span class="pf-v5-c-button__icon pf-m-start">
    <i class="fas fa-plus-circle" aria-hidden="true"></i>
  </span>
  Link disabled
</button>

<button
  class="pf-v5-c-button pf-m-link pf-m-danger pf-m-aria-disabled"
  type="button"
  aria-disabled="true"
>
  <span class="pf-v5-c-button__icon pf-m-start">
    <i class="fas fa-plus-circle" aria-hidden="true"></i>
  </span>
  Link danger disabled
</button>

<button
  class="pf-v5-c-button pf-m-link pf-m-inline pf-m-aria-disabled"
  type="button"
  aria-disabled="true"
>Inline link disabled</button>

<button
  class="pf-v5-c-button pf-m-plain pf-m-aria-disabled"
  type="button"
  aria-label="Remove"
  aria-disabled="true"
>
  <i class="fas fa-times" aria-hidden="true"></i>
</button>

<button
  class="pf-v5-c-button pf-m-control pf-m-aria-disabled"
  type="button"
  aria-disabled="true"
>Control disabled</button>

```

### Links as buttons

```html
<a
  class="pf-v5-c-button pf-m-primary"
  href="https://www.w3.org/TR/WCAG20-TECHS/ARIA8.html#ARIA8-examples"
>Primary link to W3.org</a>

<a
  class="pf-v5-c-button pf-m-secondary"
  href="#overview"
  aria-label="Read more about button documentation"
>Secondary link to anchor</a>

<a
  class="pf-v5-c-button pf-m-secondary pf-m-danger"
  href="#overview"
  aria-label="Read more about button documentation"
>Secondary danger link to anchor</a>

<a
  class="pf-v5-c-button pf-m-tertiary pf-m-disabled"
  href="https://www.w3.org/TR/WCAG20-TECHS/ARIA8.html#ARIA8-examples"
  aria-disabled="true"
  tabindex="-1"
>Tertiary link to W3.org</a>

<a
  class="pf-v5-c-button pf-m-link"
  href="https://www.w3.org/TR/WCAG20-TECHS/ARIA8.html#ARIA8-examples"
>Link to W3.org</a>

<a
  class="pf-v5-c-button pf-m-link pf-m-danger"
  href="https://www.w3.org/TR/WCAG20-TECHS/ARIA8.html#ARIA8-examples"
>Link danger to W3.org</a>

```

### Inline link as span

```html
Lorem ipsum dolor sit amet, consectetur adipiscing elit.
<span
  class="pf-v5-c-button pf-m-link pf-m-inline"
  type="button"
  role="button"
  tabindex="0"
>This is long button text that needs to be a span so that it will wrap inline with the text around it.</span>
Sed hendrerit nisi in cursus maximus. Ut malesuada nisi turpis, in condimentum velit elementum non.

```

### Block level

```html
<button
  class="pf-v5-c-button pf-m-primary pf-m-block"
  type="button"
>Block level button</button>

```

### Types

```html
<button class="pf-v5-c-button pf-m-primary" type="submit">Submit</button>

<button class="pf-v5-c-button pf-m-primary" type="reset">Reset</button>

<button class="pf-v5-c-button pf-m-primary" type="button">Default</button>

```

### Call to action

```html
<button
  class="pf-v5-c-button pf-m-primary pf-m-display-lg"
  type="button"
>Call to action</button>

<button
  class="pf-v5-c-button pf-m-secondary pf-m-display-lg"
  type="button"
>Call to action</button>

<button
  class="pf-v5-c-button pf-m-tertiary pf-m-display-lg"
  type="button"
>Call to action</button>

<button class="pf-v5-c-button pf-m-link pf-m-display-lg" type="button">
  Call to action
  <span class="pf-v5-c-button__icon pf-m-end">
    <i class="fas fa-arrow-right" aria-hidden="true"></i>
  </span>
</button>

<button
  class="pf-v5-c-button pf-m-link pf-m-inline pf-m-display-lg"
  type="button"
>
  Call to action
  <span class="pf-v5-c-button__icon pf-m-end">
    <i class="fas fa-arrow-right" aria-hidden="true"></i>
  </span>
</button>

```

### Progress

```html
<button
  class="pf-v5-c-button pf-m-progress pf-m-primary"
  type="button"
>Primary loader</button>

<button
  class="pf-v5-c-button pf-m-progress pf-m-in-progress pf-m-primary"
  type="button"
>
  <span class="pf-v5-c-button__progress">
    <svg
      class="pf-v5-c-spinner pf-m-md"
      role="progressbar"
      viewBox="0 0 100 100"
      aria-label="Loading..."
    >
      <circle class="pf-v5-c-spinner__path" cx="50" cy="50" r="45" fill="none" />
    </svg>
  </span>
  Primary loading
</button>
<br />
<button
  class="pf-v5-c-button pf-m-progress pf-m-secondary"
  type="button"
>Secondary loader</button>

<button
  class="pf-v5-c-button pf-m-progress pf-m-in-progress pf-m-secondary"
  type="button"
>
  <span class="pf-v5-c-button__progress">
    <svg
      class="pf-v5-c-spinner pf-m-md"
      role="progressbar"
      viewBox="0 0 100 100"
      aria-label="Loading..."
    >
      <circle class="pf-v5-c-spinner__path" cx="50" cy="50" r="45" fill="none" />
    </svg>
  </span>
  Secondary loading
</button>
<br />
<button class="pf-v5-c-button pf-m-plain" type="button" aria-label="Upload">
  <i class="fas fa-upload" aria-hidden="true"></i>
</button>

<button class="pf-v5-c-button pf-m-in-progress pf-m-plain" type="button">
  <span class="pf-v5-c-button__progress">
    <svg
      class="pf-v5-c-spinner pf-m-md"
      role="progressbar"
      viewBox="0 0 100 100"
      aria-label="Uploading..."
    >
      <circle class="pf-v5-c-spinner__path" cx="50" cy="50" r="45" fill="none" />
    </svg>
  </span>

  <i class="fas fa-upload" aria-hidden="true"></i>
</button>
<br />
<button
  class="pf-v5-c-button pf-m-progress pf-m-inline pf-m-link"
  type="button"
>Inline loader</button>

<button
  class="pf-v5-c-button pf-m-progress pf-m-in-progress pf-m-inline pf-m-link"
  type="button"
>
  <span class="pf-v5-c-button__progress">
    <svg
      class="pf-v5-c-spinner pf-m-inline"
      role="progressbar"
      viewBox="0 0 100 100"
      aria-label="Loading..."
    >
      <circle class="pf-v5-c-spinner__path" cx="50" cy="50" r="45" fill="none" />
    </svg>
  </span>
  Inline loading
</button>

```

### Link button with a count

```html isBeta
<button
  class="pf-v5-c-button pf-m-link"
  type="button"
  aria-label="View 7 issues"
>
  View issues
  <span class="pf-v5-c-button__count">
    <span class="pf-v5-c-badge pf-m-unread">7</span>
  </span>
</button>
<button
  class="pf-v5-c-button pf-m-link"
  type="button"
  aria-label="View 7 issues"
>
  View issues
  <span class="pf-v5-c-button__count">
    <span class="pf-v5-c-badge pf-m-read">7</span>
  </span>
</button>

```

## Documentation

### Overview

Always add a modifier class to add color to the button.

### Button vs link

Semantic buttons and links are important for usability as well as accessibility. Using an `a` instead of a `button` element to perform user initiated actions should be avoided, unless absolutely necessary.

### Accessibility

| Attribute | Applied to | Outcome |
| -- | -- | -- |
| `aria-pressed="true or false"` | `.pf-v5-c-button` | Indicates that the button is a toggle. When set to "true", `pf-m-active` should also be set so that the button displays in an active state. **Required when button is a toggle** |
| `aria-label="[button label text]"` | `.pf-v5-c-button.pf-m-plain` | Provides an accessible name for the button when an icon is used instead of text. **Required when icon is used with no supporting text** |
| `aria-label="[descriptive text]"` | `a.pf-v5-c-button`, `span.pf-v5-c-button.pf-m-link.pf-m-inline` | The button component's text should adequately describe its purpose. If it does not, `aria-label` can provide more detailed interaction information. |
| `disabled` | `button.pf-v5-c-button` | When a button element is used, indicates that it is unavailable and removes it from keyboard focus. **Required when button is disabled** |
| `aria-disabled="true"` | `button.pf-v5-c-button` | When a button element is used, indicates that it is unavailable but does not prevent keyboard or hover interactions. Used when a disabled button provides interactive elements like a tooltip. |
| `aria-disabled="true"` | `a.pf-v5-c-button.pf-m-disabled`, `span.pf-v5-c-button.pf-m-link.pf-m-inline.pf-m-disabled` | When a non-button element is used, indicates that it is unavailable. **Required when element is disabled** |
| `aria-expanded="true"` | `.pf-v5-c-button.pf-m-expanded` | Indicates that the expanded content element is visible. **Required** |
| `tabindex="-1"` | `a.pf-v5-c-button.pf-m-disabled`, `span.pf-v5-c-button.pf-m-link.pf-m-inline.pf-m-disabled` | When a non-button element is used, removes it from keyboard focus. **Required when element is disabled** |
| `tabindex="0"` | `span.pf-v5-c-button.pf-m-link.pf-m-inline` | Inserts the span into the tab order of the page so that it is focusable. **Required when the element is a span** |

### Usage

| Class | Applied to | Outcome |
| -- | -- | -- |
| `.pf-v5-c-button` | `<button>` |  Initiates a button. Always use it with a modifier class. **Required** |
| `.pf-v5-c-button__icon` | `<span>` | Initiates a button icon. |
| `.pf-v5-c-button__progress` | `<span>` | Initiates a button progress container. |
| `.pf-v5-c-button__count` | `<span>` | Initiates a button count container. **Note:** Count should only be used on link buttons.|
| `.pf-m-primary` | `.pf-v5-c-button` | Modifies for primary styles. |
| `.pf-m-secondary` | `.pf-v5-c-button` | Modifies for secondary styles. |
| `.pf-m-tertiary` | `.pf-v5-c-button` | Modifies for tertiary styles. |
| `.pf-m-danger` | `.pf-v5-c-button` | Modifies for danger styles. |
| `.pf-m-warning` | `.pf-v5-c-button` | Modifies for warning styles. |
| `.pf-m-link` | `.pf-v5-c-button` | Modifies for link styles. This button has no background or border and is styled as a link. This button would commonly appear in a form and may include an icon. |
| `.pf-m-plain` | `.pf-v5-c-button` | Modifies for icon styles. This button has no background or border, uses a standard text color, and is used for `.pf-m-plain` icon buttons such as close, expand, kebab, etc. |
| `.pf-m-no-padding` | `.pf-v5-c-button.pf-m-plain` | Modifies a plain button to remove padding. This modifier should only be used when the button is inline within a sentence or block of text. Adjacent plain buttons without padding should always have spacing between them. |
| `.pf-m-inline` | `.pf-v5-c-button.pf-m-link` | Modifies for inline styles. This button is presented similar to a normal link and has no padding and is displayed inline with other inline content. When used as a `<span>`, the text will flow inline with text around it. |
| `.pf-m-block` | `.pf-v5-c-button` | Creates a block level button. |
| `.pf-m-control` | `.pf-v5-c-button` | Modifies for control styles. **Note:** This modifier should only be used when using buttons in the Input Group or Clipboard Copy components. |
| `.pf-m-expanded` | `.pf-v5-c-button.pf-m-control` | Modifies a control button for the expanded state. |
| `.pf-m-start` | `.pf-v5-c-button__icon` | Applies right spacing to an icon inside of a button when the icon comes before text. |
| `.pf-m-end` | `.pf-v5-c-button__icon` | Applies left spacing to an icon inside of a button when the icon comes after text. |
| `.pf-m-active` | `.pf-v5-c-button` | Forces display of the active state of the button. This modifier should be used when `aria-pressed` is set to true so that the button displays in an active state. |
| `.pf-m-small` | `.pf-v5-c-button` | Modifies the button so that it has small font size. |
| `.pf-m-aria-disabled` | `.pf-v5-c-button` | Modifies a button to be visually disabled, yet is still focusable. |
| `.pf-m-display-lg` | `.pf-v5-c-button`, `pf-v5-c-button.pf-m-link` | Modifies the button and link button for large display styling. For example, use this modifier to achieve "call to action" styles. |
| `.pf-m-progress` | `.pf-v5-c-button` | Indicates that the button supports the progress state. **Note:** Not used with the plain variation. |
| `.pf-m-in-progress` | `.pf-v5-c-button` | Indicates that the button is in the in progress state. |
