Hello and thank you for your interest in our project :)


Tips for a good bugreport
-------------------------------

* Help us help you! The more details you give, the better we\'ll be able to
  help you out.

* Please use markdown syntax, especially for backtraces and config files!

* Please provide a minimal working example. That means, you should try to
  replicate your issue with the minimal configuration from your muttrc and/or
  any other relevant config files. These are the details you should be posting.

* Sometimes even small and inconspicuous details matter, so please be very
  careful when writing down the steps to reproduce your problem.

* Please give us a list of program versions of **every** program relevant to
  your report.



Tips for writing a good feature request
---------------------------------------

* Describe your problem and especially the context of it very detailed. It has
  happened many times, that the problem could be solved without implementing
  another feature.

* Please describe also your desired solution carefully. Nothing is more
  frustrating - for both you and us, as developers - if we understand your
  problem the wrong way and implement something which doesn't help you.



Tips for writing good pull requests
---------------------------------------

* The first line should be a short (50 characters or less) summary of your
  commit message. If you can't find a short enough one-line summary, split the
  commit into multiple ones.

* Keep one line between the one-line summary and the body.

* Use bullet points in the body of the commit message to separate multiple
  things you did.

* your commits should be clear and concise. That means also you shouldn't sum up
  two features or two bug fixes into one commit. If you do, it makes both bug
  fixes or features harder to understand. Also, don't hesitate to
  [rewrite](https://git-scm.com/book/en/v2/Git-Tools-Rewriting-History) the
  Github history of your development branch.

* Wrap the body of the commit message at around 80 characters.

* if your commit addresses a particular PR, commit or Issue, please say so in
  your commit. The Github documentation
  ([1](https://help.github.com/articles/autolinked-references-and-urls/)
  and [2](https://help.github.com/articles/closing-issues-via-commit-messages/))
  can help you with that.

* Please eliminate any warnings gcc or any other tool produces during the
  compilation stage.

* If your commit addresses only a specific method or a specific file, please say
  so in your commit.

Thank you for your help!

The Neomutt Team.
