/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.bean;

import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.IndicationSense;
import org.jsmpp.bean.IndicationType;

public class MessageWaitingDataCoding
implements DataCoding {
    private final IndicationSense indicationSense;
    private final IndicationType indicationType;
    private final Alphabet alphabet;

    public MessageWaitingDataCoding(IndicationSense indicationSense, IndicationType indicationType) {
        this(indicationSense, indicationType, null);
    }

    public MessageWaitingDataCoding(IndicationSense indicationSense, IndicationType indicationType, Alphabet alphabet) throws IllegalArgumentException {
        if (alphabet != null && (alphabet.isUnspecified() || alphabet.isReserved())) {
            throw new IllegalArgumentException("Supported alphabet for SimpleDataCoding is one of " + (Object)((Object)Alphabet.ALPHA_DEFAULT) + ", " + (Object)((Object)Alphabet.ALPHA_UNSPECIFIED_2) + " or " + (Object)((Object)Alphabet.ALPHA_8_BIT) + " only. Current alphabet is " + (Object)((Object)alphabet));
        }
        this.indicationSense = indicationSense;
        this.indicationType = indicationType;
        this.alphabet = alphabet;
    }

    public boolean isStoreMessage() {
        return this.alphabet != null;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public IndicationSense getIndicationSense() {
        return this.indicationSense;
    }

    public IndicationType getIndicationType() {
        return this.indicationType;
    }

    @Override
    public byte toByte() {
        byte value = 0;
        if (!this.isStoreMessage()) {
            value = -64;
        } else if (this.alphabet.equals((Object)Alphabet.ALPHA_DEFAULT)) {
            value = -48;
        } else if (this.alphabet.equals((Object)Alphabet.ALPHA_UCS2)) {
            value = -32;
        }
        value = (byte)(value | this.indicationSense.value());
        value = (byte)(value | this.indicationType.value());
        return value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alphabet == null ? 0 : this.alphabet.hashCode());
        result = 31 * result + (this.indicationSense == null ? 0 : this.indicationSense.hashCode());
        result = 31 * result + (this.indicationType == null ? 0 : this.indicationType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageWaitingDataCoding other = (MessageWaitingDataCoding)obj;
        if (this.alphabet == null ? other.alphabet != null : !this.alphabet.equals((Object)other.alphabet)) {
            return false;
        }
        if (this.indicationSense == null ? other.indicationSense != null : !this.indicationSense.equals((Object)other.indicationSense)) {
            return false;
        }
        return !(this.indicationType == null ? other.indicationType != null : !this.indicationType.equals((Object)other.indicationType));
    }

    public String toString() {
        return "DataCoding:" + (0xFF & this.toByte());
    }
}

